/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.component;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public final class UndoService
implements Component,
ServerTickingComponent {
    private final Map<UUID, Deque<UndoData>> histories = new HashMap<UUID, Deque<UndoData>>();
    private int tick;

    public void insertUndo(UUID uuid, Undo undo) {
        Deque deque = this.histories.computeIfAbsent(uuid, $ -> new LinkedList());
        deque.push(new UndoData(System.currentTimeMillis() + (long)BuildingGadgets.getConfig().gadgets.undoExpiry, undo));
        while (deque.size() > BuildingGadgets.getConfig().gadgets.undoSize) {
            deque.removeLast();
        }
    }

    public Optional<Undo> getUndo(UUID uuid) {
        UndoData poll;
        Deque<UndoData> deque = this.histories.get(uuid);
        if (deque != null && (poll = deque.poll()) != null) {
            return Optional.ofNullable(poll.undo());
        }
        return Optional.empty();
    }

    public void readFromNbt(class_2487 tag) {
        this.histories.clear();
        for (String key : tag.method_10541()) {
            LinkedList<UndoData> history = new LinkedList<UndoData>();
            for (class_2520 d : tag.method_10554(key, 0)) {
                class_2487 data = (class_2487)d;
                history.add(new UndoData(data.method_10537("Expiry"), Undo.deserialize(data.method_10562("Undo"))));
            }
            this.histories.put(UUID.fromString(key), history);
        }
    }

    public void writeToNbt(class_2487 tag) {
        this.histories.forEach((uuid, history) -> {
            class_2499 list = new class_2499();
            for (UndoData data : history) {
                class_2487 inner = new class_2487();
                inner.method_10544("Expiry", data.expiry());
                inner.method_10566("Undo", (class_2520)data.undo().serialize());
                list.add((Object)inner);
            }
            tag.method_10566(uuid.toString(), (class_2520)list);
        });
    }

    public void serverTick() {
        if (++this.tick % 600 == 0) {
            long now = System.currentTimeMillis();
            this.histories.entrySet().removeIf(entry -> {
                ((Deque)entry.getValue()).removeIf(data -> data.expiry >= now);
                return ((Deque)entry.getValue()).isEmpty();
            });
        }
    }

    private record UndoData(long expiry, Undo undo) {
    }
}

