/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.ScrollingMaterialList;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.component.BGComponent;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.direwolf20.buildinggadgets.common.util.lang.MaterialListTranslation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class MaterialListGUI
extends class_437
implements ITemplateProvider.IUpdateListener {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTONS_PADDING = 4;
    public static final class_2960 BACKGROUND_TEXTURE = new class_2960("buildinggadgets", "textures/gui/material_list.png");
    public static final int BACKGROUND_WIDTH = 256;
    public static final int BACKGROUND_HEIGHT = 200;
    public static final int BORDER_SIZE = 4;
    public static final int WINDOW_WIDTH = 248;
    public static final int WINDOW_HEIGHT = 192;
    private int backgroundX;
    private int backgroundY;
    private final class_1799 item;
    private String title;
    private int titleLeft;
    private int titleTop;
    private ScrollingMaterialList scrollingList;
    private class_4185 buttonSortingModes;
    private class_4185 buttonCopyList;
    private List<class_2561> hoveringText;
    private TemplateHeader header;

    public MaterialListGUI(class_1799 item) {
        super((class_2561)MaterialListTranslation.TITLE.componentTranslation(new Object[0]));
        Preconditions.checkArgument((BGComponent.TEMPLATE_KEY_COMPONENT.getNullable((Object)item) != null ? 1 : 0) != 0);
        this.item = item;
    }

    public void method_25426() {
        this.backgroundX = MaterialListGUI.getXForAlignedCenter(0, this.field_22789, 256);
        this.backgroundY = MaterialListGUI.getYForAlignedCenter(0, this.field_22790, 200);
        this.header = this.evaluateTemplateHeader();
        this.evaluateTitle();
        this.scrollingList = new ScrollingMaterialList(this);
        this.method_25395((class_364)this.scrollingList);
        this.method_37063((class_364)this.scrollingList);
        int buttonY = this.getWindowBottomY() - 26;
        class_4185 buttonClose = new class_4185(0, buttonY, 0, 20, (class_2561)MaterialListTranslation.BUTTON_CLOSE.componentTranslation(new Object[0]), b -> class_310.method_1551().field_1724.method_7346());
        this.buttonSortingModes = new class_4185(0, buttonY, 0, 20, (class_2561)this.scrollingList.getSortingMode().getTranslationProvider().componentTranslation(new Object[0]), button -> {
            this.scrollingList.setSortingMode(this.scrollingList.getSortingMode().next());
            this.buttonSortingModes.method_25355((class_2561)this.scrollingList.getSortingMode().getTranslationProvider().componentTranslation(new Object[0]));
        });
        this.buttonCopyList = new class_4185(0, buttonY, 0, 20, (class_2561)MaterialListTranslation.BUTTON_COPY.componentTranslation(new Object[0]), button -> {
            class_310.method_1551().field_1774.method_1455(this.evaluateTemplateHeader().toJson(false, MaterialListGUI.method_25441()));
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)new class_2588(MaterialListTranslation.MESSAGE_COPY_SUCCESS.getTranslationKey()), true);
            }
        });
        this.method_37063((class_364)this.buttonSortingModes);
        this.method_37063((class_364)this.buttonCopyList);
        this.method_37063((class_364)buttonClose);
        this.calculateButtonsWidthAndX();
    }

    public TemplateHeader evaluateTemplateHeader() {
        Template template = this.getTemplateCapability();
        BuildContext context = BuildContext.builder().player((class_1657)class_310.method_1551().field_1724).stack(this.getTemplateItem()).build((class_1936)class_310.method_1551().field_1687);
        return template.getHeaderAndForceMaterials(context);
    }

    public TemplateHeader getHeader() {
        return this.header;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float particleTicks) {
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
        this.method_25302(matrices, this.backgroundX, this.backgroundY, 0, 0, 256, 200);
        this.scrollingList.method_25394(matrices, mouseX, mouseY, particleTicks);
        MaterialListGUI.method_25303((class_4587)matrices, (class_327)this.field_22793, (String)this.title, (int)this.titleLeft, (int)this.titleTop, (int)Color.WHITE.getRGB());
        super.method_25394(matrices, mouseX, mouseY, particleTicks);
        if (this.buttonCopyList.method_25405((double)mouseX, (double)mouseY)) {
            this.method_25417(matrices, Lists.transform((List)ImmutableList.of((Object)MaterialListTranslation.HELP_COPY_LIST.componentTranslation(new Object[0])), class_2561::method_30937), mouseX, mouseY);
        } else if (this.hoveringText != null) {
            this.method_25417(matrices, Lists.transform(this.hoveringText, class_2561::method_30937), mouseX, mouseY);
            this.hoveringText = null;
        }
    }

    private void calculateButtonsWidthAndX() {
        int amountButtons = (int)this.method_25396().stream().filter(e -> e instanceof class_4185).count();
        int amountMargins = amountButtons - 1;
        int totalMarginWidth = amountMargins * 4;
        int usableWidth = this.getWindowWidth();
        int buttonWidth = (usableWidth - totalMarginWidth) / amountButtons;
        int nextX = this.getWindowLeftX();
        for (class_364 widget : this.method_25396()) {
            class_364 class_3642 = widget;
            if (!(class_3642 instanceof class_4185)) continue;
            class_4185 btn = (class_4185)class_3642;
            btn.method_25358(buttonWidth);
            btn.field_22760 = nextX;
            nextX += buttonWidth + 4;
        }
    }

    public Template getTemplateCapability() {
        if (class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 == null) {
            return null;
        }
        Optional providerCap = BGComponent.TEMPLATE_PROVIDER_COMPONENT.maybeGet((Object)this.field_22787.field_1687);
        if (providerCap.isPresent()) {
            Optional keyCap = BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)this.item);
            ITemplateProvider provider = (ITemplateProvider)providerCap.orElseThrow(RuntimeException::new);
            if (keyCap.isPresent()) {
                provider.registerUpdateListener(this);
                ITemplateKey key = (ITemplateKey)keyCap.orElseThrow(RuntimeException::new);
                return provider.getTemplateForKey(key);
            }
            BuildingGadgets.LOG.warn("Item used for material list does not have an ITemplateKey component!");
            this.field_22787.field_1724.method_7346();
            return null;
        }
        BuildingGadgets.LOG.warn("Client world used for material list does not have an ITemplateProvider component!");
        this.field_22787.field_1724.method_7346();
        return null;
    }

    public void setTaskHoveringText(int x, int y, List<class_2561> text) {
        this.hoveringText = text;
    }

    @Override
    public void onTemplateUpdate(ITemplateProvider provider, ITemplateKey key, Template template) {
        BGComponent.TEMPLATE_KEY_COMPONENT.maybeGet((Object)this.item).ifPresent(itemKey -> {
            UUID itemId;
            UUID keyId = provider.getId(key);
            if (keyId.equals(itemId = provider.getId((ITemplateKey)itemKey))) {
                this.header = this.evaluateTemplateHeader();
                this.evaluateTitle();
                this.scrollingList.reset();
            }
        });
    }

    private void evaluateTitle() {
        String name = this.getHeader().getName();
        String author = this.getHeader().getAuthor();
        this.title = name == null && author == null ? MaterialListTranslation.TITLE_EMPTY.format(new Object[0]) : (name == null ? MaterialListTranslation.TITLE_AUTHOR_ONLY.format(author) : (author == null ? MaterialListTranslation.TITLE_NAME_ONLY.format(name) : MaterialListTranslation.TITLE.format(name, author)));
        int n = this.getWindowTopY() + 16;
        Objects.requireNonNull(this.field_22793);
        this.titleTop = MaterialListGUI.getYForAlignedCenter(this.backgroundY, n, 9);
        this.titleLeft = MaterialListGUI.getXForAlignedCenter(this.backgroundX, this.getWindowRightX(), this.field_22793.method_1727(this.title));
    }

    public boolean method_25421() {
        return false;
    }

    public int getWindowLeftX() {
        return this.backgroundX + 4;
    }

    public int getWindowRightX() {
        return this.backgroundX + 256 - 4;
    }

    public int getWindowTopY() {
        return this.backgroundY + 4;
    }

    public int getWindowBottomY() {
        return this.backgroundY + 200 - 4;
    }

    public int getWindowWidth() {
        return 248;
    }

    public int getWindowHeight() {
        return 192;
    }

    public class_1799 getTemplateItem() {
        return this.item;
    }

    public static int getXForAlignedRight(int right, int width) {
        return right - width;
    }

    public static int getXForAlignedCenter(int left, int right, int width) {
        return left + (right - left) / 2 - width / 2;
    }

    public static int getYForAlignedCenter(int top, int bottom, int height) {
        return top + (bottom - top) / 2 - height / 2;
    }

    public static void renderTextVerticalCenter(class_4587 matrices, String text, int leftX, int top, int bottom, int color) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        Objects.requireNonNull(fontRenderer);
        int y = MaterialListGUI.getYForAlignedCenter(top, bottom, 9);
        RenderSystem.enableTexture();
        fontRenderer.method_1729(matrices, text, (float)leftX, (float)y, color);
    }

    public static void renderTextHorizontalRight(class_4587 matrices, String text, int right, int y, int color) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int x = MaterialListGUI.getXForAlignedRight(right, fontRenderer.method_1727(text));
        RenderSystem.enableTexture();
        fontRenderer.method_1729(matrices, text, (float)x, (float)y, color);
    }

    public static boolean isPointInBox(double x, double y, int bx, int by, int width, int height) {
        return x >= (double)bx && y >= (double)by && x < (double)(bx + width) && y < (double)(by + height);
    }
}

