/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.renders;

import com.direwolf20.buildinggadgets.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_776;

public class BuildRender
extends BaseRenderer {
    private final boolean isExchanger;
    private static final class_2680 DEFAULT_EFFECT_BLOCK = OurBlocks.EFFECT_BLOCK.method_9564();

    public BuildRender(boolean isExchanger) {
        this.isExchanger = isExchanger;
    }

    @Override
    public void render(WorldRenderContext evt, class_1657 player, class_1799 heldItem) {
        super.render(evt, player, heldItem);
        class_3965 lookingAt = VectorHelper.getLookingAt(player, heldItem);
        class_2680 startBlock = player.field_6002.method_8320(lookingAt.method_17777());
        Optional<List<class_2338>> anchor = GadgetUtils.getAnchor(heldItem);
        if (player.field_6002.method_22347(lookingAt.method_17777()) && anchor.isEmpty() || startBlock == DEFAULT_EFFECT_BLOCK) {
            return;
        }
        BlockData data = GadgetUtils.getToolBlock(heldItem);
        class_2680 renderBlockState = data.getState();
        if (renderBlockState == BaseRenderer.AIR) {
            return;
        }
        List coordinates = anchor.orElseGet(() -> {
            AbstractMode mode = !this.isExchanger ? GadgetBuilding.getToolMode(heldItem).getMode() : GadgetExchanger.getToolMode(heldItem).getMode();
            return mode.getCollection(new AbstractMode.UseContext(player.field_6002, renderBlockState, lookingAt.method_17777(), heldItem, lookingAt.method_17780(), !this.isExchanger && GadgetBuilding.shouldPlaceAtop(heldItem), GadgetBuilding.getConnectedArea(heldItem)), player);
        });
        BuildRender.getBuilderWorld().setWorldAndState(player.field_6002, renderBlockState, coordinates);
        class_243 playerPos = evt.camera().method_19326();
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        class_4587 matrix = evt.matrixStack();
        matrix.method_22903();
        matrix.method_22904(-playerPos.method_10216(), -playerPos.method_10214(), -playerPos.method_10215());
        class_776 dispatcher = evt.gameRenderer().method_35772().method_1541();
        RenderSystem.enableDepthTest();
        for (class_2338 coordinate : coordinates) {
            matrix.method_22903();
            matrix.method_22904((double)coordinate.method_10263(), (double)coordinate.method_10264(), (double)coordinate.method_10260());
            if (this.isExchanger) {
                matrix.method_22904((double)-5.0E-4f, (double)-5.0E-4f, (double)-5.0E-4f);
                matrix.method_22905(1.001f, 1.001f, 1.001f);
            }
            OurRenderTypes.MultiplyAlphaRenderTypeBuffer mutatedBuffer = new OurRenderTypes.MultiplyAlphaRenderTypeBuffer((class_4597)class_310.method_1551().method_22940().method_23000(), 0.55f);
            dispatcher.method_3353(renderBlockState, matrix, (class_4597)mutatedBuffer, 0xF00000, class_4608.field_21444);
            matrix.method_22909();
            buffer.method_22993();
        }
        RenderSystem.disableDepthTest();
        if (!player.method_7337()) {
            boolean hasLinkedInventory = BuildRender.getCacheInventory().maintainCache(heldItem);
            int remainingCached = BuildRender.getCacheInventory().getCache() == null ? -1 : BuildRender.getCacheInventory().getCache().count((Object)ItemVariant.of((class_1935)data.getState().method_26204().method_8389()));
            IItemIndex index = InventoryHelper.index(heldItem, player);
            BuildContext context = new BuildContext((class_1936)player.field_6002, player, heldItem);
            MaterialList materials = data.getRequiredItems(context, null, null);
            long hasEnergy = this.getEnergy(player, heldItem);
            try (Transaction transaction = Transaction.openOuter();){
                for (class_2338 coordinate : coordinates) {
                    boolean renderFree = false;
                    MatchResult match = index.match(materials, (TransactionContext)transaction);
                    class_4588 builder = buffer.getBuffer(OurRenderTypes.MissingBlockOverlay);
                    if (!match.isSuccess() || (hasEnergy -= ((AbstractGadget)heldItem.method_7909()).getEnergyCost(heldItem)) < 0L) {
                        if (hasLinkedInventory && remainingCached > 0) {
                            renderFree = true;
                            --remainingCached;
                        } else {
                            BuildRender.renderMissingBlock(matrix.method_23760().method_23761(), builder, coordinate);
                        }
                    } else {
                        BuildRender.renderBoxSolid(matrix.method_23760().method_23761(), builder, coordinate, 0.97f, 1.0f, 0.99f, 0.1f);
                    }
                    if (!renderFree) continue;
                    BuildRender.renderBoxSolid(matrix.method_23760().method_23761(), builder, coordinate, 0.97f, 1.0f, 0.99f, 0.1f);
                }
            }
        }
        matrix.method_22909();
        RenderSystem.disableDepthTest();
        buffer.method_22993();
    }

    @Override
    public boolean isLinkable() {
        return true;
    }
}

