/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.cache;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.network.Target;
import com.direwolf20.buildinggadgets.common.network.bidirection.PacketRequestTemplate;
import com.direwolf20.buildinggadgets.common.network.bidirection.SplitPacketUpdateTemplate;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2598;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public final class CacheTemplateProvider
implements ITemplateProvider {
    private final Cache<UUID, Template> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Set<ITemplateProvider.IUpdateListener> updateListeners = Collections.newSetFromMap(new WeakHashMap());

    @Override
    @NotNull
    public Template getTemplateForKey(@NotNull ITemplateKey key) {
        UUID id = this.getId(key);
        try {
            return (Template)this.cache.get((Object)id, () -> {
                this.requestUpdate(id, new Target(class_2598.field_11941, null));
                return new Template();
            });
        }
        catch (ExecutionException e) {
            BuildingGadgets.LOG.error("Failed to access Cache! Returning new Template, this is certainly going to cause unexpected behaviour!", (Throwable)e);
            return new Template();
        }
    }

    @Override
    public void setTemplate(ITemplateKey key, Template template) {
        UUID id = this.getId(key);
        this.cache.put((Object)id, (Object)template);
        this.notifyListeners(key, template, l -> l::onTemplateUpdate);
    }

    @Override
    public boolean requestUpdate(ITemplateKey key) {
        return this.requestUpdate(key, new Target(class_2598.field_11941, null));
    }

    @Override
    public boolean requestUpdate(ITemplateKey key, Target target) {
        return this.requestUpdate(key.getOrComputeId(UUID::randomUUID), target);
    }

    private boolean requestUpdate(UUID id, Target target) {
        PacketRequestTemplate.sendToTarget(target, id);
        return true;
    }

    @Override
    public boolean requestRemoteUpdate(ITemplateKey key, Target target) {
        UUID id = this.getId(key);
        Template template = (Template)this.cache.getIfPresent((Object)id);
        if (template != null) {
            this.notifyListeners(key, template, l -> l::onTemplateUpdateSend);
            SplitPacketUpdateTemplate.sendToTarget(target, id, template);
        }
        return template != null;
    }

    @Override
    public boolean requestRemoteUpdate(ITemplateKey key, class_1937 level) {
        return this.requestRemoteUpdate(key, new Target(class_2598.field_11941, null));
    }

    @Override
    public void registerUpdateListener(ITemplateProvider.IUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    @Override
    public void removeUpdateListener(ITemplateProvider.IUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    @Override
    public UUID getId(ITemplateKey key) {
        return key.getOrComputeId(UUID::randomUUID);
    }

    public void clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private void notifyListeners(ITemplateKey key, Template template, Function<ITemplateProvider.IUpdateListener, TriConsumer<ITemplateProvider, ITemplateKey, Template>> function) {
        for (ITemplateProvider.IUpdateListener listener : this.updateListeners) {
            try {
                function.apply(listener).accept((Object)this, (Object)key, (Object)template);
            }
            catch (Exception e) {
                BuildingGadgets.LOG.error("Update listener threw an exception!", (Throwable)e);
            }
        }
    }

    public void readFromNbt(class_2487 tag) {
    }

    public void writeToNbt(class_2487 tag) {
    }
}

