/*
 * Decompiled with CFR 0.152.
 */
package tfar.overpoweredarmorbar.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5134;
import tfar.overpoweredarmorbar.ConfigurationHandler;
import tfar.overpoweredarmorbar.RenderGameOverlayEvent;
import tfar.overpoweredarmorbar.overlay.ArmorBar;
import tfar.overpoweredarmorbar.overlay.ArmorIcon;
import tfar.overpoweredarmorbar.overlay.ArmorIconColor;

public class OverlayEventHandler {
    private static final int UNKNOWN_ARMOR_VALUE = -1;
    private int previousArmorValue = -1;
    private static final int ARMOR_ICON_SIZE = 9;
    private static final int ARMOR_SECOND_HALF_ICON_SIZE = 4;
    private class_310 mc = class_310.method_1551();
    private ArmorIcon[] armorIcons;

    public static void drawTexturedModalRect(class_4587 stack, int x, int y, int textureX, int textureY, int width, int height) {
        class_310.method_1551().field_1705.method_25302(stack, x, y, textureX, textureY, width, height);
    }

    public void onRenderGameOverlayEventPre(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ARMOR) {
            return;
        }
        int scaledWidth = this.mc.method_22683().method_4486();
        int scaledHeight = this.mc.method_22683().method_4502();
        this.renderArmorBar(event.getMatrixStack(), scaledWidth, scaledHeight);
        event.setCanceled(true);
    }

    private int calculateArmorValue() {
        return (int)this.mc.field_1724.method_5996(class_5134.field_23724).method_6194();
    }

    public void renderArmorBar(class_4587 stack, int screenWidth, int screenHeight) {
        int currentArmorValue = this.calculateArmorValue();
        int xStart = screenWidth / 2 - 91;
        int yPosition = screenHeight - 49;
        if (currentArmorValue != this.previousArmorValue) {
            this.armorIcons = ArmorBar.calculateArmorIcons(currentArmorValue);
            this.previousArmorValue = currentArmorValue;
        }
        int armorIconCounter = 0;
        for (ArmorIcon icon : this.armorIcons) {
            int xPosition = xStart + armorIconCounter * 8;
            switch (icon.armorIconType) {
                case NONE: {
                    ArmorIconColor color = icon.primaryArmorIconColor;
                    OverlayEventHandler.color4f(color.Red, color.Green, color.Blue, color.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 34, 9, 9, 9);
                        break;
                    }
                    if (!ConfigurationHandler.showEmptyArmorIcons() || !ConfigurationHandler.alwaysShowArmorBar() && currentArmorValue <= 0) break;
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 16, 9, 9, 9);
                    break;
                }
                case HALF: {
                    ArmorIconColor firstHalfColor = icon.primaryArmorIconColor;
                    ArmorIconColor secondHalfColor = icon.secondaryArmorIconColor;
                    OverlayEventHandler.color4f(firstHalfColor.Red, firstHalfColor.Green, firstHalfColor.Blue, firstHalfColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 25, 9, 5, 9);
                    OverlayEventHandler.color4f(secondHalfColor.Red, secondHalfColor.Green, secondHalfColor.Blue, secondHalfColor.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(stack, xPosition + 5, yPosition, 39, 9, 4, 9);
                        break;
                    }
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition + 5, yPosition, 30, 9, 4, 9);
                    break;
                }
                case FULL: {
                    ArmorIconColor fullColor = icon.primaryArmorIconColor;
                    OverlayEventHandler.color4f(fullColor.Red, fullColor.Green, fullColor.Blue, fullColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 34, 9, 9, 9);
                    break;
                }
            }
            ++armorIconCounter;
        }
        OverlayEventHandler.color4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void color4f(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }
}

