/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.tool.attribute;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.mininglevel.v1.FabricMineableTags;
import net.fabricmc.fabric.api.mininglevel.v1.MiningLevelManager;
import net.fabricmc.fabric.api.tool.attribute.v1.DynamicAttributeTool;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolManagerImpl {
    private static final Map<class_3494<class_1792>, class_3494<class_2248>> MINEABLE_TAG_BY_TOOL = ImmutableMap.builder().put(FabricToolTags.AXES, (Object)class_3481.field_33713).put(FabricToolTags.HOES, (Object)class_3481.field_33714).put(FabricToolTags.PICKAXES, (Object)class_3481.field_33715).put(FabricToolTags.SHOVELS, (Object)class_3481.field_33716).put(FabricToolTags.SHEARS, (Object)FabricMineableTags.SHEARS_MINEABLE).put(FabricToolTags.SWORDS, (Object)FabricMineableTags.SWORD_MINEABLE).build();
    private static final Map<class_3494<class_1792>, Event<ToolHandler>> HANDLER_MAP = new HashMap<class_3494<class_1792>, Event<ToolHandler>>();
    private static final Event<ToolHandler> GENERAL_TOOLS_HANDLER = EventFactory.createArrayBacked(ToolHandler.class, ToolManagerImpl::toolHandlerInvoker);
    private static final Map<class_2248, EntryImpl> ENTRIES = new IdentityHashMap<class_2248, EntryImpl>();

    public static Event<ToolHandler> tag(class_3494<class_1792> tag) {
        for (Map.Entry<class_3494<class_1792>, Event<ToolHandler>> entry : HANDLER_MAP.entrySet()) {
            if (!(tag instanceof class_3494.class_5123 ? ((class_3494.class_5123)entry.getKey()).method_26791().equals((Object)((class_3494.class_5123)tag).method_26791()) : entry.getKey().equals(tag))) continue;
            return entry.getValue();
        }
        HANDLER_MAP.put(tag, (Event<ToolHandler>)EventFactory.createArrayBacked(ToolHandler.class, ToolManagerImpl::toolHandlerInvoker));
        return HANDLER_MAP.get(tag);
    }

    public static Event<ToolHandler> general() {
        return GENERAL_TOOLS_HANDLER;
    }

    private static ToolHandler toolHandlerInvoker(final ToolHandler[] toolHandlers) {
        return new ToolHandler(){

            @Override
            @NotNull
            public class_1269 isEffectiveOn(class_3494<class_1792> tag, class_2680 state, class_1799 stack, class_1309 user) {
                for (ToolHandler toolHandler : toolHandlers) {
                    class_1269 effectiveOn = Objects.requireNonNull(toolHandler.isEffectiveOn(tag, state, stack, user));
                    if (effectiveOn == class_1269.field_5811) continue;
                    return effectiveOn;
                }
                return class_1269.field_5811;
            }

            @Override
            @NotNull
            public class_1271<Float> getMiningSpeedMultiplier(class_3494<class_1792> tag, class_2680 state, class_1799 stack, class_1309 user) {
                for (ToolHandler toolHandler : toolHandlers) {
                    class_1271<Float> miningSpeedMultiplier = Objects.requireNonNull(toolHandler.getMiningSpeedMultiplier(tag, state, stack, user));
                    if (miningSpeedMultiplier.method_5467() == class_1269.field_5811) continue;
                    return miningSpeedMultiplier;
                }
                return class_1271.method_22430((Object)Float.valueOf(1.0f));
            }
        };
    }

    public static Entry entry(class_2248 block) {
        return ENTRIES.computeIfAbsent(block, bb -> new EntryImpl(block));
    }

    @Nullable
    public static Entry entryNullable(class_2248 block) {
        return ENTRIES.get(block);
    }

    @Deprecated
    public static void registerBreakByHand(class_2248 block, boolean value) {
        ToolManagerImpl.entry(block).setBreakByHand(value);
    }

    @Deprecated
    public static void registerBreakByTool(class_2248 block, class_3494<class_1792> tag, int miningLevel) {
        ToolManagerImpl.entry(block).putBreakByTool(tag, miningLevel);
    }

    public static boolean handleIsEffectiveOnIgnoresVanilla(class_2680 state, class_1799 stack, @Nullable class_1309 user, boolean vanillaResult) {
        for (Map.Entry<class_3494<class_1792>, Event<ToolHandler>> eventEntry : HANDLER_MAP.entrySet()) {
            if (!stack.method_31573(eventEntry.getKey())) continue;
            class_1269 effective = ((ToolHandler)eventEntry.getValue().invoker()).isEffectiveOn(eventEntry.getKey(), state, stack, user);
            if (effective.method_23665()) {
                return true;
            }
            effective = ((ToolHandler)ToolManagerImpl.general().invoker()).isEffectiveOn(eventEntry.getKey(), state, stack, user);
            if (!effective.method_23665()) continue;
            return true;
        }
        EntryImpl entry = (EntryImpl)ToolManagerImpl.entryNullable(state.method_26204());
        return entry != null && entry.defaultValue.get() || entry == null && vanillaResult;
    }

    public static float handleBreakingSpeedIgnoresVanilla(class_2680 state, class_1799 stack, @Nullable class_1309 user) {
        float breakingSpeed = 0.0f;
        class_3494<class_1792> handledTag = null;
        boolean handled = false;
        for (Map.Entry<class_3494<class_1792>, Event<ToolHandler>> eventEntry : HANDLER_MAP.entrySet()) {
            if (!stack.method_31573(eventEntry.getKey())) continue;
            class_1271<Float> speedMultiplier = Objects.requireNonNull(((ToolHandler)eventEntry.getValue().invoker()).getMiningSpeedMultiplier(eventEntry.getKey(), state, stack, user));
            if (speedMultiplier.method_5467().method_23665()) {
                handled = true;
                if (((Float)speedMultiplier.method_5466()).floatValue() > breakingSpeed) {
                    breakingSpeed = ((Float)speedMultiplier.method_5466()).floatValue();
                    handledTag = eventEntry.getKey();
                }
            }
            if (!(speedMultiplier = Objects.requireNonNull(((ToolHandler)ToolManagerImpl.general().invoker()).getMiningSpeedMultiplier(eventEntry.getKey(), state, stack, user))).method_5467().method_23665()) continue;
            handled = true;
            if (!(((Float)speedMultiplier.method_5466()).floatValue() > breakingSpeed)) continue;
            breakingSpeed = ((Float)speedMultiplier.method_5466()).floatValue();
            handledTag = eventEntry.getKey();
        }
        float f = breakingSpeed = handled ? breakingSpeed : 1.0f;
        if (stack.method_7909() instanceof DynamicAttributeTool) {
            breakingSpeed = ((DynamicAttributeTool)stack.method_7909()).postProcessMiningSpeed(handledTag, state, stack, user, breakingSpeed, handled);
        }
        return breakingSpeed;
    }

    public static interface ToolHandler {
        @NotNull
        default public class_1269 isEffectiveOn(class_3494<class_1792> tag, class_2680 state, class_1799 stack, @Nullable class_1309 user) {
            return class_1269.field_5811;
        }

        @NotNull
        default public class_1271<Float> getMiningSpeedMultiplier(class_3494<class_1792> tag, class_2680 state, class_1799 stack, @Nullable class_1309 user) {
            return class_1271.method_22430((Object)Float.valueOf(1.0f));
        }
    }

    public static interface Entry {
        public void setBreakByHand(boolean var1);

        public void putBreakByTool(class_3494<class_1792> var1, int var2);

        public int getMiningLevel(class_3494<class_1792> var1);
    }

    private static class EntryImpl
    implements Entry {
        private final class_2248 block;
        private class_3494<class_1792>[] tags = new class_3494[0];
        private int[] tagLevels = new int[0];
        private TriState defaultValue = TriState.DEFAULT;

        private EntryImpl(class_2248 block) {
            this.block = block;
        }

        @Override
        public void setBreakByHand(boolean value) {
            this.defaultValue = TriState.of((boolean)value);
        }

        @Override
        public void putBreakByTool(class_3494<class_1792> tag, int miningLevel) {
            ToolManagerImpl.tag(tag);
            for (int i = 0; i < this.tags.length; ++i) {
                if (this.tags[i] != tag) continue;
                this.tagLevels[i] = miningLevel;
                return;
            }
            this.tags = Arrays.copyOf(this.tags, this.tags.length + 1);
            this.tags[this.tags.length - 1] = tag;
            this.tagLevels = Arrays.copyOf(this.tagLevels, this.tagLevels.length + 1);
            this.tagLevels[this.tagLevels.length - 1] = miningLevel;
        }

        @Override
        public int getMiningLevel(class_3494<class_1792> tag) {
            int miningLevel = MiningLevelManager.getRequiredMiningLevel((class_2680)this.block.method_9564());
            for (int i = 0; i < this.tags.length; ++i) {
                if (this.tags[i] != tag) continue;
                miningLevel = Math.max(miningLevel, this.tagLevels[i]);
            }
            for (class_3494<class_1792> key : MINEABLE_TAG_BY_TOOL.keySet()) {
                if (tag != key || !MINEABLE_TAG_BY_TOOL.get(key).method_15141((Object)this.block)) continue;
                miningLevel = Math.max(miningLevel, 0);
            }
            return miningLevel;
        }
    }
}

