/*
 * Decompiled with CFR 0.152.
 */
package net.reinderp.cyti.util.fluid;

public final class FluidValue {
    public static final FluidValue EMPTY = new FluidValue(0L);
    public static final FluidValue BUCKET_QUARTER = new FluidValue(20250L);
    public static final FluidValue BUCKET = new FluidValue(81000L);
    private final long rawValue;

    private static FluidValue fromMilliBuckets(long milliBuckets) {
        return new FluidValue(milliBuckets * 81L);
    }

    private FluidValue(long rawValue) {
        this.rawValue = rawValue;
    }

    public FluidValue multiply(long value) {
        return FluidValue.fromRaw(this.rawValue * value);
    }

    public FluidValue fraction(long divider) {
        return FluidValue.fromRaw(this.rawValue / divider);
    }

    public FluidValue add(FluidValue fluidValue) {
        return FluidValue.fromRaw(this.rawValue + fluidValue.rawValue);
    }

    public FluidValue subtract(FluidValue fluidValue) {
        return FluidValue.fromRaw(this.rawValue - fluidValue.rawValue);
    }

    public FluidValue min(FluidValue fluidValue) {
        return FluidValue.fromRaw(Math.min(this.rawValue, fluidValue.rawValue));
    }

    public boolean isEmpty() {
        return this.rawValue == 0L;
    }

    public boolean moreThan(FluidValue value) {
        return this.rawValue > value.rawValue;
    }

    public boolean equalOrMoreThan(FluidValue value) {
        return this.rawValue >= value.rawValue;
    }

    public boolean lessThan(FluidValue value) {
        return this.rawValue < value.rawValue;
    }

    public boolean lessThanOrEqual(FluidValue value) {
        return this.rawValue <= value.rawValue;
    }

    @Deprecated
    public long getRawValue() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidValue that = (FluidValue)o;
        return this.rawValue == that.rawValue;
    }

    @Deprecated
    public static FluidValue fromRaw(long rawValue) {
        if (rawValue < 0L) {
            rawValue = 0L;
        }
        return new FluidValue(rawValue);
    }
}

