/*
 * Decompiled with CFR 0.152.
 */
package net.reinderp.cyti.util.fluid;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.reinderp.cyti.util.fluid.FluidInstance;
import net.reinderp.cyti.util.fluid.FluidValue;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class FluidContainer
extends SnapshotParticipant<FluidInstance>
implements SingleSlotStorage<FluidVariant> {
    private final String name;
    @NotNull
    private FluidInstance fluidInstance = new FluidInstance();
    private final FluidValue capacity;

    public FluidContainer(String name, FluidValue capacity) {
        this.name = name;
        this.capacity = capacity;
    }

    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }

    public class_3611 getFluid() {
        return this.getFluidInstance().getFluid();
    }

    public FluidValue getFluidValueCapacity() {
        return this.capacity;
    }

    public FluidValue getFluidAmount() {
        return this.getFluidInstance().getAmount();
    }

    public FluidValue getFreeSpace() {
        return this.getFluidValueCapacity().subtract(this.getFluidAmount());
    }

    public boolean canFit(class_3611 fluid, FluidValue amount) {
        return this.isEmpty() || this.getFluid() == fluid && this.getFreeSpace().equalOrMoreThan(amount);
    }

    public boolean isFull() {
        return !this.getFluidInstance().isEmpty() && this.getFluidInstance().getAmount().equalOrMoreThan(this.getFluidValueCapacity());
    }

    public boolean isEmpty() {
        return this.getFluidInstance().isEmpty();
    }

    public final class_2487 write(class_2487 nbt) {
        class_2487 fluidContainerData = this.fluidInstance.write();
        nbt.method_10566(this.name, (class_2520)fluidContainerData);
        return nbt;
    }

    public final FluidContainer read(class_2487 nbt) {
        if (nbt.method_10545(this.name)) {
            this.setFluid(class_3612.field_15906);
            class_2487 fluidContainerData = nbt.method_10562(this.name);
            this.fluidInstance = new FluidInstance(fluidContainerData);
        }
        return this;
    }

    public void setFluid(@NotNull class_3611 f) {
        Validate.notNull((Object)f);
        this.fluidInstance.setFluid(f);
    }

    public void setFluid(@NotNull FluidInstance instance) {
        this.fluidInstance = instance;
    }

    public void setFluidAmount(FluidValue amount) {
        if (!this.fluidInstance.isEmptyFluid()) {
            this.fluidInstance.setAmount(amount);
        }
    }

    public void setFluidInstance(@NotNull FluidInstance fluidInstance) {
        this.fluidInstance = fluidInstance;
    }

    public void onInsert() {
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
        FluidVariant currentVariant = this.getResource();
        if (currentVariant.equals(insertedVariant) || currentVariant.isBlank()) {
            long insertedAmount = Math.min(maxAmount, this.getCapacity() - this.getAmount());
            if (insertedAmount > 0L) {
                this.updateSnapshots(transaction);
                if (currentVariant.isBlank()) {
                    this.fluidInstance.setAmount(FluidValue.EMPTY);
                }
                this.fluidInstance.setFluid(insertedVariant.getFluid());
                this.fluidInstance.setAmount(FluidValue.fromRaw(insertedAmount).add(this.getFluidAmount()));
                this.fluidInstance.setTag(insertedVariant.getNbt());
            }
            return insertedAmount;
        }
        return 0L;
    }

    public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)extractedVariant, (long)maxAmount);
        FluidVariant currentVariant = this.getResource();
        if (extractedVariant.equals(currentVariant)) {
            long extractedAmount = Math.min(maxAmount, this.getAmount());
            if (extractedAmount > 0L) {
                this.updateSnapshots(transaction);
                this.fluidInstance.subtractAmount(FluidValue.fromRaw(extractedAmount));
            }
            return extractedAmount;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public FluidVariant getResource() {
        return this.fluidInstance.getVariant();
    }

    public long getAmount() {
        return this.fluidInstance.getAmount().getRawValue();
    }

    public long getCapacity() {
        return this.getFluidValueCapacity().getRawValue();
    }

    protected FluidInstance createSnapshot() {
        return this.fluidInstance.copy();
    }

    protected void readSnapshot(FluidInstance snapshot) {
        this.setFluidInstance(snapshot);
    }
}

