/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures.coloramp;

import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.TextureManager;
import aztech.modern_industrialization.textures.coloramp.Coloramp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.class_1011;

public class BakableTargetColoramp
implements Coloramp {
    public static final ArrayList<BakableTargetColoramp> bakableTargetColoramps = new ArrayList();
    private final int meanRGB;
    private boolean isBaked = false;
    private String from;
    private String target;
    private final ArrayList<Double> fromLum = new ArrayList();
    private final ArrayList<Integer> toRgb = new ArrayList();
    private ArrayList<Double> virtualIndex;
    private ArrayList<Double> virtualIndexRgb;

    public BakableTargetColoramp(int meanRGB, String from, String target) {
        this.meanRGB = meanRGB;
        this.from = from;
        this.target = target;
        bakableTargetColoramps.add(this);
    }

    public BakableTargetColoramp(int meanRGB, String from) {
        this(meanRGB, from, from);
    }

    @Override
    public int getRGB(double luminance) {
        double xdown;
        if (!this.isBaked) {
            throw new IllegalStateException(String.format("Unbaked coloramp with mean RGB of %05X", this.meanRGB));
        }
        if (luminance > 1.0 || luminance < 0.0) {
            throw new IllegalStateException(String.format("Invalid luminence %f", luminance));
        }
        if (luminance == 0.0) {
            return 0;
        }
        if (luminance == 1.0) {
            return 0xFFFFFF;
        }
        int index = Collections.binarySearch(this.fromLum, luminance);
        if (index < 0) {
            index = -(index + 1);
        }
        double vup = this.fromLum.get(index);
        double xup = this.virtualIndex.get(index);
        double vdown = this.fromLum.get(index - 1);
        double interpolation = (luminance - vdown) * (xup - (xdown = this.virtualIndex.get(index - 1).doubleValue())) / (vup - vdown) + xdown;
        int r1 = Collections.binarySearch(this.virtualIndexRgb, interpolation);
        if (r1 < 0) {
            r1 = -(r1 + 1);
        }
        if (r1 == 0) {
            return 0;
        }
        double iup = this.virtualIndexRgb.get(r1);
        double idown = this.virtualIndexRgb.get(r1 - 1);
        double frac = (interpolation - idown) / (iup - idown);
        int r = (int)((double)TextureHelper.getR(this.toRgb.get(r1 - 1)) * (1.0 - frac) + frac * (double)TextureHelper.getR(this.toRgb.get(r1)));
        int g = (int)((double)TextureHelper.getG(this.toRgb.get(r1 - 1)) * (1.0 - frac) + frac * (double)TextureHelper.getG(this.toRgb.get(r1)));
        int b = (int)((double)TextureHelper.getB(this.toRgb.get(r1 - 1)) * (1.0 - frac) + frac * (double)TextureHelper.getB(this.toRgb.get(r1)));
        return TextureHelper.toRGB(r, g, b);
    }

    @Override
    public int getMeanRGB() {
        return this.meanRGB;
    }

    public void baked(TextureManager textureManager) {
        try {
            class_1011 from = textureManager.getAssetAsTexture(this.from);
            class_1011 to = textureManager.getAssetAsTexture(this.target);
            double maxFromLum = 0.0;
            for (int i = 0; i < from.method_4307(); ++i) {
                for (int j = 0; j < from.method_4323(); ++j) {
                    int argb = from.method_4315(i, j);
                    int a = TextureHelper.getA(argb);
                    if (a < 127) continue;
                    double lum = TextureHelper.getLuminance(argb);
                    maxFromLum = Math.max(lum, maxFromLum);
                    this.fromLum.add(lum);
                }
            }
            this.fromLum.add(0.0);
            this.fromLum.add(1.0);
            Collections.sort(this.fromLum);
            this.virtualIndex = new ArrayList();
            ArrayList<Double> fromLum2 = new ArrayList<Double>();
            int i = 0;
            while (i < this.fromLum.size()) {
                double s = this.fromLum.get(i);
                double index = (double)i / (double)(this.fromLum.size() - 1);
                int j = i;
                while (j + 1 < this.fromLum.size() && this.fromLum.get(j + 1) == s) {
                    ++j;
                    index += 0.5 / (double)(this.fromLum.size() - 1);
                }
                fromLum2.add(s);
                this.virtualIndex.add(index);
                i = j + 1;
            }
            this.fromLum.clear();
            this.fromLum.addAll(fromLum2);
            int rgbMaxLum = 0;
            double maxToLum = 0.0;
            for (int i2 = 0; i2 < to.method_4307(); ++i2) {
                for (int j = 0; j < to.method_4323(); ++j) {
                    int argb = to.method_4315(i2, j);
                    int a = TextureHelper.getA(argb);
                    if (a < 127) continue;
                    this.toRgb.add(argb);
                    double lum = TextureHelper.getLuminance(argb);
                    if (!(lum > maxToLum)) continue;
                    maxToLum = lum;
                    rgbMaxLum = argb;
                }
            }
            int r = Math.min((int)(1.0 / maxFromLum * (double)TextureHelper.getR(rgbMaxLum)), 255);
            int g = Math.min((int)(1.0 / maxFromLum * (double)TextureHelper.getG(rgbMaxLum)), 255);
            int b = Math.min((int)(1.0 / maxFromLum * (double)TextureHelper.getB(rgbMaxLum)), 255);
            this.toRgb.add(-16777216);
            this.toRgb.add(TextureHelper.fromArgb(255, r, g, b));
            Collections.sort(this.toRgb, Comparator.comparingDouble(TextureHelper::getLuminance));
            this.virtualIndexRgb = new ArrayList();
            ArrayList<Integer> toRgb2 = new ArrayList<Integer>();
            int i3 = 0;
            while (i3 < this.toRgb.size()) {
                int rgb = this.toRgb.get(i3);
                double index = (double)i3 / (double)(this.toRgb.size() - 1);
                int j = i3;
                while (j + 1 < this.toRgb.size() && this.toRgb.get(j + 1) == rgb) {
                    ++j;
                    index += 0.5 / (double)(this.toRgb.size() - 1);
                }
                toRgb2.add(rgb);
                this.virtualIndexRgb.add(index);
                i3 = j + 1;
            }
            this.toRgb.clear();
            this.toRgb.addAll(toRgb2);
            double index0 = this.virtualIndexRgb.get(0);
            for (int i4 = 0; i4 < this.virtualIndexRgb.size(); ++i4) {
                this.virtualIndexRgb.set(i4, this.virtualIndexRgb.get(i4) - index0);
            }
            double indexEnd = this.virtualIndexRgb.get(this.virtualIndexRgb.size() - 1);
            for (int i5 = 0; i5 < this.virtualIndexRgb.size(); ++i5) {
                this.virtualIndexRgb.set(i5, this.virtualIndexRgb.get(i5) / indexEnd);
            }
            if (this.fromLum.size() <= 1 || this.toRgb.size() <= 1) {
                throw new IllegalStateException(String.format("Could not correctly processed the coloramp from = %s, to = %s", this.from, this.target));
            }
            this.isBaked = true;
            from.close();
            to.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

