/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.recipe.json;

import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import aztech.modern_industrialization.recipe.json.RecipeJson;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ShapedRecipeJson
extends RecipeJson<ShapedRecipeJson> {
    public final String type = "minecraft:crafting_shaped";
    public final String[] pattern;
    public final Map<Character, ItemInput> key = new HashMap<Character, ItemInput>();
    public final Result result;

    public ShapedRecipeJson(String resultItem, int count, String ... pattern) {
        this.pattern = pattern;
        this.result = new Result(resultItem, count);
    }

    public ShapedRecipeJson addInput(char key, String maybeTag) {
        ItemInput input = maybeTag.startsWith("#") ? ItemInput.withTag(maybeTag.substring(1)) : ItemInput.withItem(maybeTag);
        if (this.key.put(Character.valueOf(key), input) != null) {
            throw new IllegalStateException("Key mapping is already registered: " + key);
        }
        return this;
    }

    public void validate() {
        if (this.pattern.length == 0 || this.pattern.length > 3) {
            throw new IllegalArgumentException("Invalid length " + this.pattern.length);
        }
        for (String string : this.pattern) {
            if (string.length() == this.pattern[0].length()) continue;
            throw new IllegalArgumentException("Pattern length mismatch: " + string.length() + ", expected " + this.pattern[0].length());
        }
        for (String string : this.pattern) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == ' ' || this.key.containsKey(Character.valueOf(string.charAt(i)))) continue;
                throw new IllegalArgumentException("Key " + string.charAt(i) + " is missing a mapping.");
            }
        }
        Iterator<Character> iterator = this.key.keySet().iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            boolean ok = false;
            block4: for (String string : this.pattern) {
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != c) continue;
                    ok = true;
                    continue block4;
                }
            }
            if (ok) continue;
            throw new IllegalArgumentException("Key mapping '" + c + "' is not used in the pattern.");
        }
    }

    public MIRecipeJson exportToAssembler() {
        return this.exportToMachine(MIMachineRecipeTypes.ASSEMBLER, 8, 200, 1);
    }

    public MIRecipeJson exportToMachine(MachineRecipeType machine, int eu, int duration, int division) {
        if (this.result.count % division != 0) {
            throw new IllegalArgumentException("Output must be divisible by division");
        }
        MIRecipeJson assemblerJson = MIRecipeJson.create(machine, eu, duration).addItemOutput(this.result.item, this.result.count / division);
        for (Map.Entry<Character, ItemInput> entry : this.key.entrySet()) {
            int count = 0;
            for (String row : this.pattern) {
                for (char c : row.toCharArray()) {
                    if (c != entry.getKey().charValue()) continue;
                    ++count;
                }
            }
            if (count % division != 0) {
                throw new IllegalArgumentException("Input must be divisible by division");
            }
            ItemInput input = entry.getValue();
            if (input.item != null) {
                assemblerJson.addItemInput(input.item, count / division);
                continue;
            }
            if (input.tag == null) continue;
            assemblerJson.addItemInput("#" + input.tag, count / division);
        }
        return assemblerJson;
    }

    public static class Result {
        public final String item;
        public int count;

        public Result(String item, int count) {
            this.item = item;
            this.count = count;
        }
    }

    public static class ItemInput {
        public final String item;
        public final String tag;

        private ItemInput(String item, String tag) {
            this.item = item;
            this.tag = tag;
        }

        public static ItemInput withItem(String item) {
            return new ItemInput(item, null);
        }

        public static ItemInput withTag(String tag) {
            return new ItemInput(null, tag);
        }
    }
}

