/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;

abstract class PipePartBuilder {
    static final float SIDE = 0.125f;
    protected static final float SPACING = 0.0625f;
    protected static final float FIRST_POS = 0.0625f;
    class_243 pos;
    class_243 facing;
    class_243 right;

    PipePartBuilder(int slotPos, class_2350 direction) {
        this.facing = class_243.method_24954((class_2382)direction.method_10163());
        float position = 0.3125f + (float)slotPos * 0.1875f;
        this.pos = new class_243((double)position, (double)position, (double)position);
        for (class_2350 d : class_2350.values()) {
            this.right = class_243.method_24954((class_2382)d.method_10163());
            if (this.isTowardsInside(this.right) && this.isTowardsInside(this.up())) break;
        }
        this.moveForward(0.0625f);
    }

    protected boolean isTowardsInside(class_243 direction) {
        return (double)this.distanceToSide(direction) > 0.499999;
    }

    protected float distanceToSide(class_243 direction) {
        float p = (float)direction.method_1026(this.pos);
        if (p > 0.0f) {
            return 1.0f - p;
        }
        return -p;
    }

    protected final void drawPipe(float length, Intent intent) {
        this.drawPipe(length, intent, true);
    }

    abstract void drawPipe(float var1, Intent var2, boolean var3);

    void moveForward(float amount) {
        this.pos = this.pos.method_1019(this.facing.method_1021((double)amount));
    }

    class_243 up() {
        return this.right.method_1036(this.facing);
    }

    protected void rotateCw() {
        this.right = this.up().method_1021(-1.0);
    }

    protected void turnUp() {
        this.facing = this.up();
    }

    void straightLine(boolean reduced, boolean end) {
        if (reduced) {
            this.moveForward(0.1875f);
        }
        this.drawPipe(this.distanceToSide(this.facing), Intent.STRAIGHT, end);
    }

    void shortBend(boolean reduced, boolean end) {
        if (reduced) {
            this.moveForward(0.1875f);
        }
        float dist = 0.375f;
        float advDist = this.distanceToSide(this.facing) - dist;
        boolean bendConflicting = advDist + 0.125f < 0.0f;
        this.drawPipe(advDist + 0.125f, Intent.BEND);
        this.moveForward(advDist + 0.0625f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.1875f, bendConflicting ? Intent.BEND_CONFLICTING : Intent.BEND, !bendConflicting);
        this.moveForward(0.125f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.1875f, Intent.BEND);
        this.moveForward(0.125f);
        this.turnUp();
        this.moveForward(0.0625f);
        this.drawPipe(this.distanceToSide(this.facing), Intent.STRAIGHT, end);
    }

    void farShortBend(boolean reduced, boolean end) {
        if (reduced) {
            this.moveForward(0.1875f);
        }
        float dist = 0.1875f;
        float advDist = this.distanceToSide(this.facing) - dist;
        this.drawPipe(advDist + 0.125f, Intent.BEND);
        this.moveForward(advDist + 0.0625f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.1875f, Intent.BEND);
        this.moveForward(0.125f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.1875f, Intent.BEND);
        this.moveForward(0.125f);
        this.turnUp();
        this.moveForward(0.0625f);
        this.drawPipe(this.distanceToSide(this.facing), Intent.STRAIGHT, end);
    }

    void longBend(boolean reduced, boolean end) {
        if (reduced) {
            this.moveForward(0.1875f);
        }
        float dist = 0.1875f;
        float advDist = this.distanceToSide(this.facing) - dist;
        this.drawPipe(advDist + 0.125f, Intent.BEND);
        this.moveForward(advDist + 0.0625f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.375f, Intent.BEND);
        this.moveForward(0.3125f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.375f, Intent.BEND);
        this.moveForward(0.3125f);
        this.turnUp();
        this.moveForward(0.0625f);
        this.drawPipe(this.distanceToSide(this.facing), Intent.STRAIGHT, end);
    }

    public static int getSlotPos(int slot) {
        return slot == 0 ? 1 : (slot == 1 ? 0 : 2);
    }

    static int getRenderType(int logicalSlot, class_2350 direction, PipeEndpointType[][] connections) {
        if (connections[logicalSlot][direction.method_10146()] == null) {
            return 0;
        }
        if (connections[logicalSlot][direction.method_10146()] != PipeEndpointType.PIPE) {
            return 1;
        }
        int connSlot = 0;
        for (int i = 0; i < logicalSlot; ++i) {
            if (connections[i][direction.method_10146()] == null) continue;
            ++connSlot;
        }
        if (logicalSlot == 1) {
            if (connSlot == 0) {
                return direction == class_2350.field_11034 ? 3 : 2;
            }
        } else if (logicalSlot == 2) {
            if (connSlot == 0) {
                return direction == class_2350.field_11039 ? 3 : 2;
            }
            if (connSlot == 1) {
                return 4;
            }
        }
        return 1;
    }

    static class_2350 getInitialDirection(int logicalSlot, class_2350 connectionDirection, int renderType) {
        if (renderType == 2) {
            if (logicalSlot == 1) {
                if (connectionDirection == class_2350.field_11043) {
                    return class_2350.field_11036;
                }
                if (connectionDirection == class_2350.field_11039) {
                    return class_2350.field_11035;
                }
                if (connectionDirection == class_2350.field_11033) {
                    return class_2350.field_11034;
                }
            } else if (logicalSlot == 2) {
                if (connectionDirection == class_2350.field_11036) {
                    return class_2350.field_11043;
                }
                if (connectionDirection == class_2350.field_11035) {
                    return class_2350.field_11039;
                }
                if (connectionDirection == class_2350.field_11034) {
                    return class_2350.field_11033;
                }
            }
        }
        return connectionDirection;
    }

    public static enum Intent {
        STRAIGHT,
        BEND,
        BEND_CONFLICTING;

    }
}

