/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.api.PipeRenderer;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1160;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class PipeModel
implements class_1100,
class_1087,
FabricBakedModel {
    private static final class_2960 DEFAULT_BLOCK_MODEL = new class_2960("minecraft:block/block");
    private static final class_4730 PARTICLE_SPRITE = new class_4730(class_1059.field_5275, new class_2960("minecraft:block/iron_block"));
    private class_1058 particleSprite;
    private Map<PipeRenderer.Factory, PipeRenderer> renderers = new Reference2ObjectOpenHashMap();
    private class_809 modelTransformation;
    private RenderMaterial cutoutMaterial;
    private static final RenderContext.QuadTransform ITEM_TRANSFORM = quad -> {
        for (int i = 0; i < 4; ++i) {
            class_1160 pos = quad.copyPos(i, null);
            quad.pos(i, pos.method_4943(), pos.method_4945() * 2.0f - 0.5f, pos.method_4947() * 2.0f - 0.5f);
        }
        return true;
    };

    public PipeModel(class_1058 particleSprite, Map<PipeRenderer.Factory, PipeRenderer> renderers, class_809 modelTransformation, RenderMaterial cutoutMaterial) {
        this.particleSprite = particleSprite;
        this.renderers = renderers;
        this.modelTransformation = modelTransformation;
        this.cutoutMaterial = cutoutMaterial;
    }

    public PipeModel() {
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockRenderView, class_2680 state, class_2338 pos, Supplier<Random> supplier, RenderContext renderContext) {
        renderContext.pushTransform(quad -> {
            if (quad.tag() == 0) {
                quad.material(this.cutoutMaterial);
            }
            return true;
        });
        PipeBlockEntity.RenderAttachment attachment = (PipeBlockEntity.RenderAttachment)((RenderAttachedBlockView)blockRenderView).getBlockEntityRenderAttachment(pos);
        if (attachment == null) {
            throw new NullPointerException(String.format("Null attachment for pipe rendering! This is not supposed to happen!\nPos: %s\nState: %s", pos, state));
        }
        int centerSlots = attachment.types.length;
        for (int slot = 0; slot < centerSlots; ++slot) {
            int color = attachment.types[slot].getColor();
            renderContext.pushTransform(PipeModel.getColorTransform(color));
            this.renderers.get(attachment.types[slot].getRenderer()).draw(blockRenderView, pos, renderContext, slot, attachment.renderedConnections, attachment.customData[slot]);
            renderContext.popTransform();
        }
        renderContext.popTransform();
    }

    public void emitItemQuads(class_1799 itemStack, Supplier<Random> supplier, RenderContext renderContext) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof PipeItem) {
            PipeNetworkType type = ((PipeItem)item).type;
            int color = type.getColor();
            renderContext.pushTransform(PipeModel.getColorTransform(color));
            renderContext.pushTransform(ITEM_TRANSFORM);
            PipeEndpointType[][] connections = new PipeEndpointType[][]{{null, null, null, null, PipeEndpointType.BLOCK, PipeEndpointType.BLOCK}};
            this.renderers.get(type.getRenderer()).draw(null, null, renderContext, 0, connections, new class_2487());
            renderContext.popTransform();
            renderContext.popTransform();
        }
    }

    private static RenderContext.QuadTransform getColorTransform(int color) {
        return quad -> {
            if (quad.tag() == 0) {
                quad.spriteColor(0, color, color, color, color);
            }
            return true;
        };
    }

    public List<class_777> method_4707(class_2680 state, class_2350 face, Random random) {
        return Collections.emptyList();
    }

    public boolean method_4708() {
        return false;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.particleSprite;
    }

    public class_809 method_4709() {
        return this.modelTransformation;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public Collection<class_2960> method_4755() {
        return Arrays.asList(DEFAULT_BLOCK_MODEL);
    }

    public Collection<class_4730> method_4754(Function<class_2960, class_1100> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        return PipeNetworkType.getTypes().values().stream().flatMap(r -> r.getRenderer().getSpriteDependencies().stream()).collect(Collectors.toList());
    }

    public class_1087 method_4753(class_1088 loader, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
        this.particleSprite = textureGetter.apply(PARTICLE_SPRITE);
        this.modelTransformation = ((class_793)loader.method_4726(DEFAULT_BLOCK_MODEL)).method_3443();
        this.renderers.clear();
        for (PipeRenderer.Factory rendererFactory : PipeNetworkType.getRenderers()) {
            this.renderers.put(rendererFactory, rendererFactory.create(textureGetter));
        }
        this.cutoutMaterial = RendererAccess.INSTANCE.getRenderer().materialFinder().blendMode(0, BlendMode.CUTOUT).find();
        return this;
    }

    public RenderMaterial getCutoutMaterial() {
        return this.cutoutMaterial;
    }

    public Map<PipeRenderer.Factory, PipeRenderer> getRenderers() {
        return this.renderers;
    }
}

