/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.api.FastBlockEntity;
import aztech.modern_industrialization.api.WrenchableBlockEntity;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.gui.IPipeScreenHandlerHelper;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.pipes.impl.PipePartBuilder;
import aztech.modern_industrialization.pipes.impl.PipeShapeBuilder;
import aztech.modern_industrialization.pipes.impl.PipeVoxelShape;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.RenderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class PipeBlockEntity
extends FastBlockEntity
implements IPipeScreenHandlerHelper,
RenderAttachmentBlockEntity,
WrenchableBlockEntity {
    private static final int MAX_PIPES = 3;
    private static final class_265[][][] SHAPE_CACHE = new class_265[3][6][5];
    static final class_265 DEFAULT_SHAPE;
    class_265 currentCollisionShape = class_259.method_1073();
    private final SortedSet<PipeNetworkNode> pipes = new TreeSet<PipeNetworkNode>(Comparator.comparing(PipeNetworkNode::getType));
    SortedMap<PipeNetworkType, PipeEndpointType[]> connections = new TreeMap<PipeNetworkType, PipeEndpointType[]>();
    SortedMap<PipeNetworkType, class_2487> customData = new TreeMap<PipeNetworkType, class_2487>();
    private final List<class_3545<PipeNetworkType, PipeNetworkNode>> unloadedPipes = new ArrayList<class_3545<PipeNetworkType, PipeNetworkNode>>();
    boolean stateReplaced = false;

    public void loadPipes() {
        if (this.field_11863.field_9236) {
            return;
        }
        boolean changed = false;
        for (class_3545<PipeNetworkType, PipeNetworkNode> unloaded : this.unloadedPipes) {
            PipeNetworks.get((class_3218)this.field_11863).getManager((PipeNetworkType)unloaded.method_15442()).nodeLoaded((PipeNetworkNode)unloaded.method_15441(), this.field_11867);
            this.pipes.add((PipeNetworkNode)unloaded.method_15441());
            ((PipeNetworkNode)unloaded.method_15441()).updateConnections(this.field_11863, this.field_11867);
            changed = true;
        }
        this.unloadedPipes.clear();
        if (changed) {
            this.onConnectionsChanged();
        }
    }

    public PipeBlockEntity(class_2338 pos, class_2680 state) {
        super(MIPipes.BLOCK_ENTITY_TYPE_PIPE, pos, state);
    }

    void updateConnections() {
        this.loadPipes();
        for (PipeNetworkNode pipe : this.pipes) {
            pipe.updateConnections(this.field_11863, this.field_11867);
        }
        this.onConnectionsChanged();
    }

    public SortedSet<PipeNetworkNode> getNodes() {
        this.loadPipes();
        return Collections.unmodifiableSortedSet(this.pipes);
    }

    boolean canAddPipe(PipeNetworkType type) {
        this.loadPipes();
        if (this.field_11863.field_9236) {
            return this.connections.size() < 3 && !this.connections.containsKey(type);
        }
        if (this.pipes.size() == 3) {
            return false;
        }
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            return false;
        }
        return true;
    }

    void addPipe(PipeNetworkType type, PipeNetworkData data) {
        if (!this.canAddPipe(type)) {
            return;
        }
        PipeNetworkNode node = type.getNodeCtor().get();
        PipeNetworkManager manager = PipeNetworks.get((class_3218)this.field_11863).getManager(type);
        manager.addNode(node, this.field_11867, data);
        for (class_2350 direction : class_2350.values()) {
            manager.addLink(this.field_11867, direction, false);
        }
        this.pipes.add(node);
        node.buildInitialConnections(this.field_11863, this.field_11867);
        this.updateConnections();
    }

    public void removePipeAndDropContainedItems(PipeNetworkType type) {
        this.loadPipes();
        PipeNetworkNode removedPipe = null;
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            removedPipe = pipe;
            break;
        }
        if (removedPipe == null) {
            throw new IllegalArgumentException("Can't remove type " + type.getIdentifier() + " from BlockEntity at pos " + this.field_11867);
        }
        this.pipes.remove(removedPipe);
        removedPipe.getManager().removeNode(this.field_11867);
        this.onConnectionsChanged();
        ArrayList<class_1799> droppedStacks = new ArrayList<class_1799>();
        removedPipe.appendDroppedStacks(droppedStacks);
        for (class_1799 droppedStack : droppedStacks) {
            this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), droppedStack));
        }
    }

    public void removeConnection(PipeNetworkType type, class_2350 direction) {
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            pipe.removeConnection(this.field_11863, this.field_11867, direction);
            pipe.getManager().removeLink(this.field_11867, direction);
            this.onConnectionsChanged();
            return;
        }
    }

    public void addConnection(PipeNetworkType type, class_2350 direction) {
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            pipe.addConnection(this.field_11863, this.field_11867, direction);
            pipe.getManager().addLink(this.field_11867, direction, true);
            this.onConnectionsChanged();
            return;
        }
    }

    public ExtendedScreenHandlerFactory getGui(PipeNetworkType type, class_2350 direction) {
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            return pipe.getConnectionGui(direction, this);
        }
        return null;
    }

    public void method_11012() {
        if (this.stateReplaced) {
            this.loadPipes();
            for (PipeNetworkNode pipe : this.pipes) {
                pipe.getManager().removeNode(this.field_11867);
            }
        } else {
            for (PipeNetworkNode pipe : this.pipes) {
                pipe.getManager().nodeUnloaded(pipe, this.field_11867);
            }
        }
        super.method_11012();
    }

    public void method_11007(class_2487 tag) {
        int i = 0;
        for (PipeNetworkNode pipeNetworkNode : this.pipes) {
            tag.method_10582("pipe_type_" + i, pipeNetworkNode.getType().getIdentifier().toString());
            tag.method_10566("pipe_data_" + i, (class_2520)pipeNetworkNode.toTag(new class_2487()));
            ++i;
        }
        for (class_3545 class_35452 : this.unloadedPipes) {
            tag.method_10582("pipe_type_" + i, ((PipeNetworkType)class_35452.method_15442()).getIdentifier().toString());
            tag.method_10566("pipe_data_" + i, (class_2520)((PipeNetworkNode)class_35452.method_15441()).toTag(new class_2487()));
            ++i;
        }
    }

    public void method_11014(class_2487 tag) {
        if (!tag.method_10545("pipes")) {
            this.pipes.clear();
            int i = 0;
            while (tag.method_10545("pipe_type_" + i)) {
                class_2960 typeId = new class_2960(tag.method_10558("pipe_type_" + i));
                PipeNetworkType type = PipeNetworkType.get(typeId);
                PipeNetworkNode node = type.getNodeCtor().get();
                node.fromTag(tag.method_10562("pipe_data_" + i));
                this.unloadedPipes.add((class_3545<PipeNetworkType, PipeNetworkNode>)new class_3545((Object)type, (Object)node));
                ++i;
            }
        } else {
            this.connections.clear();
            this.customData.clear();
            class_2487 pipesTag = tag.method_10562("pipes");
            for (String key : pipesTag.method_10541()) {
                class_2487 nodeTag = pipesTag.method_10562(key);
                PipeNetworkType type = PipeNetworkType.get(new class_2960(key));
                this.connections.put(type, NbtHelper.decodeConnections(nodeTag.method_10547("connections")));
                this.customData.put(type, nodeTag.method_10562("custom").method_10553());
            }
            this.rebuildCollisionShape();
            RenderHelper.forceChunkRemesh(this.field_11863, this.field_11867);
        }
    }

    public void method_10996() {
        PipeNetworks.scheduleLoadPipe(this.field_11863, this);
    }

    public void onConnectionsChanged() {
        SortedMap<PipeNetworkType, PipeEndpointType[]> oldRendererConnections = this.connections;
        this.connections = new TreeMap<PipeNetworkType, PipeEndpointType[]>();
        for (PipeNetworkNode pipe : this.pipes) {
            this.connections.put(pipe.getType(), pipe.getConnections(this.field_11867));
        }
        if (!this.connections.equals(oldRendererConnections)) {
            this.rebuildCollisionShape();
            this.sync();
        }
        this.method_5431();
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.loadPipes();
        class_2487 pipesTag = new class_2487();
        for (PipeNetworkNode pipe : this.pipes) {
            class_2487 nodeTag = new class_2487();
            nodeTag.method_10566("custom", (class_2520)pipe.writeCustomData());
            nodeTag.method_10570("connections", NbtHelper.encodeConnections(pipe.getConnections(this.field_11867)));
            pipesTag.method_10566(pipe.getType().getIdentifier().toString(), (class_2520)nodeTag);
        }
        tag.method_10566("pipes", (class_2520)pipesTag);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public Object getRenderAttachmentData() {
        PipeNetworkType[] types = new PipeNetworkType[this.connections.size()];
        PipeEndpointType[][] renderedConnections = new PipeEndpointType[this.connections.size()][];
        class_2487[] customData = new class_2487[this.connections.size()];
        int i = 0;
        for (Map.Entry<PipeNetworkType, PipeEndpointType[]> entry : this.connections.entrySet()) {
            types[i] = entry.getKey();
            renderedConnections[i] = Arrays.copyOf(entry.getValue(), 6);
            customData[i] = (class_2487)this.customData.get(entry.getKey());
            ++i;
        }
        return new RenderAttachment(types, renderedConnections, customData);
    }

    @Override
    public void callSync() {
        this.sync();
    }

    @Override
    public void callMarkDirty() {
        this.method_5431();
    }

    @Override
    public boolean isWithinUseDistance(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @Override
    public boolean doesNodeStillExist(PipeNetworkNode node) {
        return this.pipes.contains(node);
    }

    @Override
    public boolean useWrench(class_1657 player, class_1268 hand, class_3965 hitResult) {
        return PipeBlock.useWrench(this, player, hand, hitResult);
    }

    public Collection<PipeVoxelShape> getPartShapes() {
        ArrayList<PipeVoxelShape> shapes = new ArrayList<PipeVoxelShape>();
        PipeEndpointType[][] renderedConnections = new PipeEndpointType[this.connections.size()][];
        PipeNetworkType[] types = new PipeNetworkType[this.connections.size()];
        int slot = 0;
        for (Map.Entry<PipeNetworkType, PipeEndpointType[]> connections : this.connections.entrySet()) {
            renderedConnections[slot] = connections.getValue();
            types[slot] = connections.getKey();
            ++slot;
        }
        for (slot = 0; slot < renderedConnections.length; ++slot) {
            shapes.add(new PipeVoxelShape(SHAPE_CACHE[slot][class_2350.field_11043.method_10146()][0], types[slot], null, false));
            for (class_2350 direction : class_2350.values()) {
                int connectionType = PipePartBuilder.getRenderType(slot, direction, renderedConnections);
                if (connectionType == 0) continue;
                PipeEndpointType connType = renderedConnections[slot][direction.method_10146()];
                boolean opensGui = connType != null && connType != PipeEndpointType.PIPE && types[slot].opensGui();
                shapes.add(new PipeVoxelShape(SHAPE_CACHE[slot][direction.method_10146()][connectionType], types[slot], direction, opensGui));
            }
        }
        return shapes;
    }

    private void rebuildCollisionShape() {
        this.currentCollisionShape = this.getPartShapes().stream().map(vs -> vs.shape).reduce(class_259.method_1073(), class_259::method_1084);
    }

    static {
        for (int slot = 0; slot < 3; ++slot) {
            for (class_2350 direction : class_2350.values()) {
                int connectionTypes = slot == 0 ? 2 : (slot == 1 ? 4 : 5);
                for (int connectionType = 0; connectionType < connectionTypes; ++connectionType) {
                    PipeShapeBuilder psb = new PipeShapeBuilder(PipePartBuilder.getSlotPos(slot), direction);
                    if (connectionType == 0) {
                        psb.centerConnector();
                    } else if (connectionType == 1) {
                        psb.straightLine(false, false);
                    } else if (connectionType == 2) {
                        psb.shortBend(false, false);
                    } else if (connectionType == 3) {
                        psb.farShortBend(false, false);
                    } else {
                        psb.longBend(false, false);
                    }
                    PipeBlockEntity.SHAPE_CACHE[slot][direction.method_10146()][connectionType] = psb.getShape();
                }
            }
        }
        DEFAULT_SHAPE = SHAPE_CACHE[0][0][0];
    }

    static class RenderAttachment {
        PipeNetworkType[] types;
        PipeEndpointType[][] renderedConnections;
        class_2487[] customData;

        private RenderAttachment(PipeNetworkType[] types, PipeEndpointType[][] renderedConnections, class_2487[] customData) {
            this.types = types;
            this.renderedConnections = renderedConnections;
            this.customData = customData;
        }
    }
}

