/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.fluid;

import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.fluid.FluidNetwork;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkData;
import aztech.modern_industrialization.pipes.fluid.FluidPipeInterface;
import aztech.modern_industrialization.pipes.fluid.FluidPipeScreenHandler;
import aztech.modern_industrialization.pipes.fluid.FluidTarget;
import aztech.modern_industrialization.pipes.gui.IPipeScreenHandlerHelper;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.util.IoStorage;
import aztech.modern_industrialization.util.NbtHelper;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FluidNetworkNode
extends PipeNetworkNode {
    long amount = 0L;
    private final List<FluidConnection> connections = new ArrayList<FluidConnection>();
    private FluidVariant cachedFluid = FluidVariant.blank();

    void gatherTargetsAndPickFluid(class_3218 world, class_2338 pos, List<FluidTarget> targets) {
        FluidNetworkData data = (FluidNetworkData)this.network.data;
        FluidNetwork network = (FluidNetwork)this.network;
        if (this.amount > (long)network.nodeCapacity) {
            ModernIndustrialization.LOGGER.warn("Fluid amount > nodeCapacity, deleting some fluid!");
            this.amount = network.nodeCapacity;
        }
        if (this.amount > 0L && data.fluid.isBlank()) {
            ModernIndustrialization.LOGGER.warn("Amount > 0 but fluid is blank, deleting some fluid!");
            this.amount = 0L;
        }
        for (FluidConnection connection : this.connections) {
            Storage<FluidVariant> storage = this.getNeighborStorage(world, pos, connection);
            if (data.fluid.isBlank() && connection.canExtract()) {
                data.fluid = (FluidVariant)MoreObjects.firstNonNull((Object)((FluidVariant)StorageUtil.findExtractableResource(storage, null)), (Object)FluidVariant.blank());
            }
            targets.add(new FluidTarget(connection.priority, new IoStorage<FluidVariant>(storage, connection.canInsert(), connection.canExtract())));
        }
    }

    private Storage<FluidVariant> getNeighborStorage(class_3218 world, class_2338 pos, FluidConnection connection) {
        Storage storage;
        if (connection.cache == null) {
            connection.cache = BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)world, (class_2338)pos.method_10093(connection.direction));
        }
        if ((storage = (Storage)connection.cache.find((Object)connection.direction.method_10153())) != null && (connection.canExtract() && storage.supportsExtraction() || connection.canInsert() && storage.supportsInsertion())) {
            return storage;
        }
        return Storage.empty();
    }

    @Override
    public void updateConnections(class_1937 world, class_2338 pos) {
        PipeNetworks levelNetworks = PipeNetworks.get((class_3218)world);
        this.connections.removeIf(connection -> {
            for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
                PipeNetworkManager manager = levelNetworks.getOptionalManager(type);
                if (manager == null || !manager.hasLink(pos, connection.direction)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public PipeEndpointType[] getConnections(class_2338 pos) {
        PipeEndpointType[] connections = new PipeEndpointType[6];
        for (class_2350 direction : this.network.manager.getNodeLinks(pos)) {
            connections[direction.method_10146()] = PipeEndpointType.PIPE;
        }
        for (FluidConnection connection : this.connections) {
            connections[connection.direction.method_10146()] = connection.type;
        }
        return connections;
    }

    private boolean canConnect(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2338 adjPos = pos.method_10093(direction);
        return FluidStorage.SIDED.find(world, pos.method_10093(direction), (Object)direction.method_10153()) != null;
    }

    @Override
    public void removeConnection(class_1937 world, class_2338 pos, class_2350 direction) {
        for (int i = 0; i < this.connections.size(); ++i) {
            FluidConnection conn = this.connections.get(i);
            if (conn.direction != direction) continue;
            if (conn.type == PipeEndpointType.BLOCK_IN) {
                conn.type = PipeEndpointType.BLOCK_IN_OUT;
            } else if (conn.type == PipeEndpointType.BLOCK_IN_OUT) {
                conn.type = PipeEndpointType.BLOCK_OUT;
            } else {
                this.connections.remove(i);
            }
            return;
        }
    }

    @Override
    public void addConnection(class_1937 world, class_2338 pos, class_2350 direction) {
        for (FluidConnection connection : this.connections) {
            if (connection.direction != direction) continue;
            return;
        }
        if (this.canConnect(world, pos, direction)) {
            this.connections.add(new FluidConnection(direction, PipeEndpointType.BLOCK_IN, 0));
        }
    }

    @Override
    public class_2487 toTag(class_2487 tag) {
        tag.method_10544("amount_ftl", this.amount);
        for (FluidConnection connection : this.connections) {
            class_2487 connectionTag = new class_2487();
            connectionTag.method_10567("connections", (byte)this.encodeConnectionType(connection.type));
            connectionTag.method_10569("priority", connection.priority);
            tag.method_10566(connection.direction.toString(), (class_2520)connectionTag);
        }
        return tag;
    }

    @Override
    public void fromTag(class_2487 tag) {
        this.amount = tag.method_10537("amount_ftl");
        for (class_2350 direction : class_2350.values()) {
            if (!tag.method_10545(direction.toString())) continue;
            if (tag.method_10540(direction.toString()) == 1) {
                this.connections.add(new FluidConnection(direction, this.decodeConnectionType(tag.method_10571(direction.toString())), 0));
                continue;
            }
            class_2487 connectionTag = tag.method_10562(direction.toString());
            this.connections.add(new FluidConnection(direction, this.decodeConnectionType(connectionTag.method_10571("connections")), connectionTag.method_10550("priority")));
        }
    }

    private PipeEndpointType decodeConnectionType(int i) {
        return i == 0 ? PipeEndpointType.BLOCK_IN : (i == 1 ? PipeEndpointType.BLOCK_IN_OUT : PipeEndpointType.BLOCK_OUT);
    }

    private int encodeConnectionType(PipeEndpointType connection) {
        return connection == PipeEndpointType.BLOCK_IN ? 0 : (connection == PipeEndpointType.BLOCK_IN_OUT ? 1 : 2);
    }

    @Override
    public ExtendedScreenHandlerFactory getConnectionGui(class_2350 guiDirection, IPipeScreenHandlerHelper helper) {
        for (FluidConnection connection : this.connections) {
            if (connection.direction != guiDirection) continue;
            FluidConnection fluidConnection = connection;
            Objects.requireNonNull(fluidConnection);
            return fluidConnection.new FluidConnection.ScreenHandlerFactory(helper, this.getType().getIdentifier());
        }
        return null;
    }

    @Override
    public class_2487 writeCustomData() {
        class_2487 tag = new class_2487();
        NbtHelper.putFluid(tag, "fluid", ((FluidNetworkData)this.network.data).fluid);
        return tag;
    }

    public void afterTick(class_3218 world, class_2338 pos) {
        FluidVariant networkFluid = ((FluidNetworkData)this.network.data).fluid;
        if (!networkFluid.equals(this.cachedFluid)) {
            this.cachedFluid = networkFluid;
            world.method_14178().method_14128(pos);
        }
    }

    public long getAmount() {
        return this.amount;
    }

    public int getCapacity() {
        return ((FluidNetwork)this.network).nodeCapacity;
    }

    public FluidVariant getFluid() {
        return ((FluidNetworkData)this.network.data).fluid;
    }

    private class FluidConnection {
        private final class_2350 direction;
        private PipeEndpointType type;
        private int priority;
        private BlockApiCache<Storage<FluidVariant>, class_2350> cache;

        private FluidConnection(class_2350 direction, PipeEndpointType type, int priority) {
            this.direction = direction;
            this.type = type;
            this.priority = priority;
        }

        private boolean canInsert() {
            return this.type == PipeEndpointType.BLOCK_IN || this.type == PipeEndpointType.BLOCK_IN_OUT;
        }

        private boolean canExtract() {
            return this.type == PipeEndpointType.BLOCK_OUT || this.type == PipeEndpointType.BLOCK_IN_OUT;
        }

        private class ScreenHandlerFactory
        implements ExtendedScreenHandlerFactory {
            private final FluidPipeInterface iface;
            private final class_2960 pipeType;

            private ScreenHandlerFactory(final IPipeScreenHandlerHelper helper, class_2960 pipeType) {
                this.iface = new FluidPipeInterface(){

                    @Override
                    public FluidVariant getNetworkFluid() {
                        if (FluidNetworkNode.this.network != null) {
                            return FluidNetworkNode.this.getFluid();
                        }
                        return FluidVariant.blank();
                    }

                    @Override
                    public void setNetworkFluid(FluidVariant fluid) {
                        FluidNetwork network = (FluidNetwork)FluidNetworkNode.this.network;
                        if (network != null && !this.getNetworkFluid().equals(fluid)) {
                            network.clearFluid();
                            if (!fluid.isBlank()) {
                                network.setFluid(fluid);
                            }
                            helper.callMarkDirty();
                        }
                    }

                    @Override
                    public int getConnectionType() {
                        return FluidNetworkNode.this.encodeConnectionType(FluidConnection.this.type);
                    }

                    @Override
                    public void setConnectionType(int type) {
                        if (0 <= type && type < 3) {
                            FluidConnection.this.type = FluidNetworkNode.this.decodeConnectionType(type);
                            helper.callMarkDirty();
                            helper.callSync();
                        }
                    }

                    @Override
                    public int getPriority(int channel) {
                        return FluidConnection.this.priority;
                    }

                    @Override
                    public void setPriority(int channel, int priority) {
                        FluidConnection.this.priority = priority;
                        helper.callMarkDirty();
                    }

                    @Override
                    public boolean canUse(class_1657 player) {
                        if (!helper.isWithinUseDistance(player)) {
                            return false;
                        }
                        return helper.doesNodeStillExist(FluidNetworkNode.this) && FluidNetworkNode.this.connections.contains(FluidConnection.this);
                    }
                };
                this.pipeType = pipeType;
            }

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                this.iface.toBuf(buf);
            }

            public class_2561 method_5476() {
                return new class_2588("item." + this.pipeType.method_12836() + "." + this.pipeType.method_12832());
            }

            @Nullable
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new FluidPipeScreenHandler(syncId, inv, this.iface);
            }
        }
    }
}

