/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.debug.DebugCommands;
import aztech.modern_industrialization.pipes.PipeColor;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.api.PipeRenderer;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetwork;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkData;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidNetwork;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkData;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidPipeScreenHandler;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.pipes.impl.PipeMeshCache;
import aztech.modern_industrialization.pipes.impl.PipePackets;
import aztech.modern_industrialization.pipes.item.ItemNetwork;
import aztech.modern_industrialization.pipes.item.ItemNetworkData;
import aztech.modern_industrialization.pipes.item.ItemNetworkNode;
import aztech.modern_industrialization.pipes.item.ItemPipeScreenHandler;
import aztech.modern_industrialization.util.ResourceUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3917;
import net.minecraft.class_4730;

public class MIPipes {
    public static final MIPipes INSTANCE = new MIPipes();
    public static final class_2248 BLOCK_PIPE = new PipeBlock(FabricBlockSettings.of((class_3614)class_3614.field_15953).method_36557(4.0f));
    public static final class_2960 ITEM_PIPES_ID = new MIIdentifier("item_pipes");
    public static final class_2960 FLUID_PIPES_ID = new MIIdentifier("fluid_pipes");
    public static final class_3494<class_1792> ITEM_PIPES = TagRegistry.item((class_2960)ITEM_PIPES_ID);
    public static final class_3494<class_1792> FLUID_PIPES = TagRegistry.item((class_2960)FLUID_PIPES_ID);
    public static class_2591<PipeBlockEntity> BLOCK_ENTITY_TYPE_PIPE;
    private final Map<PipeNetworkType, PipeItem> pipeItems = new HashMap<PipeNetworkType, PipeItem>();
    public static final Map<PipeItem, CableTier> electricityPipeTier;
    public static final class_3917<ItemPipeScreenHandler> SCREEN_HANDLER_TYPE_ITEM_PIPE;
    public static final class_3917<FluidPipeScreenHandler> SCREEN_HANDLER_TYPE_FLUID_PIPE;
    public static final Set<class_2960> PIPE_MODEL_NAMES;
    private static final PipeRenderer.Factory ITEM_RENDERER;
    private static final PipeRenderer.Factory FLUID_RENDERER;
    private static final PipeRenderer.Factory ELECTRICITY_RENDERER;

    private static PipeRenderer.Factory makeRenderer(final List<String> sprites, final boolean innerQuads) {
        return new PipeRenderer.Factory(){

            @Override
            public Collection<class_4730> getSpriteDependencies() {
                return sprites.stream().map(n -> new class_4730(class_1059.field_5275, (class_2960)new MIIdentifier("blocks/pipes/" + n))).collect(Collectors.toList());
            }

            @Override
            public PipeRenderer create(Function<class_4730, class_1058> textureGetter) {
                class_4730[] ids = (class_4730[])sprites.stream().map(n -> new class_4730(class_1059.field_5275, (class_2960)new MIIdentifier("blocks/pipes/" + n))).toArray(class_4730[]::new);
                return new PipeMeshCache(textureGetter, ids, innerQuads);
            }
        };
    }

    public void setup() {
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new MIIdentifier("pipe"), (Object)BLOCK_PIPE);
        BLOCK_ENTITY_TYPE_PIPE = (class_2591)class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)new MIIdentifier("pipe"), (Object)FabricBlockEntityTypeBuilder.create(PipeBlockEntity::new, (class_2248[])new class_2248[]{BLOCK_PIPE}).build(null));
        for (PipeColor color : PipeColor.values()) {
            this.registerFluidPipeType(color);
            this.registerItemPipeType(color);
        }
        this.registerPackets();
        DebugCommands.init();
    }

    private void registerFluidPipeType(PipeColor color) {
        String pipeId = color.prefix + "fluid_pipe";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(pipeId), (id, data) -> new FluidNetwork((int)id, (PipeNetworkData)data, 81000), FluidNetworkNode::new, color.color, true, FLUID_RENDERER);
        PipeItem item = new PipeItem(new class_1792.class_1793().method_7892(ModernIndustrialization.ITEM_GROUP), type, new FluidNetworkData(FluidVariant.blank()));
        this.pipeItems.put(type, item);
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new MIIdentifier(pipeId), (Object)((Object)item));
        PIPE_MODEL_NAMES.add(new MIIdentifier("item/" + pipeId));
        ResourceUtil.appendToItemTag(FLUID_PIPES_ID, new MIIdentifier(pipeId));
    }

    private void registerItemPipeType(PipeColor color) {
        String pipeId = color.prefix + "item_pipe";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(pipeId), ItemNetwork::new, ItemNetworkNode::new, color.color, true, ITEM_RENDERER);
        PipeItem item = new PipeItem(new class_1792.class_1793().method_7892(ModernIndustrialization.ITEM_GROUP), type, new ItemNetworkData());
        this.pipeItems.put(type, item);
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new MIIdentifier(pipeId), (Object)((Object)item));
        PIPE_MODEL_NAMES.add(new MIIdentifier("item/" + pipeId));
        ResourceUtil.appendToItemTag(ITEM_PIPES_ID, new MIIdentifier(pipeId));
    }

    public void registerCableType(String name, int color, CableTier tier) {
        String cableId = name + "_cable";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(cableId), (id, data) -> new ElectricityNetwork((int)id, (PipeNetworkData)data, tier), ElectricityNetworkNode::new, color, false, ELECTRICITY_RENDERER);
        PipeItem item = new PipeItem(new class_1792.class_1793().method_7892(ModernIndustrialization.ITEM_GROUP), type, new ElectricityNetworkData());
        this.pipeItems.put(type, item);
        electricityPipeTier.put(item, tier);
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new MIIdentifier(cableId), (Object)((Object)item));
        PIPE_MODEL_NAMES.add(new MIIdentifier("item/" + cableId));
    }

    public PipeItem getPipeItem(PipeNetworkType type) {
        return this.pipeItems.get(type);
    }

    public void registerPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PipePackets.SET_ITEM_WHITELIST, PipePackets.ON_SET_ITEM_WHITELIST::handleC2S);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PipePackets.SET_CONNECTION_TYPE, PipePackets.ON_SET_CONNECTION_TYPE::handleC2S);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PipePackets.INCREMENT_PRIORITY, (ServerPlayNetworking.PlayChannelHandler)PipePackets.ON_INCREMENT_PRIORITY);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PipePackets.SET_NETWORK_FLUID, PipePackets.ON_SET_NETWORK_FLUID::handleC2S);
    }

    static {
        electricityPipeTier = new HashMap<PipeItem, CableTier>();
        SCREEN_HANDLER_TYPE_ITEM_PIPE = ScreenHandlerRegistry.registerExtended((class_2960)new MIIdentifier("item_pipe"), ItemPipeScreenHandler::new);
        SCREEN_HANDLER_TYPE_FLUID_PIPE = ScreenHandlerRegistry.registerExtended((class_2960)new MIIdentifier("fluid_pipe"), FluidPipeScreenHandler::new);
        PIPE_MODEL_NAMES = new HashSet<class_2960>();
        ITEM_RENDERER = MIPipes.makeRenderer(Arrays.asList("item", "item_item", "item_in", "item_in_out", "item_out"), false);
        FLUID_RENDERER = MIPipes.makeRenderer(Arrays.asList("fluid", "fluid_item", "fluid_in", "fluid_in_out", "fluid_out"), true);
        ELECTRICITY_RENDERER = MIPipes.makeRenderer(Arrays.asList("electricity", "electricity_blocks"), false);
    }
}

