/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.blocks.OreBlock;
import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.part.RegularPart;
import aztech.modern_industrialization.materials.part.UnbuildablePart;
import aztech.modern_industrialization.materials.set.MaterialOreSet;
import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.util.ResourceUtil;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.loot.JEntry;
import net.devtech.arrp.json.loot.JFunction;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.loot.JPool;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.minecraft.class_1011;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3614;
import net.minecraft.class_3825;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5843;
import net.minecraft.class_6019;
import net.minecraft.class_6795;
import net.minecraft.class_6797;
import net.minecraft.class_6806;
import net.minecraft.class_6816;

public class OrePart
extends UnbuildablePart<OrePartParams> {
    public final boolean deepslate;
    public static final Set<String> GENERATED_MATERIALS = new HashSet<String>();

    public BuildablePart of(int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.of(new OrePartParams(class_6019.method_35017((int)0, (int)2), set, veinsPerChunk, veinSize, maxYLevel));
    }

    public BuildablePart of(class_6019 xpProvider, int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.of(new OrePartParams(xpProvider, set, veinsPerChunk, veinSize, maxYLevel));
    }

    public BuildablePart of(class_6019 xpProvider, MaterialOreSet set) {
        return this.of(new OrePartParams(xpProvider, set));
    }

    @Override
    public BuildablePart of(MaterialOreSet set) {
        return this.of(new OrePartParams(class_6019.method_35017((int)0, (int)0), set));
    }

    public OrePart(boolean deepslate) {
        super(deepslate ? "ore_deepslate" : "ore");
        this.deepslate = deepslate;
    }

    @Override
    public BuildablePart of(OrePartParams oreParams) {
        return new RegularPart(this.key).withRegister((registeringContext, partContext, part, itemPath, itemId, itemTag) -> {
            String loot;
            OreBlock block = new OreBlock(itemPath, FabricBlockSettings.of((class_3614)ModernIndustrialization.STONE_MATERIAL).breakByTool(FabricToolTags.PICKAXES, 1).method_36557(this.deepslate ? 4.5f : 3.0f).method_36558(3.0f).method_9626(this.deepslate ? class_2498.field_29033 : class_2498.field_11544).method_29292(), oreParams, partContext.getMaterialName());
            Part mainPart = partContext.getMainPart();
            if (mainPart.equals(MIParts.INGOT)) {
                loot = registeringContext.getMaterialPart(MIParts.RAW_METAL).getItemId();
            } else if (mainPart.equals(MIParts.DUST)) {
                loot = registeringContext.getMaterialPart(MIParts.DUST).getItemId();
            } else if (mainPart.equals(MIParts.GEM)) {
                loot = registeringContext.getMaterialPart(MIParts.GEM).getItemId();
            } else {
                throw new UnsupportedOperationException("Could not find matching main part.");
            }
            if (mainPart.equals(MIParts.INGOT) != (oreParams.xpDropped.method_35011() == 0)) {
                throw new IllegalArgumentException("Mismatch between raw ore and xp drops for material: " + partContext.getMaterialName());
            }
            block.setLootTables(JLootTable.loot((String)"minecraft:block").pool(new JPool().rolls(Integer.valueOf(1)).bonus(Integer.valueOf(0)).entry(new JEntry().type("minecraft:alternatives").child(new JEntry().type("minecraft:item").condition(new JCondition("minecraft:match_tool").parameter("predicate", (JsonElement)new Gson().fromJson("{\n\"enchantments\": [\n  {\n    \"enchantment\": \"minecraft:silk_touch\",\n    \"levels\": {\n      \"min\": 1\n    }\n  }\n]\n}\n", JsonElement.class))).name(itemId)).child(new JEntry().type("minecraft:item").function(new JFunction("minecraft:apply_bonus").parameter("enchantment", "minecraft:fortune").parameter("formula", "minecraft:ore_drops")).function(new JFunction("minecraft:explosion_decay")).name(loot)))));
            ResourceUtil.appendToTag("c:items/" + partContext.getMaterialName() + "_ores", itemId);
            MIConfig config = MIConfig.getConfig();
            if (oreParams.generate) {
                GENERATED_MATERIALS.add(partContext.getMaterialName());
                if (config.generateOres && !config.blacklistedOres.contains(partContext.getMaterialName())) {
                    MIIdentifier oreGenId = new MIIdentifier((this.deepslate ? "deepslate_" : "") + "ore_generator_" + partContext.getMaterialName());
                    ImmutableList target = ImmutableList.of((Object)class_3124.method_33994((class_3825)(this.deepslate ? class_6806.field_35859 : class_6806.field_35858), (class_2680)block.method_9564()));
                    class_2975 configuredOreGen = (class_2975)class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)oreGenId, (Object)class_3031.field_13517.method_23397((class_3037)new class_3124((List)target, oreParams.veinSize)));
                    class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)oreGenId, (Object)configuredOreGen.method_39593(class_6816.method_39732((int)oreParams.veinsPerChunk, (class_6797)class_6795.method_39634((class_5843)class_5843.method_33840(), (class_5843)class_5843.method_33841((int)oreParams.maxYLevel)))));
                    class_5321 featureKey = class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)oreGenId);
                    BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13176, (class_5321)featureKey);
                }
            }
        }).withTextureRegister((mtm, partContext, part, itemPath) -> {
            String template = String.format("modern_industrialization:textures/materialsets/ores/%s.png", oreParams.set.name);
            try {
                String from = switch (oreParams.set) {
                    case MaterialOreSet.IRON -> {
                        if (this.deepslate) {
                            yield "deepslate_iron_ore";
                        }
                        yield "iron_ore";
                    }
                    case MaterialOreSet.COPPER -> {
                        if (this.deepslate) {
                            yield "deepslate_copper_ore";
                        }
                        yield "copper_ore";
                    }
                    case MaterialOreSet.LAPIS -> {
                        if (this.deepslate) {
                            yield "deepslate_lapis_ore";
                        }
                        yield "lapis_ore";
                    }
                    case MaterialOreSet.REDSTONE -> {
                        if (this.deepslate) {
                            yield "deepslate";
                        }
                        yield "redstone_ore";
                    }
                    case MaterialOreSet.DIAMOND -> {
                        if (this.deepslate) {
                            yield "deepslate";
                        }
                        yield "diamond_ore";
                    }
                    case MaterialOreSet.GOLD -> {
                        if (this.deepslate) {
                            yield "deepslate_gold_ore";
                        }
                        yield "gold_ore";
                    }
                    case MaterialOreSet.EMERALD -> {
                        if (this.deepslate) {
                            yield "deepslate_emerald_ore";
                        }
                        yield "emerald_ore";
                    }
                    case MaterialOreSet.COAL -> {
                        if (this.deepslate) {
                            yield "deepslate_coal_ore";
                        }
                        yield "coal_ore";
                    }
                    default -> this.deepslate ? "deepslate" : "stone";
                };
                class_1011 image = mtm.getAssetAsTexture(String.format("minecraft:textures/block/%s.png", from));
                class_1011 top = mtm.getAssetAsTexture(template);
                TextureHelper.colorize(top, partContext.getColoramp());
                String texturePath = String.format("modern_industrialization:textures/blocks/%s.png", itemPath);
                mtm.addTexture(texturePath, TextureHelper.blend(image, top), true);
                top.close();
                image.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).withCustomFormattablePath((this.deepslate ? "deepslate_" : "") + "%s_ore", "%s_ores");
    }

    public List<BuildablePart> ofAll(OrePartParams params) {
        return List.of(MIParts.ORE_DEEPLSATE.of(params), MIParts.ORE.of(params));
    }

    public List<BuildablePart> ofAll(class_6019 xpProvider, int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.ofAll(new OrePartParams(xpProvider, set, veinsPerChunk, veinSize, maxYLevel));
    }

    public List<BuildablePart> ofAll(int veinsPerChunk, int veinSize, int maxYLevel, MaterialOreSet set) {
        return this.ofAll(new OrePartParams(class_6019.method_35017((int)0, (int)0), set, veinsPerChunk, veinSize, maxYLevel));
    }

    public static class OrePartParams {
        public final class_6019 xpDropped;
        public final MaterialOreSet set;
        public final boolean generate;
        public final int veinsPerChunk;
        public final int veinSize;
        public final int maxYLevel;

        private OrePartParams(class_6019 xpDropped, MaterialOreSet set, boolean generate, int veinsPerChunk, int veinSize, int maxYLevel) {
            this.xpDropped = xpDropped;
            this.set = set;
            this.generate = generate;
            this.veinsPerChunk = veinsPerChunk;
            this.veinSize = veinSize;
            this.maxYLevel = maxYLevel;
        }

        public OrePartParams(class_6019 xpDropped, MaterialOreSet set) {
            this(xpDropped, set, false, 0, 0, 0);
        }

        public OrePartParams(class_6019 xpDropped, MaterialOreSet set, int veinsPerChunk, int veinSize, int maxYLevel) {
            this(xpDropped, set, true, veinsPerChunk, veinSize, maxYLevel);
        }
    }
}

