/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials;

import aztech.modern_industrialization.materials.Material;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class MaterialRegistry {
    static final Map<String, Material> MATERIALS = new TreeMap<String, Material>();

    public static void addMaterial(Material material) {
        if (MATERIALS.put(material.name, material) != null) {
            throw new IllegalStateException("Duplicate registration of material " + material.name);
        }
    }

    public static Material getMaterial(String name) {
        Material material = MATERIALS.get(name);
        Objects.requireNonNull(material);
        return material;
    }

    public static Map<String, Material> getMaterials() {
        return Collections.unmodifiableMap(MATERIALS);
    }
}

