/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.models;

import aztech.modern_industrialization.datagen.model.MachineModelsProvider;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntityRenderer;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelProvider;
import net.fabricmc.fabric.api.client.model.ExtraModelProvider;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.minecraft.class_2591;

public final class MachineModels {
    public static void init() {
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(rm -> new MachineModelProvider());
        ModelLoadingRegistry.INSTANCE.registerModelProvider((ExtraModelProvider)new MachineModelProvider());
    }

    public static void addTieredMachine(String tier, String id, String machineType, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        MachineCasing defaultCasing;
        if (tier.equals("bronze")) {
            defaultCasing = MachineCasings.BRONZE;
        } else if (tier.equals("steel")) {
            defaultCasing = MachineCasings.STEEL;
        } else if (tier.equals("electric")) {
            defaultCasing = MachineCasings.LV;
        } else {
            throw new RuntimeException("Invalid tier: " + tier);
        }
        MachineModels.addTieredMachine(id, machineType, defaultCasing, frontOverlay, topOverlay, sideOverlay);
    }

    public static void addTieredMachine(String id, String overlayFolder, MachineCasing defaultCasing, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        MachineModels.addTieredMachine(id, overlayFolder, defaultCasing, frontOverlay, topOverlay, sideOverlay, true);
    }

    public static void addTieredMachine(String id, String overlayFolder, MachineCasing defaultCasing, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, boolean hasActive) {
        MachineBlock.REGISTERED_MACHINES.put(id, defaultCasing);
        MachineModelsProvider.register(id, overlayFolder, frontOverlay, topOverlay, sideOverlay, hasActive);
    }

    public static void addTieredMachineTiers(String name, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, String ... tiers) {
        for (String tier : tiers) {
            MachineModels.addTieredMachine(tier, tier + "_" + name, name, frontOverlay, topOverlay, sideOverlay);
        }
    }

    public static void addMachineBer(class_2591 bet, String id) {
        BlockEntityRendererRegistry.register((class_2591)bet, c -> new MachineBlockEntityRenderer(c));
    }

    private MachineModels() {
    }
}

