/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.init;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.machines.recipe.CuttingMachineRecipeType;
import aztech.modern_industrialization.machines.recipe.FurnaceRecipeProxy;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class MIMachineRecipeTypes {
    private static final List<MachineRecipeType> recipeTypes = new ArrayList<MachineRecipeType>();
    public static final MachineRecipeType ASSEMBLER = MIMachineRecipeTypes.create("assembler").withItemInputs().withFluidInputs().withItemOutputs();
    public static final MachineRecipeType CENTRIFUGE = MIMachineRecipeTypes.create("centrifuge").withItemInputs().withFluidInputs().withItemOutputs().withFluidOutputs();
    public static final MachineRecipeType CHEMICAL_REACTOR = MIMachineRecipeTypes.create("chemical_reactor").withItemInputs().withFluidInputs().withItemOutputs().withFluidOutputs();
    public static final MachineRecipeType COMPRESSOR = MIMachineRecipeTypes.create("compressor").withItemInputs().withItemOutputs();
    public static final MachineRecipeType CUTTING_MACHINE = MIMachineRecipeTypes.create("cutting_machine", CuttingMachineRecipeType::new).withItemInputs().withFluidInputs().withItemOutputs();
    public static final MachineRecipeType DISTILLERY = MIMachineRecipeTypes.create("distillery").withFluidInputs().withFluidOutputs();
    public static final MachineRecipeType ELECTROLYZER = MIMachineRecipeTypes.create("electrolyzer").withItemInputs().withFluidInputs().withItemOutputs().withFluidOutputs();
    public static final MachineRecipeType FURNACE = MIMachineRecipeTypes.create("furnace", FurnaceRecipeProxy::new);
    public static final MachineRecipeType FORGE_HAMMER = MIMachineRecipeTypes.create("forge_hammer").withItemInputs().withItemOutputs();
    public static final MachineRecipeType MACERATOR = MIMachineRecipeTypes.create("macerator").withItemInputs().withItemOutputs();
    public static final MachineRecipeType MIXER = MIMachineRecipeTypes.create("mixer").withItemInputs().withFluidInputs().withItemOutputs().withFluidOutputs();
    public static final MachineRecipeType PACKER = MIMachineRecipeTypes.create("packer").withItemInputs().withItemOutputs();
    public static final MachineRecipeType POLARIZER = MIMachineRecipeTypes.create("polarizer").withItemInputs().withItemOutputs();
    public static final MachineRecipeType UNPACKER = MIMachineRecipeTypes.create("unpacker").withItemInputs().withItemOutputs();
    public static final MachineRecipeType WIREMILL = MIMachineRecipeTypes.create("wiremill").withItemInputs().withItemOutputs();
    public static final MachineRecipeType BLAST_FURNACE = MIMachineRecipeTypes.create("blast_furnace").withItemInputs().withItemOutputs().withFluidInputs().withFluidOutputs();
    public static final MachineRecipeType COKE_OVEN = MIMachineRecipeTypes.create("coke_oven").withItemInputs().withItemOutputs().withFluidOutputs();
    public static final MachineRecipeType DISTILLATION_TOWER = MIMachineRecipeTypes.create("distillation_tower").withFluidInputs().withFluidOutputs();
    public static final MachineRecipeType FUSION_REACTOR = MIMachineRecipeTypes.create("fusion_reactor").withFluidInputs().withFluidOutputs();
    public static final MachineRecipeType HEAT_EXCHANGER = MIMachineRecipeTypes.create("heat_exchanger").withFluidInputs().withFluidOutputs().withItemOutputs().withItemInputs();
    public static final MachineRecipeType IMPLOSION_COMPRESSOR = MIMachineRecipeTypes.create("implosion_compressor").withItemInputs().withItemOutputs();
    public static final MachineRecipeType OIL_DRILLING_RIG = MIMachineRecipeTypes.create("oil_drilling_rig").withItemInputs().withFluidOutputs();
    public static final MachineRecipeType PRESSURIZER = MIMachineRecipeTypes.create("pressurizer").withItemInputs().withFluidInputs().withFluidOutputs();
    public static final MachineRecipeType QUARRY = MIMachineRecipeTypes.create("quarry").withItemInputs().withItemOutputs();
    public static final MachineRecipeType VACUUM_FREEZER = MIMachineRecipeTypes.create("vacuum_freezer").withItemInputs().withItemOutputs().withFluidInputs().withFluidOutputs();

    public static void init() {
    }

    public static List<MachineRecipeType> getRecipeTypes() {
        return Collections.unmodifiableList(recipeTypes);
    }

    private static MachineRecipeType create(String name) {
        return MIMachineRecipeTypes.create(name, MachineRecipeType::new);
    }

    private static MachineRecipeType create(String name, Function<class_2960, MachineRecipeType> ctor) {
        MachineRecipeType type = ctor.apply(new MIIdentifier(name));
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)type.getId(), (Object)type);
        class_2378.method_10230((class_2378)class_2378.field_17597, (class_2960)type.getId(), (Object)type);
        recipeTypes.add(type);
        return type;
    }
}

