/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.machines.components.IntegerHistoryComponent;
import aztech.modern_industrialization.nuclear.NeutronType;

public class NeutronHistoryComponent
extends IntegerHistoryComponent {
    public NeutronHistoryComponent() {
        super(new String[]{"fastNeutronReceived", "fastNeutronFlux", "thermalNeutronReceived", "thermalNeutronFlux", "neutronGeneration", "euGeneration"}, 100);
    }

    public double getAverageReceived(NeutronType type) {
        if (type == NeutronType.FAST) {
            return this.getAverage("fastNeutronReceived");
        }
        if (type == NeutronType.THERMAL) {
            return this.getAverage("thermalNeutronReceived");
        }
        if (type == NeutronType.BOTH) {
            return this.getAverageReceived(NeutronType.FAST) + this.getAverageReceived(NeutronType.THERMAL);
        }
        return 0.0;
    }

    public double getAverageFlux(NeutronType type) {
        if (type == NeutronType.FAST) {
            return this.getAverage("fastNeutronFlux");
        }
        if (type == NeutronType.THERMAL) {
            return this.getAverage("thermalNeutronFlux");
        }
        if (type == NeutronType.BOTH) {
            return this.getAverageFlux(NeutronType.FAST) + this.getAverageFlux(NeutronType.THERMAL);
        }
        return 0.0;
    }

    public double getAverageGeneration() {
        return this.getAverage("neutronGeneration");
    }

    public double getAverageEuGeneration() {
        return this.getAverage("euGeneration");
    }
}

