/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.FuelBurningComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.SteamHeaterComponent;
import aztech.modern_industrialization.machines.components.sync.ProgressBar;
import aztech.modern_industrialization.machines.components.sync.TemperatureBar;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Tickable;

public class SteamBoilerMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable {
    private ShapeMatcher shapeMatcher;
    private final ShapeTemplate shapeTemplate;
    private final IsActiveComponent isActiveComponent = new IsActiveComponent();
    private final MultiblockInventoryComponent inventory;
    private final SteamHeaterComponent steamHeater;
    private final FuelBurningComponent fuelBurning;

    public SteamBoilerMultiblockBlockEntity(BEP bep, ShapeTemplate shapeTemplate, String name, long maxEuProduction, boolean highPressure) {
        super(bep, new MachineGuiParameters.Builder(name, false).build(), new OrientationComponent.Params(false, false, false));
        this.shapeTemplate = shapeTemplate;
        this.inventory = new MultiblockInventoryComponent();
        ProgressBar.Parameters PROGRESS_BAR = new ProgressBar.Parameters(82, 30, "furnace", true);
        TemperatureBar.Parameters TEMPERATURE_BAR = new TemperatureBar.Parameters(42, 55, 2500);
        this.steamHeater = new SteamHeaterComponent(2500.0, maxEuProduction, maxEuProduction / 32L, !highPressure, highPressure);
        this.fuelBurning = new FuelBurningComponent(this.steamHeater, 2L);
        this.registerClientComponent(new ProgressBar.Server(PROGRESS_BAR, () -> Float.valueOf((float)this.fuelBurning.getBurningProgress())));
        this.registerClientComponent(new TemperatureBar.Server(TEMPERATURE_BAR, () -> (int)this.steamHeater.getTemperature()));
        this.registerComponents(this.isActiveComponent, this.steamHeater, this.fuelBurning);
    }

    protected final void link() {
        if (this.shapeMatcher == null) {
            this.shapeMatcher = new ShapeMatcher(this.field_11863, this.field_11867, this.orientation.facingDirection, this.shapeTemplate);
            this.shapeMatcher.registerListeners(this.field_11863);
        }
        if (this.shapeMatcher.needsRematch()) {
            this.shapeValid.shapeValid = false;
            this.shapeMatcher.rematch(this.field_11863);
            if (this.shapeMatcher.isMatchSuccessful()) {
                this.inventory.rebuild(this.shapeMatcher);
                this.shapeValid.shapeValid = true;
            }
            if (this.shapeValid.update()) {
                this.sync(false);
            }
        }
    }

    @Override
    protected final void unlink() {
        if (this.shapeMatcher != null) {
            this.shapeMatcher.unlinkHatches();
            this.shapeMatcher.unregisterListeners(this.field_11863);
            this.shapeMatcher = null;
        }
    }

    @Override
    public ShapeTemplate getActiveShape() {
        return this.shapeTemplate;
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    protected MachineModelClientData getModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection).active(this.isActiveComponent.isActive);
    }

    @Override
    public void tick() {
        if (!this.field_11863.field_9236) {
            this.link();
            if (this.shapeValid.shapeValid) {
                this.steamHeater.tick(this.inventory.getFluidInputs(), this.inventory.getFluidOutputs());
                this.fuelBurning.tick(this.inventory.getItemInputs(), this.inventory.getFluidInputs());
                this.isActiveComponent.updateActive(this.fuelBurning.isBurning(), this);
            } else {
                this.fuelBurning.disable();
                this.steamHeater.decreaseTemperature(1.0);
                this.isActiveComponent.updateActive(false, this);
            }
            this.method_5431();
        }
    }
}

