/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.client.screen.MIHandledScreen;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPackets;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.ConfigurableScreenHandler;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachinePackets;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.SyncedComponents;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.RenderHelper;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class MachineScreenHandlers {
    public static final class_2960 SLOT_ATLAS = new class_2960("modern_industrialization", "textures/gui/container/slot_atlas.png");

    public static Client createClient(int syncId, class_1661 playerInventory, class_2540 buf) {
        int itemStackCount = buf.readInt();
        int fluidStackCount = buf.readInt();
        ArrayList<ConfigurableItemStack> itemStacks = new ArrayList<ConfigurableItemStack>();
        ArrayList<ConfigurableFluidStack> fluidStacks = new ArrayList<ConfigurableFluidStack>();
        class_2487 tag = buf.method_10798();
        NbtHelper.getList(tag, "items", itemStacks, ConfigurableItemStack::new);
        NbtHelper.getList(tag, "fluids", fluidStacks, ConfigurableFluidStack::new);
        SlotPositions itemPositions = SlotPositions.read(buf);
        SlotPositions fluidPositions = SlotPositions.read(buf);
        MIInventory inventory = new MIInventory(itemStacks, fluidStacks, itemPositions, fluidPositions);
        ArrayList<SyncedComponent.Client> components = new ArrayList<SyncedComponent.Client>();
        int componentCount = buf.readInt();
        for (int i = 0; i < componentCount; ++i) {
            class_2960 id = buf.method_10810();
            components.add(SyncedComponents.Client.get(id).createFromInitialData(buf));
        }
        MachineGuiParameters guiParams = MachineGuiParameters.read(buf);
        return new Client(syncId, playerInventory, inventory, components, guiParams);
    }

    public static class Client
    extends Common {
        public final List<SyncedComponent.Client> components;

        Client(int syncId, class_1661 playerInventory, MIInventory inventory, List<SyncedComponent.Client> components, MachineGuiParameters guiParams) {
            super(syncId, playerInventory, inventory, guiParams);
            this.components = components;
        }

        @Nullable
        public <T extends SyncedComponent.Client> T getComponent(Class<T> klass) {
            for (SyncedComponent.Client component : this.components) {
                if (!klass.isInstance(component)) continue;
                return (T)component;
            }
            return null;
        }

        public boolean method_7597(class_1657 player) {
            return true;
        }
    }

    public static class ClientScreen
    extends MIHandledScreen<Client>
    implements ClientComponentRenderer.ButtonContainer {
        private final List<ClientComponentRenderer> renderers = new ArrayList<ClientComponentRenderer>();
        private int nextButtonX;
        private static final int BUTTON_Y = 4;

        public ClientScreen(Client handler, class_1661 inventory, class_2561 title) {
            super(handler, inventory, title);
            for (SyncedComponent.Client component : handler.components) {
                this.renderers.add(component.createRenderer());
            }
            this.field_2779 = handler.guiParams.backgroundHeight;
            this.field_2792 = handler.guiParams.backgroundWidth;
            this.field_25270 = this.field_2779 - 94;
        }

        public int x() {
            return this.field_2776;
        }

        public int y() {
            return this.field_2800;
        }

        private int buttonX() {
            this.nextButtonX -= 22;
            return this.nextButtonX + 22 + this.field_2776;
        }

        private int buttonY() {
            return 4 + this.field_2800;
        }

        protected void method_25426() {
            super.method_25426();
            this.nextButtonX = 152;
            if (((Client)this.field_2797).guiParams.lockButton) {
                this.addLockButton();
            }
            for (ClientComponentRenderer renderer : this.renderers) {
                renderer.addButtons(this);
            }
        }

        @Override
        public void addButton(int u, class_2561 message, Consumer<Integer> pressAction, Supplier<List<class_2561>> tooltipSupplier, Supplier<Boolean> isPressed) {
            this.method_37063((class_364)new MachineButton(this.buttonX(), this.buttonY(), 20, 20, message, b -> pressAction.accept(((Client)this.field_2797).field_7763), (button, matrices, mouseX, mouseY) -> this.method_30901(matrices, (List)tooltipSupplier.get(), mouseX, mouseY), (screen, button, matrices, mouseX, mouseY, delta) -> {
                RenderSystem.setShaderTexture((int)0, (class_2960)SLOT_ATLAS);
                int v = 18;
                if (((Boolean)isPressed.get()).booleanValue()) {
                    v += 20;
                }
                this.method_25302(matrices, button.field_22760, button.field_22761, u, v, 20, 20);
                if (button.method_25367()) {
                    this.method_25302(matrices, button.field_22760, button.field_22761, 60, 18, 20, 20);
                    button.method_25352(matrices, mouseX, mouseY);
                }
            }));
        }

        @Override
        public void addButton(int posX, int posY, int width, int height, class_2561 message, Consumer<Integer> pressAction, Supplier<List<class_2561>> tooltipSupplier, ClientComponentRenderer.CustomButtonRenderer renderer, Supplier<Boolean> isButtonPresent) {
            this.method_37063((class_364)new MachineButton(posX + this.field_2776, posY + this.field_2800, width, height, message, b -> {
                if (((Boolean)isButtonPresent.get()).booleanValue()) {
                    pressAction.accept(((Client)this.field_2797).field_7763);
                }
            }, (button, matrices, mouseX, mouseY) -> {
                if (((Boolean)isButtonPresent.get()).booleanValue()) {
                    this.method_30901(matrices, (List)tooltipSupplier.get(), mouseX, mouseY);
                }
            }, (screen, button, matrices, mouseX, mouseY, delta) -> {
                if (((Boolean)isButtonPresent.get()).booleanValue()) {
                    renderer.renderButton(screen, button, matrices, mouseX, mouseY, delta);
                }
            }){});
        }

        private void addLockButton() {
            this.addButton(40, (class_2561)new class_2585("slot locking"), syncId -> {
                boolean newLockingMode;
                ((Client)this.field_2797).lockingMode = newLockingMode = !((Client)this.field_2797).lockingMode;
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(syncId.intValue());
                buf.writeBoolean(newLockingMode);
                ClientPlayNetworking.send((class_2960)ConfigurableInventoryPackets.SET_LOCKING_MODE, (class_2540)buf);
            }, () -> {
                ArrayList<Object> lines = new ArrayList<Object>();
                if (((Client)this.field_2797).lockingMode) {
                    lines.add(new class_2588("text.modern_industrialization.locking_mode_on"));
                    lines.add(new class_2588("text.modern_industrialization.click_to_disable").method_10862(TextHelper.GRAY_TEXT));
                } else {
                    lines.add(new class_2588("text.modern_industrialization.locking_mode_off"));
                    lines.add(new class_2588("text.modern_industrialization.click_to_enable").method_10862(TextHelper.GRAY_TEXT));
                }
                return lines;
            }, () -> ((Client)this.field_2797).lockingMode);
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.method_25420(matrices);
            RenderSystem.enableBlend();
            this.actualDrawBackground(matrices);
            this.renderConfigurableSlotBackgrounds(matrices);
            this.renderFluidSlots(matrices, mouseX, mouseY);
            this.renderLockedItems();
            super.method_25394(matrices, mouseX, mouseY, delta);
            this.renderConfigurableSlotTooltips(matrices, mouseX, mouseY);
            for (ClientComponentRenderer renderer : this.renderers) {
                renderer.renderTooltip(this, matrices, this.field_2776, this.field_2800, mouseX, mouseY);
            }
        }

        private void actualDrawBackground(class_4587 matrices) {
            RenderSystem.setShaderTexture((int)0, (class_2960)new MIIdentifier("textures/gui/container/background.png"));
            int bw = ((Client)this.field_2797).guiParams.backgroundWidth;
            int bh = ((Client)this.field_2797).guiParams.backgroundHeight;
            this.method_25302(matrices, this.field_2776, this.field_2800 + 4, 0, 256 - bh + 4, bw, bh - 4);
            this.method_25302(matrices, this.field_2776, this.field_2800, 0, 0, bw, 4);
            for (ClientComponentRenderer renderer : this.renderers) {
                renderer.renderBackground((class_332)this, matrices, this.field_2776, this.field_2800);
            }
        }

        private void renderConfigurableSlotBackgrounds(class_4587 matrices) {
            RenderSystem.setShaderTexture((int)0, (class_2960)SLOT_ATLAS);
            for (class_1735 slot : ((Client)this.field_2797).field_7761) {
                int u;
                int px = this.field_2776 + slot.field_7873 - 1;
                int py = this.field_2800 + slot.field_7872 - 1;
                if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
                    ConfigurableFluidStack.ConfigurableFluidSlot fluidSlot = (ConfigurableFluidStack.ConfigurableFluidSlot)slot;
                    u = fluidSlot.getConfStack().isPlayerLocked() ? 90 : (fluidSlot.getConfStack().isMachineLocked() ? 126 : 18);
                } else {
                    if (!(slot instanceof ConfigurableItemStack.ConfigurableItemSlot)) continue;
                    ConfigurableItemStack.ConfigurableItemSlot itemSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot;
                    u = itemSlot.getConfStack().isPlayerLocked() ? 72 : (itemSlot.getConfStack().isMachineLocked() ? 108 : 0);
                }
                this.method_25302(matrices, px, py, u, 0, 18, 18);
            }
        }

        private void renderFluidSlots(class_4587 matrices, int mouseX, int mouseY) {
            for (class_1735 slot : ((Client)this.field_2797).field_7761) {
                FluidVariant renderedKey;
                if (!(slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot)) continue;
                int i = this.field_2776 + slot.field_7873;
                int j = this.field_2800 + slot.field_7872;
                ConfigurableFluidStack stack = ((ConfigurableFluidStack.ConfigurableFluidSlot)slot).getConfStack();
                FluidVariant fluidVariant = renderedKey = stack.getLockedInstance() == null ? (FluidVariant)stack.getResource() : FluidVariant.of((class_3611)((class_3611)stack.getLockedInstance()));
                if (!renderedKey.isBlank()) {
                    RenderHelper.drawFluidInGui(matrices, renderedKey, i, j);
                }
                if (!this.method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY) || !slot.method_7682()) continue;
                this.field_2787 = slot;
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.method_25296(matrices, i, j, i + 16, j + 16, -2130706433, -2130706433);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                RenderSystem.enableDepthTest();
            }
        }

        private void renderLockedItems() {
            for (class_1735 slot : ((Client)this.field_2797).field_7761) {
                class_1792 item;
                ConfigurableItemStack.ConfigurableItemSlot itemSlot;
                ConfigurableItemStack itemStack;
                if (!(slot instanceof ConfigurableItemStack.ConfigurableItemSlot) || !(itemStack = (itemSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot).getConfStack()).isPlayerLocked() && !itemStack.isMachineLocked() || !((ItemVariant)itemStack.getResource()).isBlank() || (item = (class_1792)itemStack.getLockedInstance()) == class_1802.field_8162) continue;
                this.renderItemInGui(new class_1799((class_1935)item), slot.field_7873 + this.field_2776, slot.field_7872 + this.field_2800, "0");
            }
        }

        public void renderItemInGui(class_1799 itemStack, int x, int y) {
            this.renderItemInGui(itemStack, x, y, null);
        }

        public void renderItemInGui(class_1799 itemStack, int x, int y, String countLabel) {
            this.method_25304(100);
            this.field_22788.field_4730 = 100.0f;
            RenderSystem.enableDepthTest();
            this.field_22788.method_27951((class_1309)this.field_22787.field_1724, itemStack, x, y, 0);
            this.field_22788.method_4022(this.field_22793, itemStack, x, y, countLabel);
            this.field_22788.field_4730 = 0.0f;
            this.method_25304(0);
        }

        public class_918 getItemRenderer() {
            return this.field_22788;
        }

        private void renderConfigurableSlotTooltips(class_4587 matrices, int mouseX, int mouseY) {
            class_1735 slot = this.field_2787;
            if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
                ConfigurableFluidStack stack = ((ConfigurableFluidStack.ConfigurableFluidSlot)slot).getConfStack();
                FluidVariant renderedKey = stack.isPlayerLocked() ? FluidVariant.of((class_3611)((class_3611)stack.getLockedInstance())) : (FluidVariant)stack.getResource();
                ArrayList<class_2561> tooltip = new ArrayList<class_2561>(FluidHelper.getTooltipForFluidStorage(renderedKey, stack.getAmount(), stack.getCapacity(), false));
                if (stack.canPlayerInsert()) {
                    if (stack.canPlayerExtract()) {
                        tooltip.add((class_2561)new class_2588("text.modern_industrialization.fluid_slot_IO").method_10862(TextHelper.GRAY_TEXT));
                    } else {
                        tooltip.add((class_2561)new class_2588("text.modern_industrialization.fluid_slot_input").method_10862(TextHelper.GRAY_TEXT));
                    }
                } else if (stack.canPlayerExtract()) {
                    tooltip.add((class_2561)new class_2588("text.modern_industrialization.fluid_slot_output").method_10862(TextHelper.GRAY_TEXT));
                }
                this.method_30901(matrices, tooltip, mouseX, mouseY);
            } else if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot) {
                ConfigurableItemStack.ConfigurableItemSlot confSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot;
                this.renderConfigurableItemStackTooltip(matrices, confSlot.getConfStack(), mouseX, mouseY);
            } else if (slot != null && slot.method_7681()) {
                this.method_25409(matrices, slot.method_7677(), mouseX, mouseY);
            }
        }

        private void renderConfigurableItemStackTooltip(class_4587 matrices, ConfigurableItemStack stack, int mouseX, int mouseY) {
            List<class_5250> textTooltip;
            class_1799 vanillaStack;
            class_1799 class_17992 = stack.isEmpty() ? (stack.getLockedInstance() == null ? class_1799.field_8037 : new class_1799((class_1935)stack.getLockedInstance())) : (vanillaStack = ((ItemVariant)stack.getResource()).toStack((int)stack.getAmount()));
            if (vanillaStack.method_7960()) {
                textTooltip = new ArrayList();
                textTooltip.add((class_5250)new class_2588("text.modern_industrialization.empty"));
            } else {
                textTooltip = this.method_25408(vanillaStack);
            }
            Optional data = vanillaStack.method_32347();
            class_2585 capacityText = new class_2585(String.valueOf(stack.getAdjustedCapacity()));
            if (stack.getAdjustedCapacity() != 64) {
                capacityText.method_10862(TextHelper.YELLOW_BOLD);
            }
            textTooltip.add(new class_2588("text.modern_industrialization.configurable_slot_capacity", new Object[]{capacityText}).method_10862(TextHelper.GRAY_TEXT));
            this.method_32634(matrices, textTooltip, data, mouseX, mouseY);
        }

        protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        }

        public boolean method_25401(double mouseX, double mouseY, double amount) {
            class_1735 class_17352 = this.field_2787;
            if (class_17352 instanceof ConfigurableItemStack.ConfigurableItemSlot) {
                ConfigurableItemStack.ConfigurableItemSlot confSlot = (ConfigurableItemStack.ConfigurableItemSlot)class_17352;
                ConfigurableItemStack stack = confSlot.getConfStack();
                boolean isIncrease = amount > 0.0;
                boolean isShiftDown = ClientScreen.method_25442();
                stack.adjustCapacity(isIncrease, isShiftDown);
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(((Client)this.field_2797).field_7763);
                buf.method_10804(((Client)this.field_2797).field_7761.indexOf((Object)this.field_2787));
                buf.writeBoolean(isIncrease);
                buf.writeBoolean(isShiftDown);
                ClientPlayNetworking.send((class_2960)ConfigurableInventoryPackets.ADJUST_SLOT_CAPACITY, (class_2540)buf);
                return true;
            }
            return false;
        }

        @Override
        public class_1735 getFocusedSlot() {
            return this.field_2787;
        }

        public class MachineButton
        extends class_4185 {
            final ClientComponentRenderer.CustomButtonRenderer renderer;

            private MachineButton(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress, class_4185.class_5316 tooltipSupplier, ClientComponentRenderer.CustomButtonRenderer renderer) {
                super(x, y, width, height, message, onPress, tooltipSupplier);
                this.renderer = renderer;
            }

            public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
                this.renderer.renderButton((class_437)ClientScreen.this, this, matrices, mouseX, mouseY, delta);
            }

            public void renderVanilla(class_4587 matrices, int mouseX, int mouseY, float delta) {
                super.method_25359(matrices, mouseX, mouseY, delta);
            }
        }
    }

    static class Server
    extends Common {
        public final MachineBlockEntity blockEntity;
        protected final List trackedData;

        Server(int syncId, class_1661 playerInventory, MachineBlockEntity blockEntity, MachineGuiParameters guiParams) {
            super(syncId, playerInventory, blockEntity.getInventory(), guiParams);
            this.blockEntity = blockEntity;
            this.trackedData = new ArrayList();
            for (SyncedComponent.Server component : blockEntity.syncedComponents) {
                this.trackedData.add(component.copyData());
            }
        }

        @Override
        public void method_7623() {
            super.method_7623();
            for (int i = 0; i < this.blockEntity.syncedComponents.size(); ++i) {
                SyncedComponent.Server component = this.blockEntity.syncedComponents.get(i);
                if (!component.needsSync(this.trackedData.get(i))) continue;
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(this.field_7763);
                buf.writeInt(i);
                component.writeCurrentData(buf);
                ServerPlayNetworking.send((class_3222)((class_3222)this.playerInventory.field_7546), (class_2960)MachinePackets.S2C.COMPONENT_SYNC, (class_2540)buf);
                this.trackedData.set(i, component.copyData());
            }
        }

        public boolean method_7597(class_1657 player) {
            class_2338 pos = this.blockEntity.method_11016();
            if (player.field_6002.method_8321(pos) != this.blockEntity) {
                return false;
            }
            return player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 64.0;
        }
    }

    public static abstract class Common
    extends ConfigurableScreenHandler {
        public final MachineGuiParameters guiParams;

        Common(int syncId, class_1661 playerInventory, MIInventory inventory, MachineGuiParameters guiParams) {
            super(ModernIndustrialization.SCREEN_HANDLER_MACHINE, syncId, playerInventory, inventory);
            int i;
            this.guiParams = guiParams;
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.method_7621(new class_1735((class_1263)playerInventory, i * 9 + j + 9, guiParams.playerInventoryX + j * 18, guiParams.playerInventoryY + i * 18));
                }
            }
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j, guiParams.playerInventoryX + j * 18, guiParams.playerInventoryY + 58));
            }
            for (i = 0; i < inventory.getItemStacks().size(); ++i) {
                ConfigurableItemStack stack = inventory.getItemStacks().get(i);
                this.method_7621(stack.new ConfigurableItemStack.ConfigurableItemSlot(() -> {}, inventory.itemPositions.getX(i), inventory.itemPositions.getY(i), s -> true));
            }
            for (i = 0; i < inventory.getFluidStacks().size(); ++i) {
                ConfigurableFluidStack stack = inventory.getFluidStacks().get(i);
                this.method_7621(stack.new ConfigurableFluidStack.ConfigurableFluidSlot(() -> {}, inventory.fluidPositions.getX(i), inventory.fluidPositions.getY(i)));
            }
        }
    }
}

