/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.util.GeometryHelper;
import aztech.modern_industrialization.util.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1159;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4588;

public class MachineOverlay {
    private static final double SIDE = 0.25;
    public static final double[] ZONES = new double[]{0.0, 0.25, 0.75, 1.0};
    public static final List<class_265> OVERLAY_SHAPES = new ArrayList<class_265>();
    public static final List<List<class_2350>> TOUCHING_DIRECTIONS = new ArrayList<List<class_2350>>();

    public static class_243 getPosInBlock(class_3965 blockHitResult) {
        class_2338 blockPos = blockHitResult.method_17777();
        return blockHitResult.method_17784().method_1023((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
    }

    public static int findHitIndex(class_243 posInBlock) {
        for (int i = 0; i < OVERLAY_SHAPES.size(); ++i) {
            class_243 dir;
            class_238 box = OVERLAY_SHAPES.get(i).method_1107();
            if (!box.method_1006(posInBlock.method_1019(dir = box.method_1005().method_1020(posInBlock).method_1029().method_1021(1.0E-4)))) continue;
            return i;
        }
        throw new UnsupportedOperationException("Hit shape could not be found :(");
    }

    public static class_2350 findHitSide(class_243 posInBlock, class_2350 hitFace) {
        int i = MachineOverlay.findHitIndex(posInBlock);
        List<class_2350> shapeDirections = TOUCHING_DIRECTIONS.get(i);
        if (shapeDirections.size() == 1) {
            return hitFace;
        }
        if (shapeDirections.size() == 3) {
            return hitFace.method_10153();
        }
        for (class_2350 direction : shapeDirections) {
            if (direction == hitFace) continue;
            return direction;
        }
        throw new RuntimeException("Unreachable!");
    }

    public static class_2350 findHitSide(class_3965 bhr) {
        return MachineOverlay.findHitSide(MachineOverlay.getPosInBlock(bhr), bhr.method_17780());
    }

    public static boolean onBlockOutline(WorldRenderContext wrc, WorldRenderContext.BlockOutlineContext boc) {
        class_239 hitResult = class_310.method_1551().field_1765;
        if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)hitResult;
            class_2338 pos = blockHitResult.method_17777();
            class_2680 state = wrc.world().method_8320(pos);
            if (state.method_26204() instanceof MachineBlock && class_310.method_1551().field_1724.method_6047().method_31573(ModernIndustrialization.WRENCHES)) {
                wrc.matrixStack().method_22903();
                class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
                double x = (double)pos.method_10263() - cameraPos.field_1352;
                double y = (double)pos.method_10264() - cameraPos.field_1351;
                double z = (double)pos.method_10260() - cameraPos.field_1350;
                wrc.matrixStack().method_22904(x, y, z);
                class_243 posInBlock = MachineOverlay.getPosInBlock(blockHitResult);
                class_243 posOnFace = GeometryHelper.toFaceCoords(posInBlock, blockHitResult.method_17780());
                MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
                class_4588 vc = wrc.consumers().getBuffer(class_1921.method_23583());
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        double minX = ZONES[i];
                        double maxX = ZONES[i + 1];
                        double minY = ZONES[j];
                        double maxY = ZONES[j + 1];
                        boolean insideQuad = minX <= posOnFace.field_1352 && posOnFace.field_1352 <= maxX && minY <= posOnFace.field_1351 && posOnFace.field_1351 <= maxY;
                        QuadEmitter emitter = meshBuilder.getEmitter();
                        emitter.square(blockHitResult.method_17780(), (float)minX, (float)minY, (float)maxX, (float)maxY, -3.5E-4f);
                        float r = 0.0f;
                        float g = insideQuad ? 1.0f : 0.0f;
                        float b = insideQuad ? 0.0f : 1.0f;
                        RenderHelper.quadWithAlpha(vc, wrc.matrixStack().method_23760(), emitter.toBakedQuad(0, null, false), r, g, b, 0.5f, Integer.MAX_VALUE, -2130706433);
                    }
                }
                class_4588 lines = wrc.consumers().getBuffer(class_1921.method_23594());
                class_1159 model = wrc.matrixStack().method_23760().method_23761();
                class_2350 face = blockHitResult.method_17780();
                MachineOverlay.vertex(model, lines, face, ZONES[1], ZONES[0]);
                MachineOverlay.vertex(model, lines, face, ZONES[1], ZONES[3]);
                MachineOverlay.vertex(model, lines, face, ZONES[2], ZONES[0]);
                MachineOverlay.vertex(model, lines, face, ZONES[2], ZONES[3]);
                MachineOverlay.vertex(model, lines, face, ZONES[0], ZONES[1]);
                MachineOverlay.vertex(model, lines, face, ZONES[3], ZONES[1]);
                MachineOverlay.vertex(model, lines, face, ZONES[0], ZONES[2]);
                MachineOverlay.vertex(model, lines, face, ZONES[3], ZONES[2]);
                wrc.matrixStack().method_22909();
            }
        }
        return true;
    }

    private static void vertex(class_1159 model, class_4588 lines, class_2350 face, double faceX, double faceY) {
        class_243 coord = GeometryHelper.toWorldCoords(new class_243(faceX, faceY, 0.0), face);
        lines.method_22918(model, (float)coord.field_1352, (float)coord.field_1351, (float)coord.field_1350).method_22915(0.0f, 0.0f, 0.0f, 0.4f).method_22914(0.0f, 0.0f, 0.0f).method_1344();
    }

    static {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    ArrayList<class_2350> directions = new ArrayList<class_2350>();
                    OVERLAY_SHAPES.add(class_259.method_1081((double)ZONES[i], (double)ZONES[j], (double)ZONES[k], (double)ZONES[i + 1], (double)ZONES[j + 1], (double)ZONES[k + 1]));
                    if (i == 0) {
                        directions.add(class_2350.field_11039);
                    }
                    if (i == 2) {
                        directions.add(class_2350.field_11034);
                    }
                    if (j == 0) {
                        directions.add(class_2350.field_11033);
                    }
                    if (j == 2) {
                        directions.add(class_2350.field_11036);
                    }
                    if (k == 0) {
                        directions.add(class_2350.field_11043);
                    }
                    if (k == 2) {
                        directions.add(class_2350.field_11035);
                    }
                    TOUCHING_DIRECTIONS.add(directions);
                }
            }
        }
    }
}

