/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import com.google.common.base.Preconditions;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public interface ItemContainingItemHelper {
    public long getStackCapacity();

    default public boolean canDirectInsert(class_1799 stack) {
        return stack.method_7909().method_31568();
    }

    default public boolean isEmpty(class_1799 stack) {
        return stack.method_7941("BlockEntityTag") == null;
    }

    default public ItemVariant getItemVariant(class_1799 stack) {
        if (this.isEmpty(stack)) {
            return ItemVariant.blank();
        }
        return ItemVariant.fromNbt((class_2487)stack.method_7941("BlockEntityTag").method_10562("item"));
    }

    private void setItemVariant(class_1799 stack, ItemVariant item) {
        stack.method_7911("BlockEntityTag").method_10566("item", (class_2520)item.toNbt());
    }

    default public long insert(class_1799 stackBarrel, ItemVariant inserted, long maxAmount) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)inserted, (long)maxAmount);
        if (this.isEmpty(stackBarrel) || this.getItemVariant(stackBarrel).equals(inserted)) {
            long maxInsert = this.getCapacity(inserted) - this.getAmount(stackBarrel);
            long insertedAmount = Math.min(maxAmount, maxInsert);
            if (insertedAmount > 0L) {
                this.setAmount(stackBarrel, this.getAmount(stackBarrel) + insertedAmount);
                this.setItemVariant(stackBarrel, inserted);
            }
            return insertedAmount;
        }
        return 0L;
    }

    default public long getAmount(class_1799 stack) {
        if (this.getItemVariant(stack).isBlank()) {
            return 0L;
        }
        class_2487 tag = stack.method_7941("BlockEntityTag");
        if (tag == null) {
            return 0L;
        }
        return tag.method_10537("amt");
    }

    default public void setAmount(class_1799 stack, long amount) {
        Preconditions.checkArgument((amount >= 0L ? 1 : 0) != 0, (Object)"Can not set a barrel item to a negative amount");
        stack.method_7911("BlockEntityTag").method_10544("amt", amount);
        if (amount == 0L) {
            stack.method_7983("BlockEntityTag");
        }
    }

    default public long getCapacity(ItemVariant variant) {
        return this.getStackCapacity() * (long)variant.getItem().method_7882();
    }

    default public long getCurrentCapacity(class_1799 barrelStack) {
        return this.getStackCapacity() * (long)this.getItemVariant(barrelStack).getItem().method_7882();
    }

    default public boolean handleStackedOnOther(class_1799 stackBarrel, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player)) {
            MutableObject ref = new MutableObject((Object)slot.method_7677());
            boolean result = this.handleClick(stackBarrel, (Mutable<class_1799>)ref);
            slot.method_7673((class_1799)ref.getValue());
            return result;
        }
        return false;
    }

    default public boolean handleOtherStackedOnMe(class_1799 stackBarrel, class_1799 itemStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player)) {
            MutableObject ref = new MutableObject((Object)itemStack);
            boolean result = this.handleClick(stackBarrel, (Mutable<class_1799>)ref);
            cursorStackReference.method_32332((class_1799)ref.getValue());
            slot.method_7668();
            return result;
        }
        return false;
    }

    private boolean handleClick(class_1799 stackBarrel, Mutable<class_1799> otherStack) {
        class_1799 other = ((class_1799)otherStack.getValue()).method_7972();
        if ((this.isEmpty(stackBarrel) || this.getItemVariant(stackBarrel).matches(other)) && !other.method_7960() && this.canDirectInsert(other)) {
            other.method_7934((int)this.insert(stackBarrel, ItemVariant.of((class_1799)other), other.method_7947()));
            otherStack.setValue((Object)other);
            return true;
        }
        if (!this.isEmpty(stackBarrel) && other.method_7960()) {
            int amount = (int)Math.min(this.getAmount(stackBarrel), (long)this.getItemVariant(stackBarrel).getItem().method_7882());
            class_1799 newStack = this.getItemVariant(stackBarrel).toStack(amount);
            otherStack.setValue((Object)newStack);
            this.setAmount(stackBarrel, this.getAmount(stackBarrel) - (long)amount);
            return true;
        }
        return !this.isEmpty(stackBarrel) || !other.method_7960();
    }
}

