/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPackets;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public abstract class ConfigurableScreenHandler
extends class_1703 {
    private static final int PLAYER_SLOTS = 36;
    public boolean lockingMode = false;
    protected class_1661 playerInventory;
    protected MIInventory inventory;
    private List<ConfigurableItemStack> trackedItems;
    private List<ConfigurableFluidStack> trackedFluids;

    protected ConfigurableScreenHandler(class_3917<?> type, int syncId, class_1661 playerInventory, MIInventory inventory) {
        super(type, syncId);
        this.playerInventory = playerInventory;
        this.inventory = inventory;
        if (playerInventory.field_7546 instanceof class_3222) {
            this.trackedItems = ConfigurableItemStack.copyList(inventory.getItemStacks());
            this.trackedFluids = ConfigurableFluidStack.copyList(inventory.getFluidStacks());
        }
    }

    public void method_7623() {
        if (this.playerInventory.field_7546 instanceof class_3222) {
            class_2540 buf;
            int i;
            class_3222 player = (class_3222)this.playerInventory.field_7546;
            for (i = 0; i < this.trackedItems.size(); ++i) {
                if (this.trackedItems.get(i).equals(this.inventory.getItemStacks().get(i))) continue;
                this.trackedItems.set(i, new ConfigurableItemStack(this.inventory.getItemStacks().get(i)));
                buf = new class_2540(Unpooled.buffer());
                buf.writeInt(this.field_7763);
                buf.writeInt(i);
                buf.method_10794(this.trackedItems.get(i).toNbt());
                ServerSidePacketRegistry.INSTANCE.sendToPlayer((class_1657)player, ConfigurableInventoryPackets.UPDATE_ITEM_SLOT, buf);
            }
            for (i = 0; i < this.trackedFluids.size(); ++i) {
                if (this.trackedFluids.get(i).equals(this.inventory.getFluidStacks().get(i))) continue;
                this.trackedFluids.set(i, new ConfigurableFluidStack(this.inventory.getFluidStacks().get(i)));
                buf = new class_2540(Unpooled.buffer());
                buf.writeInt(this.field_7763);
                buf.writeInt(i);
                buf.method_10794(this.trackedFluids.get(i).toNbt());
                ServerSidePacketRegistry.INSTANCE.sendToPlayer((class_1657)player, ConfigurableInventoryPackets.UPDATE_FLUID_SLOT, buf);
            }
        }
        super.method_7623();
    }

    public void method_7593(int i, int j, class_1713 actionType, class_1657 playerEntity) {
        if (i >= 0) {
            class_1735 slot = (class_1735)this.field_7761.get(i);
            if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
                ConfigurableFluidStack.ConfigurableFluidSlot fluidSlot = (ConfigurableFluidStack.ConfigurableFluidSlot)slot;
                if (actionType != class_1713.field_7790) {
                    return;
                }
                ConfigurableFluidStack fluidStack = fluidSlot.getConfStack();
                if (this.lockingMode) {
                    fluidStack.togglePlayerLock();
                } else {
                    Storage io = (Storage)ContainerItemContext.ofPlayerCursor((class_1657)playerEntity, (class_1703)this).find(FluidStorage.ITEM);
                    if (io != null) {
                        long previousAmount = fluidStack.amount;
                        try (Transaction transaction = Transaction.openOuter();){
                            for (StorageView view : io.iterable((TransactionContext)transaction)) {
                                FluidVariant fluid = (FluidVariant)view.getResource();
                                if (fluid.isBlank() || !fluidSlot.canInsertFluid(fluid)) continue;
                                Transaction tx = transaction.openNested();
                                try {
                                    long extracted = view.extract((Object)fluid, fluidStack.getRemainingSpace(), (TransactionContext)tx);
                                    if (extracted <= 0L) continue;
                                    tx.commit();
                                    fluidStack.increment(extracted);
                                    fluidStack.setKey(fluid);
                                }
                                finally {
                                    if (tx == null) continue;
                                    tx.close();
                                }
                            }
                            transaction.commit();
                        }
                        if (previousAmount != fluidStack.amount) {
                            return;
                        }
                        FluidVariant fluid = (FluidVariant)fluidStack.getResource();
                        if (!fluid.isBlank() && fluidSlot.canExtractFluid(fluid)) {
                            try (Transaction tx = Transaction.openOuter();){
                                fluidStack.decrement(io.insert((Object)fluid, fluidStack.getAmount(), (TransactionContext)tx));
                                tx.commit();
                                return;
                            }
                        }
                    }
                }
                return;
            }
            if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot && this.lockingMode) {
                if (actionType != class_1713.field_7790) {
                    return;
                }
                ConfigurableItemStack.ConfigurableItemSlot itemSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot;
                ConfigurableItemStack itemStack = itemSlot.getConfStack();
                itemStack.togglePlayerLock(this.method_34255().method_7909());
                return;
            }
        }
        super.method_7593(i, j, actionType, playerEntity);
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot != null && slot.method_7681() && slot.method_7674(player) && (slotIndex < 36 ? !this.insertItem(slot, 36, this.field_7761.size(), false) && (slotIndex < 27 ? !this.insertItem(slot, 27, 36, false) : !this.insertItem(slot, 0, 27, false)) : !this.insertItem(slot, 0, 36, true))) {
            return class_1799.field_8037;
        }
        return class_1799.field_8037;
    }

    @Deprecated
    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean fromLast) {
        throw new UnsupportedOperationException("Don't use this shit, use the one below instead.");
    }

    protected boolean insertItem(class_1735 sourceSlot, int startIndex, int endIndex, boolean fromLast) {
        boolean insertedSomething = false;
        for (int iter = 0; iter < 2; ++iter) {
            int i;
            boolean allowEmptySlots = iter == 1;
            int n = i = fromLast ? endIndex - 1 : startIndex;
            while (0 <= i && i < endIndex && !sourceSlot.method_7677().method_7960()) {
                int maxInsert;
                class_1735 targetSlot = this.method_7611(i);
                class_1799 sourceStack = sourceSlot.method_7677();
                class_1799 targetStack = targetSlot.method_7677();
                if (targetSlot.method_7680(sourceStack) && (allowEmptySlots && targetStack.method_7960() || class_1799.method_31577((class_1799)targetStack, (class_1799)sourceStack)) && (maxInsert = targetSlot.method_7676(sourceStack) - targetStack.method_7947()) > 0) {
                    class_1799 newTargetStack = sourceStack.method_7971(maxInsert);
                    newTargetStack.method_7933(targetStack.method_7947());
                    targetSlot.method_7673(newTargetStack);
                    sourceSlot.method_7668();
                    insertedSomething = true;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return insertedSomething;
    }
}

