/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.fluid.CraftingFluid;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2444;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class HeatExchangerRecipesProvider
extends MIRecipesProvider {
    public HeatExchangerRecipesProvider(FabricDataGenerator dataGenerator) {
        super(dataGenerator);
    }

    private static String fluidToString(class_3611 f, boolean id) {
        if (f == class_3612.field_15910) {
            return (id ? "minecraft:" : "") + "water";
        }
        if (f == class_3612.field_15908) {
            return (id ? "minecraft:" : "") + "lava";
        }
        CraftingFluid fluid = (CraftingFluid)f;
        return (id ? "modern_industrialization:" : "") + fluid.name;
    }

    protected void generateRecipes(Consumer<class_2444> consumer) {
        class_3611[] hots = new class_3611[]{MIFluids.STEAM, MIFluids.HEAVY_WATER_STEAM, MIFluids.HIGH_PRESSURE_HEAVY_WATER_STEAM, MIFluids.HIGH_PRESSURE_STEAM};
        class_3611[] cold = new class_3611[]{class_3612.field_15910, MIFluids.HEAVY_WATER, MIFluids.HIGH_PRESSURE_HEAVY_WATER, MIFluids.HIGH_PRESSURE_WATER};
        int[] amount = new int[]{1, 1, 8, 8};
        int amountBaseHot = 16000;
        int amountBaseCold = 1000;
        for (int i = 0; i < hots.length; ++i) {
            for (int j = 0; j < cold.length; ++j) {
                if (i == j) continue;
                MIRecipeJson recipe = MIRecipeJson.create(MIMachineRecipeTypes.HEAT_EXCHANGER, 2, 300);
                String path = "heat_exchanger/" + HeatExchangerRecipesProvider.fluidToString(hots[i], false) + "_with_" + HeatExchangerRecipesProvider.fluidToString(cold[j], false);
                recipe.addFluidInput(HeatExchangerRecipesProvider.fluidToString(hots[i], true), amountBaseHot / amount[i]);
                recipe.addFluidInput(HeatExchangerRecipesProvider.fluidToString(cold[j], true), amountBaseCold / amount[j]);
                recipe.addFluidOutput(HeatExchangerRecipesProvider.fluidToString(cold[i], true), amountBaseCold / amount[i]);
                recipe.addFluidOutput(HeatExchangerRecipesProvider.fluidToString(hots[j], true), amountBaseHot / amount[j]);
                recipe.offerTo(consumer, path);
            }
        }
    }
}

