/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import aztech.modern_industrialization.recipe.json.ShapedRecipeJson;
import com.google.gson.Gson;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3304;
import org.apache.commons.io.IOUtils;

public class AssemblerRecipesProvider
extends MIRecipesProvider {
    private static final Gson GSON = new Gson();
    private final FabricDataGenerator dataGenerator;

    public AssemblerRecipesProvider(FabricDataGenerator dataGenerator) {
        super(dataGenerator);
        this.dataGenerator = dataGenerator;
    }

    protected void generateRecipes(Consumer<class_2444> consumer) {
        Path nonGeneratedResources = this.dataGenerator.method_10313().resolve("../../main/resources");
        class_3304 manager = new class_3304(class_3264.field_14190);
        manager.method_14475((class_3262)new class_3259(nonGeneratedResources.toFile()));
        Collection possibleTargets = manager.method_14488("recipes", path -> path.endsWith(".json"));
        for (class_2960 pathId : possibleTargets) {
            if (!AssemblerRecipesProvider.shouldConvertToAssembler(pathId)) continue;
            try {
                class_3298 resource = manager.method_14486(pathId);
                try {
                    AssemblerRecipesProvider.convertToAssembler(consumer, pathId, IOUtils.toByteArray((InputStream)resource.method_14482()));
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to convert asbl recipe %s. Error: %s".formatted(pathId, exception), exception);
            }
        }
    }

    public static boolean shouldConvertToAssembler(class_2960 pathId) {
        if (pathId.method_12836().equals("modern_industrialization")) {
            String path = pathId.toString();
            String postfix = path.substring(path.length() - 10, path.length() - 5);
            if (postfix.equals("_asbl")) {
                return true;
            }
            if (postfix.contains("_") && postfix.contains("a") && postfix.contains("s") && postfix.contains("b") && postfix.contains("l")) {
                throw new RuntimeException("Detected potential typo in _asbl.json. Crashing just to be safe. Recipe path: " + path);
            }
        }
        return false;
    }

    public static void convertToAssembler(Consumer<class_2444> consumer, class_2960 recipeId, byte[] recipe) {
        String recipeString = new String(recipe, StandardCharsets.UTF_8);
        ShapedRecipeJson json = (ShapedRecipeJson)GSON.fromJson(recipeString, ShapedRecipeJson.class);
        if (json.result.count == 0) {
            json.result.count = 1;
        }
        MIRecipeJson assemblerJson = json.exportToAssembler();
        String outputSuffix = recipeId.method_12832().substring("recipes/".length(), recipeId.method_12832().length() - "_asbl.json".length());
        assemblerJson.offerTo(consumer, "assembler_generated/" + outputSuffix);
    }
}

