/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.rei.machines;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.rei.Rectangle;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.compat.rei.machines.MachineRecipeCategory;
import aztech.modern_industrialization.compat.rei.machines.MachineRecipeDisplay;
import aztech.modern_industrialization.compat.rei.machines.MultiblockRecipeCategory;
import aztech.modern_industrialization.compat.rei.machines.MultiblockRecipeDisplay;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.compat.rei.machines.SlotLockingHandler;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.RecipeConversions;
import dev.architectury.event.CompoundEventResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1735;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_3975;

public class MachinesPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        for (Map.Entry<String, MachineCategoryParams> entry : ReiMachineRecipes.categories.entrySet()) {
            MIIdentifier id = new MIIdentifier(entry.getKey());
            MachineRecipeCategory category = new MachineRecipeCategory(id, entry.getValue());
            registry.add((DisplayCategory)category);
            for (String workstation : entry.getValue().workstations) {
                registry.addWorkstations(category.getCategoryIdentifier(), new EntryStack[]{EntryStacks.of((class_1935)((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier(workstation))))});
            }
        }
        MultiblockRecipeCategory multiblockCategory = new MultiblockRecipeCategory();
        registry.add((DisplayCategory)multiblockCategory);
        registry.removePlusButton(multiblockCategory.getCategoryIdentifier());
    }

    public void registerDisplays(DisplayRegistry registry) {
        for (Map.Entry<String, MachineCategoryParams> entry : ReiMachineRecipes.categories.entrySet()) {
            MIIdentifier id = new MIIdentifier(entry.getKey());
            registry.registerFiller(recipe -> {
                if (recipe instanceof MachineRecipe) {
                    return ((MachineCategoryParams)entry.getValue()).recipePredicate.test((MachineRecipe)recipe);
                }
                return false;
            }, recipe -> new MachineRecipeDisplay(id, (MachineRecipe)recipe));
        }
        MIIdentifier furnaceId = new MIIdentifier("bronze_furnace");
        registry.registerFiller(recipe -> recipe.method_17716() == class_3956.field_17546, recipe -> new MachineRecipeDisplay(furnaceId, RecipeConversions.of((class_3861)recipe, MIMachineRecipeTypes.FURNACE)));
        MIIdentifier cuttingMachineId = new MIIdentifier("bronze_cutting_machine");
        registry.registerFiller(recipe -> recipe.method_17716() == class_3956.field_17641, recipe -> new MachineRecipeDisplay(cuttingMachineId, RecipeConversions.of((class_3975)recipe, MIMachineRecipeTypes.CUTTING_MACHINE)));
        for (class_3545<String, ShapeTemplate> entry : ReiMachineRecipes.multiblockShapes) {
            registry.add((Display)new MultiblockRecipeDisplay((String)entry.method_15442(), (ShapeTemplate)entry.method_15441()));
        }
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register((TransferHandler)new SlotLockingHandler());
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(MachineScreenHandlers.ClientScreen.class, context -> {
            MachineScreenHandlers.Client screenHandler = (MachineScreenHandlers.Client)((MachineScreenHandlers.ClientScreen)context.getScreen()).method_17577();
            String blockId = screenHandler.guiParams.blockId;
            List categories = ReiMachineRecipes.machineToClickAreaCategory.getOrDefault(blockId, Collections.emptyList());
            Rectangle rectangle = ReiMachineRecipes.machineToClickArea.get(blockId);
            Point point = context.getMousePosition().clone();
            point.translate(-((MachineScreenHandlers.ClientScreen)context.getScreen()).x(), -((MachineScreenHandlers.ClientScreen)context.getScreen()).y());
            if (categories.size() > 0 && rectangle != null && MachinesPlugin.contains(rectangle, point)) {
                ClickArea.Result result = ClickArea.Result.success();
                boolean foundSome = false;
                for (ReiMachineRecipes.ClickAreaCategory cac : categories) {
                    List displays;
                    if (!cac.predicate.test((MachineScreenHandlers.ClientScreen)context.getScreen()) || (displays = DisplayRegistry.getInstance().get(CategoryIdentifier.of((class_2960)cac.category))).size() <= 0) continue;
                    result.category(CategoryIdentifier.of((class_2960)cac.category));
                    foundSome = true;
                }
                return foundSome ? result : ClickArea.Result.fail();
            }
            return ClickArea.Result.fail();
        });
        registry.registerFocusedStack((screen, mouse) -> {
            if (screen instanceof MachineScreenHandlers.ClientScreen) {
                ConfigurableItemStack stack;
                class_1735 slot = ((MachineScreenHandlers.ClientScreen)screen).getFocusedSlot();
                if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
                    class_3611 fluid;
                    ConfigurableFluidStack stack2 = ((ConfigurableFluidStack.ConfigurableFluidSlot)slot).getConfStack();
                    if (stack2.getAmount() > 0L) {
                        class_3611 fluid2 = ((FluidVariant)stack2.getResource()).getFluid();
                        if (fluid2 != null) {
                            return CompoundEventResult.interruptTrue((Object)EntryStacks.of((class_3611)fluid2));
                        }
                    } else if (stack2.getLockedInstance() != null && (fluid = (class_3611)stack2.getLockedInstance()) != null) {
                        return CompoundEventResult.interruptTrue((Object)EntryStacks.of((class_3611)fluid));
                    }
                } else if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot && (stack = ((ConfigurableItemStack.ConfigurableItemSlot)slot).getConfStack()).getLockedInstance() != null) {
                    return CompoundEventResult.interruptTrue((Object)EntryStacks.of((class_1935)((class_1935)stack.getLockedInstance())));
                }
            }
            return CompoundEventResult.pass();
        });
    }

    private static boolean contains(Rectangle rectangle, Point mousePosition) {
        return rectangle.x <= mousePosition.x && mousePosition.x <= rectangle.x + rectangle.w && rectangle.y <= mousePosition.y && mousePosition.y <= rectangle.y + rectangle.h;
    }
}

