/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.tank;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.blocks.creativetank.CreativeTankItem;
import aztech.modern_industrialization.blocks.storage.tank.TankItem;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class TankModel
implements class_1100,
FabricBakedModel,
class_1087 {
    private static final class_2960 BASE_BLOCK_MODEL = new class_2960("minecraft:block/block");
    class_809 transformation;
    private final class_4730 tankSpriteId;
    private class_1058 tankSprite;
    private RenderMaterial translucentMaterial;
    private Mesh tankMesh;

    public TankModel(String tankType) {
        this.tankSpriteId = new class_4730(class_1059.field_5275, (class_2960)new MIIdentifier("blocks/tanks/" + tankType));
    }

    public TankModel(class_809 transformation, class_4730 tankSpriteId, class_1058 tankSprite, RenderMaterial translucentMaterial, Mesh tankMesh) {
        this.transformation = transformation;
        this.tankSpriteId = tankSpriteId;
        this.tankSprite = tankSprite;
        this.translucentMaterial = translucentMaterial;
        this.tankMesh = tankMesh;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
        context.meshConsumer().accept(this.tankMesh);
    }

    public void emitItemQuads(class_1799 stack, Supplier<Random> randomSupplier, RenderContext context) {
        context.meshConsumer().accept(this.tankMesh);
        class_1792 it = stack.method_7909();
        if (it instanceof TankItem) {
            TankItem item = (TankItem)it;
            if (!item.isEmpty(stack)) {
                float fillFraction = (float)item.getAmount(stack) / (float)item.capacity;
                this.drawFluid(context.getEmitter(), fillFraction, item.getFluid(stack));
            }
        } else if (it instanceof CreativeTankItem && !CreativeTankItem.isEmpty(stack)) {
            this.drawFluid(context.getEmitter(), 1.0f, CreativeTankItem.getFluid(stack));
        }
    }

    private void drawFluid(QuadEmitter emitter, float fillFraction, FluidVariant fluid) {
        class_1058 stillSprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        int color = FluidVariantRendering.getColor((FluidVariant)fluid) | 0xFF000000;
        for (class_2350 direction : class_2350.values()) {
            float topSpace;
            float depth;
            float bottomSpace;
            if (FluidVariantRendering.fillsFromTop((FluidVariant)fluid)) {
                bottomSpace = direction.method_10166().method_10179() ? 1.0f - fillFraction + 0.01f : 0.0f;
                depth = direction == class_2350.field_11033 ? fillFraction : 0.0f;
                topSpace = 0.0f;
            } else {
                bottomSpace = 0.0f;
                topSpace = direction.method_10166().method_10179() ? 1.0f - fillFraction + 0.01f : 0.0f;
                depth = direction == class_2350.field_11036 ? 1.0f - fillFraction : 0.0f;
            }
            emitter.material(this.translucentMaterial);
            emitter.square(direction, 0.0f, bottomSpace, 1.0f, 1.0f - topSpace, depth + 0.01f);
            emitter.spriteBake(0, stillSprite, 4);
            emitter.spriteColor(0, color, color, color, color);
            emitter.emit();
        }
    }

    public List<class_777> method_4707(class_2680 state, class_2350 face, Random random) {
        return Collections.emptyList();
    }

    public boolean method_4708() {
        return false;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.tankSprite;
    }

    public class_809 method_4709() {
        return this.transformation;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public Collection<class_2960> method_4755() {
        return Arrays.asList(BASE_BLOCK_MODEL);
    }

    public Collection<class_4730> method_4754(Function<class_2960, class_1100> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        return Arrays.asList(this.tankSpriteId);
    }

    public class_1087 method_4753(class_1088 loader, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
        this.transformation = ((class_793)loader.method_4726(BASE_BLOCK_MODEL)).method_3443();
        this.tankSprite = textureGetter.apply(this.tankSpriteId);
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        RenderMaterial cutoutMaterial = renderer.materialFinder().blendMode(0, BlendMode.CUTOUT_MIPPED).find();
        this.translucentMaterial = renderer.materialFinder().blendMode(0, BlendMode.TRANSLUCENT).emissive(0, true).find();
        MeshBuilder builder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        for (class_2350 direction : class_2350.values()) {
            emitter.material(cutoutMaterial);
            emitter.square(direction, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            emitter.cullFace(direction);
            emitter.spriteBake(0, this.tankSprite, 4);
            emitter.spriteColor(0, -1, -1, -1, -1);
            emitter.emit();
        }
        this.tankMesh = builder.build();
        return this;
    }

    public Mesh getTankMesh() {
        return this.tankMesh;
    }
}

