/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.tank;

import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantItemStorage;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class TankItem
extends class_1747 {
    public final long capacity;

    public TankItem(class_2248 block, class_1792.class_1793 settings, long capacity) {
        super(block, settings);
        this.capacity = capacity;
    }

    public void registerItemApi() {
        FluidStorage.ITEM.registerForItems((x$0, x$1) -> new TankItemStorage(x$0, (ContainerItemContext)x$1), new class_1935[]{this});
    }

    public boolean isEmpty(class_1799 stack) {
        return stack.method_7941("BlockEntityTag") == null;
    }

    public FluidVariant getFluid(class_1799 stack) {
        return NbtHelper.getFluidCompatible(stack.method_7941("BlockEntityTag"), "fluid");
    }

    private void setFluid(class_1799 stack, FluidVariant fluid) {
        NbtHelper.putFluid(stack.method_7911("BlockEntityTag"), "fluid", fluid);
    }

    public long getAmount(class_1799 stack) {
        if (this.getFluid(stack).isBlank()) {
            return 0L;
        }
        class_2487 tag = stack.method_7941("BlockEntityTag");
        if (tag == null) {
            return 0L;
        }
        return tag.method_10537("amt");
    }

    private void setAmount(class_1799 stack, long amount) {
        stack.method_7911("BlockEntityTag").method_10544("amt", amount);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (this.isEmpty(stack)) {
            tooltip.addAll(FluidHelper.getTooltipForFluidStorage(FluidVariant.blank(), 0L, this.capacity));
        } else {
            tooltip.addAll(FluidHelper.getTooltipForFluidStorage(this.getFluid(stack), this.getAmount(stack), this.capacity));
        }
    }

    class TankItemStorage
    extends SingleVariantItemStorage<FluidVariant> {
        public TankItemStorage(class_1799 stack, ContainerItemContext context) {
            super(context);
        }

        protected FluidVariant getBlankResource() {
            return FluidVariant.blank();
        }

        protected FluidVariant getResource(ItemVariant currentVariant) {
            return TankItem.this.getFluid(currentVariant.toStack());
        }

        protected long getAmount(ItemVariant currentVariant) {
            return TankItem.this.getAmount(currentVariant.toStack());
        }

        protected long getCapacity(FluidVariant variant) {
            return TankItem.this.capacity;
        }

        protected ItemVariant getUpdatedVariant(ItemVariant currentVariant, FluidVariant newResource, long newAmount) {
            class_1799 stack = new class_1799((class_1935)currentVariant.getItem());
            if (!newResource.isBlank() && newAmount > 0L) {
                TankItem.this.setFluid(stack, newResource);
                TankItem.this.setAmount(stack, newAmount);
            }
            return ItemVariant.of((class_1799)stack);
        }
    }
}

