/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.creativetank;

import aztech.modern_industrialization.MIBlockEntityTypes;
import aztech.modern_industrialization.api.FastBlockEntity;
import aztech.modern_industrialization.api.WrenchableBlockEntity;
import aztech.modern_industrialization.blocks.creativetank.CreativeTankBlock;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleViewIterator;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class CreativeTankBlockEntity
extends FastBlockEntity
implements ExtractionOnlyStorage<FluidVariant>,
StorageView<FluidVariant>,
WrenchableBlockEntity {
    FluidVariant fluid = FluidVariant.blank();

    public CreativeTankBlockEntity(class_2338 pos, class_2680 state) {
        super(MIBlockEntityTypes.CREATIVE_TANK, pos, state);
    }

    public boolean isResourceBlank() {
        return this.fluid.isBlank();
    }

    public void onChanged() {
        this.method_5431();
        if (!this.field_11863.field_9236) {
            this.sync();
        }
    }

    public void method_11007(class_2487 tag) {
        NbtHelper.putFluid(tag, "fluid", this.fluid);
    }

    public void method_11014(class_2487 tag) {
        this.fluid = NbtHelper.getFluidCompatible(tag, "fluid");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public boolean onPlayerUse(class_1657 player) {
        Storage handIo = (Storage)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)class_1268.field_5808).find(FluidStorage.ITEM);
        if (handIo != null) {
            if (this.isResourceBlank()) {
                try (Transaction transaction = Transaction.openOuter();){
                    for (StorageView view : handIo.iterable((TransactionContext)transaction)) {
                        if (view.isResourceBlank()) continue;
                        this.fluid = (FluidVariant)view.getResource();
                        this.onChanged();
                        break;
                    }
                }
                return !this.isResourceBlank();
            }
            try (Transaction tx = Transaction.openOuter();){
                long inserted = handIo.insert((Object)this.fluid, Long.MAX_VALUE, (TransactionContext)tx);
                tx.commit();
                boolean bl = inserted > 0L;
                return bl;
            }
        }
        return false;
    }

    public long extract(FluidVariant fluid, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)fluid, (long)maxAmount);
        return maxAmount;
    }

    public FluidVariant getResource() {
        return this.fluid;
    }

    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    public Iterator<StorageView<FluidVariant>> iterator(TransactionContext transaction) {
        return SingleViewIterator.create((StorageView)this, (TransactionContext)transaction);
    }

    public long getAmount() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean useWrench(class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_5715()) {
            CreativeTankBlock tank = (CreativeTankBlock)this.method_11010().method_26204();
            this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, hit.method_17784().field_1352, hit.method_17784().field_1351, hit.method_17784().field_1350, tank.getStack(this.field_11863.method_8321(this.field_11867))));
            this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
            return true;
        }
        return false;
    }
}

