/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.api;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class FluidFuelRegistry {
    private static final Map<class_3611, Integer> fluidEus = new HashMap<class_3611, Integer>();

    public static void register(class_3611 fluid, int eu) {
        if (eu <= 0) {
            throw new RuntimeException("Fluids must have a positive eu amount!");
        }
        if (fluid == null || fluid == class_3612.field_15906) {
            throw new RuntimeException("May not register a null or empty fluid!");
        }
        if (fluidEus.containsKey(fluid)) {
            throw new RuntimeException("May not re-register a fluid fuel!");
        }
        fluidEus.put(fluid, eu);
    }

    public static int getEu(class_3611 fluid) {
        return fluidEus.getOrDefault(fluid, 0);
    }

    public static List<class_3611> getRegisteredFluids() {
        ArrayList<class_3611> fluids = new ArrayList<class_3611>(fluidEus.keySet());
        fluids.sort(Comparator.comparing(fluidEus::get));
        return fluids;
    }
}

