/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.storage;

import com.glisco.deathlog.client.DeathInfo;
import com.glisco.deathlog.storage.DeathLogStorage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseDeathLogStorage
implements DeathLogStorage {
    private static final int FORMAT_REVISION = 2;
    public static final Logger LOGGER = LogManager.getLogger();
    private boolean errored = false;
    private String errorCondition = "";

    protected void load(File file, List<DeathInfo> into) {
        class_2487 deathNbt;
        block6: {
            if (this.errored) {
                LOGGER.warn("Attempted to load DeathLog database even though disk operations are disabled");
                return;
            }
            if (file.exists()) {
                try {
                    deathNbt = class_2507.method_10633((File)file);
                    if (deathNbt.method_10550("FormatRevision") != 2) {
                        this.raiseError("Incompatible format");
                        LOGGER.error("Incompatible DeathLog database format detected. Database not loaded and further disk operations disabled");
                        return;
                    }
                    break block6;
                }
                catch (IOException e) {
                    this.raiseError("Disk access failed");
                    e.printStackTrace();
                    LOGGER.error("Failed to load DeathLog database, further disk operations have been disabled");
                    return;
                }
            }
            deathNbt = new class_2487();
        }
        into.clear();
        class_2499 infoList = deathNbt.method_10554("Deaths", 9);
        for (int i = 0; i < infoList.size(); ++i) {
            into.add(DeathInfo.readFromNbt(infoList.method_10603(i)));
        }
    }

    protected void save(File file, List<DeathInfo> list) {
        if (this.errored) {
            LOGGER.warn("Attempted to save DeathLog database even though disk operations are disabled");
            return;
        }
        class_2487 deathNbt = new class_2487();
        class_2499 infoList = new class_2499();
        list.forEach(deathInfo -> infoList.add((Object)deathInfo.writeNbt()));
        deathNbt.method_10566("Deaths", (class_2520)infoList);
        deathNbt.method_10569("FormatRevision", 2);
        try {
            class_2507.method_10630((class_2487)deathNbt, (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("Failed to save DeathLog database");
        }
    }

    @Override
    public boolean isErrored() {
        return this.errored;
    }

    @Override
    public String getErrorCondition() {
        return this.errorCondition;
    }

    protected void raiseError(String error) {
        this.errored = true;
        this.errorCondition = error;
    }
}

