/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.death_info.properties;

import com.glisco.deathlog.death_info.DeathInfoPropertyType;
import com.glisco.deathlog.death_info.RestorableDeathInfoProperty;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class InventoryProperty
implements RestorableDeathInfoProperty {
    private final class_2371<class_1799> playerItems;
    private final class_2371<class_1799> playerArmor;

    public InventoryProperty(class_2371<class_1799> playerItems, class_2371<class_1799> playerArmor) {
        this.playerItems = playerItems;
        this.playerArmor = playerArmor;
    }

    public InventoryProperty(class_1661 playerInventory) {
        this.playerItems = class_2371.method_10213((int)37, (Object)class_1799.field_8037);
        this.playerArmor = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        InventoryProperty.copy((class_2371<class_1799>)playerInventory.field_7548, this.playerArmor);
        InventoryProperty.copy((class_2371<class_1799>)playerInventory.field_7547, this.playerItems);
        this.playerItems.set(36, (Object)((class_1799)playerInventory.field_7544.get(0)).method_7972());
    }

    @Override
    public DeathInfoPropertyType<?> getType() {
        return Type.INSTANCE;
    }

    @Override
    public class_2561 formatted() {
        return null;
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        class_2499 armorNbt = new class_2499();
        this.playerArmor.forEach(stack -> armorNbt.add((Object)stack.method_7953(new class_2487())));
        nbt.method_10566("Armor", (class_2520)armorNbt);
        class_2499 inventoryNbt = new class_2499();
        this.playerItems.forEach(stack -> inventoryNbt.add((Object)stack.method_7953(new class_2487())));
        nbt.method_10566("Items", (class_2520)inventoryNbt);
    }

    @Override
    public String toSearchableString() {
        StringBuilder builder = new StringBuilder();
        this.playerItems.forEach(stack -> builder.append(stack.method_7964().getString()));
        this.playerArmor.forEach(stack -> builder.append(stack.method_7964().getString()));
        return builder.toString();
    }

    @Override
    public void restore(class_3222 player) {
        class_1661 inventory = player.method_31548();
        inventory.method_5448();
        InventoryProperty.copy(this.playerArmor, (class_2371<class_1799>)inventory.field_7548);
        InventoryProperty.copy(this.playerItems, (class_2371<class_1799>)inventory.field_7547, 36);
        inventory.field_7544.set(0, (Object)((class_1799)this.playerItems.get(36)));
    }

    public class_2371<class_1799> getPlayerArmor() {
        return this.playerArmor;
    }

    public class_2371<class_1799> getPlayerItems() {
        return this.playerItems;
    }

    private static void copy(class_2371<class_1799> list, class_2371<class_1799> other) {
        InventoryProperty.copy(list, other, list.size());
    }

    private static void copy(class_2371<class_1799> list, class_2371<class_1799> other, int maxItems) {
        for (int i = 0; i < maxItems; ++i) {
            other.set(i, (Object)((class_1799)list.get(i)).method_7972());
        }
    }

    public static class Type
    extends DeathInfoPropertyType<InventoryProperty> {
        public static final Type INSTANCE = new Type();

        private Type() {
            super("deathlog.deathinfoproperty.inventory", "inventory");
        }

        @Override
        public boolean displayedInInfoView() {
            return false;
        }

        @Override
        public InventoryProperty readFromNbt(class_2487 nbt) {
            class_2499 armorNbt = nbt.method_10554("Armor", 10);
            class_2371 armorList = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
            for (int i = 0; i < armorNbt.size(); ++i) {
                armorList.set(i, (Object)class_1799.method_7915((class_2487)armorNbt.method_10602(i)));
            }
            class_2499 itemNbt = nbt.method_10554("Items", 10);
            class_2371 itemList = class_2371.method_10213((int)37, (Object)class_1799.field_8037);
            for (int i = 0; i < itemNbt.size(); ++i) {
                itemList.set(i, (Object)class_1799.method_7915((class_2487)itemNbt.method_10602(i)));
            }
            return new InventoryProperty((class_2371<class_1799>)itemList, (class_2371<class_1799>)armorList);
        }
    }
}

