/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.client.gui;

import com.glisco.deathlog.client.ClientDeathLogStorage;
import com.glisco.deathlog.client.Config;
import com.glisco.deathlog.client.DeathInfo;
import com.glisco.deathlog.client.gui.DeathListEntry;
import com.glisco.deathlog.client.gui.DeathListWidget;
import com.glisco.deathlog.storage.SingletonDeathLogStorage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class DeathLogScreen
extends class_437 {
    private static final class_2960 INVENTORY_TEXTURE = new class_2960("deathlog", "textures/gui/inventory_overlay.png");
    private final class_437 previousScreen;
    private final SingletonDeathLogStorage storage;
    private DeathListWidget deathList;
    private class_1799 hoveredStack = null;

    public DeathLogScreen(class_437 previousScreen, SingletonDeathLogStorage storage) {
        super(class_2561.method_30163((String)"Death Log"));
        this.previousScreen = previousScreen;
        this.storage = storage;
    }

    public void disableRestore() {
        this.deathList.restoreEnabled = false;
    }

    public void updateInfo(DeathInfo info, int index) {
        this.storage.getDeathInfoList().set(index, info);
        this.deathList.refilter();
    }

    protected void method_25426() {
        this.deathList = new DeathListWidget(this.field_22787, 220, this.field_22790, 32, this.field_22790 - 100, 40, this.storage);
        this.deathList.method_25333(10);
        this.method_37063((class_364)this.deathList);
        this.method_37063((class_364)new class_4185(60, this.field_22790 - 32, 100, 20, class_2561.method_30163((String)"Done"), button -> this.method_25419()));
        class_342 searchField = new class_342(this.field_22793, 10, this.field_22790 - 95, 220, 20, class_2561.method_30163((String)""));
        searchField.method_1863(s -> searchField.method_1868(this.deathList.filter((String)s) ? 0xFFFFFF : 0xFF2222));
        this.method_37063((class_364)searchField);
        searchField.method_1852(this.storage.getDefaultFilter());
        if (this.storage instanceof ClientDeathLogStorage) {
            this.method_37063((class_364)new class_4185(130, 5, 100, 20, DeathLogScreen.createScreenshotButtonText(), button -> {
                Config.instance().screenshotsEnabled = !Config.instance().screenshotsEnabled;
                Config.save();
                button.method_25355(DeathLogScreen.createScreenshotButtonText());
            }));
        }
    }

    private static class_2561 createScreenshotButtonText() {
        return class_2561.method_30163((String)("Screenshot: " + (Config.instance().screenshotsEnabled ? "\u00a7aON" : "\u00a7cOFF")));
    }

    public void method_25419() {
        this.field_22787.method_1507(this.previousScreen);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25434(0);
        int originX = 260;
        int originY = Math.min(this.field_22790 - 40, 300);
        DeathListEntry selectedEntry = (DeathListEntry)this.deathList.method_25334();
        if (selectedEntry != null && !selectedEntry.getInfo().isPartial()) {
            int slotY;
            int slotX;
            class_1799 stack;
            int i;
            DeathInfo info = selectedEntry.getInfo();
            this.field_22793.method_30883(matrices, info.getTitle(), 260.0f, 16.0f, 0xFFFFFF);
            List<class_2561> leftColumnText = info.getLeftColumnText();
            for (int i2 = 0; i2 < leftColumnText.size(); ++i2) {
                this.field_22793.method_30883(matrices, leftColumnText.get(i2), 260.0f, (float)(60 + 14 * i2), 0xFFFFFF);
            }
            List<class_2561> rightColumnText = info.getRightColumnText();
            for (i = 0; i < rightColumnText.size(); ++i) {
                this.field_22793.method_30883(matrices, rightColumnText.get(i), 360.0f, (float)(60 + 14 * i), 0xFFFFFF);
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)INVENTORY_TEXTURE);
            this.method_25302(matrices, 252, originY - 83, 0, 0, 210, 107);
            this.hoveredStack = null;
            for (i = 0; i < info.getPlayerItems().size() - 1; ++i) {
                stack = (class_1799)info.getPlayerItems().get(i);
                if (stack.method_7960()) continue;
                slotX = 260 + 18 * (i % 9);
                slotY = originY + (i < 9 ? 0 : -58 + 18 * (i / 9 - 1));
                this.renderSlotWithPossibleTooltip(matrices, stack, slotX, slotY, mouseX, mouseY);
            }
            if (!((class_1799)info.getPlayerItems().get(36)).method_7960()) {
                this.renderSlotWithPossibleTooltip(matrices, (class_1799)info.getPlayerItems().get(36), 438, originY - 75, mouseX, mouseY);
            }
            for (i = 0; i < info.getPlayerArmor().size(); ++i) {
                stack = (class_1799)info.getPlayerArmor().get(i);
                if (stack.method_7960()) continue;
                slotX = 438;
                slotY = originY - 18 * i;
                this.renderSlotWithPossibleTooltip(matrices, stack, 438, slotY, mouseX, mouseY);
            }
            if (this.hoveredStack != null) {
                List tooltip = this.method_25408(this.hoveredStack);
                tooltip.add(class_2561.method_30163((String)""));
                tooltip.add(class_2561.method_30163((String)("\u00a77Press Mouse 3 to " + (this.field_22787.field_1724.method_7337() ? "spawn" : "copy /give"))));
                this.method_30901(matrices, tooltip, mouseX, mouseY);
            }
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.field_22793.method_30883(matrices, this.field_22785, 16.0f, 12.0f, 0xFFFFFF);
        this.field_22793.method_1729(matrices, "Total Deaths: " + this.storage.getDeathInfoList().size(), 15.0f, (float)(this.field_22790 - 60), 0xFFFFFF);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.hoveredStack != null && button == 2) {
            if (this.field_22787.field_1724.method_7337()) {
                this.field_22787.field_1761.method_2915(this.hoveredStack);
            } else {
                StringBuilder command = new StringBuilder("/give ");
                command.append(this.field_22787.field_1724.method_5477().method_10851());
                command.append(" ");
                command.append(class_2378.field_11142.method_10221((Object)this.hoveredStack.method_7909()));
                command.append(this.hoveredStack.method_7948().toString());
                this.field_22787.field_1774.method_1455(command.toString());
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void renderSlotWithPossibleTooltip(class_4587 matrices, class_1799 stack, int x, int y, int mouseX, int mouseY) {
        if (mouseX > x && mouseX < x + 16 && mouseY > y && mouseY < y + 16) {
            DeathLogScreen.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-4473925);
            this.hoveredStack = stack.method_7972();
        }
        this.field_22788.method_4010(stack, x, y);
        this.field_22788.method_4025(this.field_22793, stack, x, y);
    }
}

