/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.client;

import com.glisco.deathlog.storage.BaseDeathLogStorage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static Config INSTANCE = new Config();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String configFileName = "deathlog.json";
    public boolean screenshotsEnabled = false;

    public static void save() {
        try (FileWriter writer = new FileWriter(FabricLoader.getInstance().getConfigDir().resolve(configFileName).toFile());){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            BaseDeathLogStorage.LOGGER.warn("Could not save config", (Throwable)e);
        }
    }

    public static void load() {
        try (FileReader reader = new FileReader(FabricLoader.getInstance().getConfigDir().resolve(configFileName).toFile());){
            INSTANCE = (Config)GSON.fromJson((Reader)reader, Config.class);
        }
        catch (IOException e) {
            BaseDeathLogStorage.LOGGER.warn("Could not load config", (Throwable)e);
        }
    }

    public static Config instance() {
        return INSTANCE;
    }
}

