/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.InventoryCraftingDecompress;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1732;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public class CompressMessage {
    private final int slotNumber;
    private final CompressType type;

    public CompressMessage(int slotNumber, CompressType type) {
        this.slotNumber = slotNumber;
        this.type = type;
    }

    public static CompressMessage decode(class_2540 buf) {
        int slotNumber = buf.readInt();
        CompressType type = CompressType.values()[buf.readByte()];
        return new CompressMessage(slotNumber, type);
    }

    public static void encode(CompressMessage message, class_2540 buf) {
        buf.writeInt(message.slotNumber);
        buf.writeByte(message.type.ordinal());
    }

    public static void handle(class_3222 player, CompressMessage message) {
        if (player == null) {
            return;
        }
        class_1703 menu = player.field_7512;
        if (menu == null) {
            return;
        }
        CompressType compressType = message.type;
        class_1735 mouseSlot = (class_1735)menu.field_7761.get(message.slotNumber);
        if (!(mouseSlot.field_7871 instanceof class_1661)) {
            return;
        }
        class_1799 mouseStack = mouseSlot.method_7677();
        if (mouseStack.method_7960()) {
            return;
        }
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        if (!CraftingTweaksConfig.getActive().common.compressAnywhere && grid == null) {
            return;
        }
        if (compressType == CompressType.DECOMPRESS_ALL || compressType == CompressType.DECOMPRESS_STACK || compressType == CompressType.DECOMPRESS_ONE) {
            boolean decompressAll = compressType != CompressType.DECOMPRESS_ONE;
            block0: for (class_1735 slot : menu.field_7761) {
                class_1799 result;
                if (compressType != CompressType.DECOMPRESS_ALL && slot != mouseSlot || !(slot.field_7871 instanceof class_1661) || !slot.method_7681() || !class_1799.method_7984((class_1799)slot.method_7677(), (class_1799)mouseSlot.method_7677()) || !class_1799.method_7975((class_1799)slot.method_7677(), (class_1799)mouseSlot.method_7677()) || (result = CompressMessage.findMatchingResult(new InventoryCraftingDecompress(menu, slot.method_7677()), player)).method_7960() || CompressMessage.isBlacklisted(result) || slot.method_7677().method_7960() || slot.method_7677().method_7947() < 1) continue;
                while (player.method_31548().method_7394(result.method_7972())) {
                    CompressMessage.giveLeftoverItems(player, slot.method_7677(), 1);
                    slot.method_7671(1);
                    if (decompressAll && slot.method_7681() && slot.method_7677().method_7947() >= 1) continue;
                    continue block0;
                }
            }
        } else {
            boolean compressAll = compressType != CompressType.COMPRESS_ONE;
            int size = grid != null ? grid.getGridSize((class_1657)player, menu) : 9;
            block2: for (class_1735 slot : menu.field_7761) {
                class_1799 result;
                if (compressType != CompressType.COMPRESS_ALL && slot != mouseSlot) continue;
                class_1799 slotStack = slot.method_7677();
                if (!(slot.field_7871 instanceof class_1661) || !slot.method_7681() || !class_1799.method_7984((class_1799)slotStack, (class_1799)mouseSlot.method_7677()) || !class_1799.method_7975((class_1799)slotStack, (class_1799)mouseSlot.method_7677())) continue;
                if (size == 9 && !slotStack.method_7960() && slotStack.method_7947() >= 9) {
                    result = CompressMessage.findMatchingResult(new InventoryCraftingCompress(menu, 3, slotStack), player);
                    if (!result.method_7960() && !CompressMessage.isBlacklisted(result)) {
                        while (player.method_31548().method_7394(result.method_7972())) {
                            CompressMessage.giveLeftoverItems(player, slotStack, 9);
                            slot.method_7671(9);
                            if (compressAll && slot.method_7681() && slotStack.method_7947() >= 9) continue;
                            continue block2;
                        }
                        continue;
                    }
                    result = CompressMessage.findMatchingResult(new InventoryCraftingCompress(menu, 2, slotStack), player);
                    if (result.method_7960() || CompressMessage.isBlacklisted(result)) continue;
                    while (player.method_31548().method_7394(result.method_7972())) {
                        CompressMessage.giveLeftoverItems(player, slotStack, 4);
                        slot.method_7671(4);
                        if (compressAll && slot.method_7681() && slotStack.method_7947() >= 4) continue;
                        continue block2;
                    }
                    continue;
                }
                if (size < 4 || slotStack.method_7960() || slotStack.method_7947() < 4 || (result = CompressMessage.findMatchingResult(new InventoryCraftingCompress(menu, 2, slotStack), player)).method_7960() || CompressMessage.isBlacklisted(result)) continue;
                while (player.method_31548().method_7394(result.method_7972())) {
                    CompressMessage.giveLeftoverItems(player, slotStack, 4);
                    slot.method_7671(4);
                    if (compressAll && slot.method_7681() && slotStack.method_7947() >= 4) continue;
                    continue block2;
                }
            }
        }
        menu.method_7623();
    }

    private static void giveLeftoverItems(class_3222 player, class_1799 slotStack, int count) {
        for (int i = 0; i < count; ++i) {
            class_1542 itemEntity;
            class_1799 containerItem = Balm.getHooks().getCraftingRemainingItem(slotStack);
            if (player.method_7270(containerItem) || (itemEntity = player.method_7328(containerItem, false)) == null) continue;
            itemEntity.method_6975();
            itemEntity.method_6984(player.method_5667());
        }
    }

    private static <T extends class_1715> class_1799 findMatchingResult(T craftingInventory, class_3222 player) {
        class_1863 recipeManager = Objects.requireNonNull(player.method_5682()).method_3772();
        class_3955 recipe = recipeManager.method_8132(class_3956.field_17545, craftingInventory, player.field_6002).orElse(null);
        if (recipe != null && ((class_1732)craftingInventory).method_7665(player.field_6002, player, (class_1860)recipe)) {
            return recipe.method_8116(craftingInventory);
        }
        return class_1799.field_8037;
    }

    private static boolean isBlacklisted(class_1799 result) {
        class_2960 registryName = class_2378.field_11142.method_10221((Object)result.method_7909());
        return CraftingTweaksConfig.getActive().common.compressBlacklist.contains(registryName.toString());
    }
}

