/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Objects;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1715;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_516;
import net.minecraft.class_636;
import net.minecraft.class_746;

public class ClientProvider {
    private final class_1277 lastCraftedMatrix = new class_1277(9);
    private boolean hasLastCraftedMatrix;

    private class_636 getController() {
        return class_310.method_1551().field_1761;
    }

    public void balanceGrid(class_1657 entityPlayer, class_1703 container, CraftingGrid grid) {
        ArrayListMultimap balanceSlots = ArrayListMultimap.create();
        int start = grid.getGridStartSlot(entityPlayer, container);
        int size = grid.getGridSize(entityPlayer, container);
        for (int i = start; i < start + size; ++i) {
            class_1799 itemStack;
            class_1735 slot = (class_1735)container.field_7761.get(i);
            if (!slot.method_7681() || (itemStack = slot.method_7677()).method_7960()) continue;
            class_2960 registryName = class_2378.field_11142.method_10221((Object)itemStack.method_7909());
            balanceSlots.put((Object)Objects.toString(registryName), (Object)slot);
        }
        for (String key : balanceSlots.keySet()) {
            class_1799 itemStack;
            Collection slotList = balanceSlots.get((Object)key);
            int average = 0;
            for (class_1735 slot : slotList) {
                itemStack = slot.method_7677();
                if (itemStack.method_7960()) continue;
                average += itemStack.method_7947();
            }
            average = (int)Math.floor((float)average / (float)slotList.size());
            for (class_1735 slot : slotList) {
                if (!slot.method_7681() || (itemStack = slot.method_7677()).method_7960() || itemStack.method_7947() <= average) continue;
                int mouseStackSize = itemStack.method_7947();
                this.getController().method_2906(container.field_7763, slot.field_7874, 0, class_1713.field_7790, entityPlayer);
                for (class_1735 otherSlot : slotList) {
                    int otherStackSize;
                    class_1799 otherStack;
                    if (slot == otherSlot || !otherSlot.method_7681() || (otherStack = otherSlot.method_7677()).method_7960() || (otherStackSize = otherStack.method_7947()) >= average) continue;
                    while (otherStackSize < average && mouseStackSize > average) {
                        this.getController().method_2906(container.field_7763, otherSlot.field_7874, 1, class_1713.field_7790, entityPlayer);
                        --mouseStackSize;
                        ++otherStackSize;
                    }
                }
                this.getController().method_2906(container.field_7763, slot.field_7874, 0, class_1713.field_7790, entityPlayer);
            }
        }
    }

    public void spreadGrid(class_1657 player, class_1703 menu, CraftingGrid grid) {
        int tries = 0;
        while (tries < 9) {
            int i;
            ++tries;
            class_1735 biggestSlot = null;
            int biggestSlotSize = 1;
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            for (i = start; i < start + size; ++i) {
                class_1735 slot = (class_1735)menu.field_7761.get(i);
                class_1799 itemStack = slot.method_7677();
                if (itemStack.method_7960() || itemStack.method_7947() <= biggestSlotSize) continue;
                biggestSlot = slot;
                biggestSlotSize = itemStack.method_7947();
            }
            if (biggestSlot == null) {
                return;
            }
            this.getController().method_2906(menu.field_7763, biggestSlot.field_7874, 0, class_1713.field_7790, player);
            for (i = start; i < start + size; ++i) {
                class_1799 itemStack;
                if (i == biggestSlot.field_7874 || !(itemStack = ((class_1735)menu.field_7761.get(i)).method_7677()).method_7960() || biggestSlotSize <= 1) continue;
                this.getController().method_2906(menu.field_7763, i, 1, class_1713.field_7790, player);
                if (--biggestSlotSize == 1) break;
            }
            this.getController().method_2906(menu.field_7763, biggestSlot.field_7874, 0, class_1713.field_7790, player);
        }
        this.balanceGrid(player, menu, grid);
    }

    public void clearGrid(class_1657 player, class_1703 menu, CraftingGrid grid, boolean forced) {
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            this.getController().method_2906(menu.field_7763, i, 0, class_1713.field_7794, player);
            menu.method_7601(player, i);
            if (!forced || !((class_1735)menu.field_7761.get(i)).method_7681()) continue;
            this.getController().method_2906(menu.field_7763, i, 0, class_1713.field_7795, player);
        }
    }

    public void rotateGrid(class_1657 player, class_1703 menu, CraftingGrid grid, boolean reverse) {
        if (grid.getGridSize(player, menu) != 9) {
            return;
        }
        if (!this.dropOffMouseStack(player, menu)) {
            return;
        }
        if (this.rotateGridWithBuffer(player, menu, grid, reverse)) {
            return;
        }
        int startSlot = grid.getGridStartSlot(player, menu);
        this.getController().method_2906(menu.field_7763, startSlot, 0, class_1713.field_7790, player);
        int currentSlot = startSlot;
        do {
            currentSlot = startSlot + this.rotateSlotId(currentSlot - startSlot, reverse);
            this.getController().method_2906(menu.field_7763, currentSlot, 0, class_1713.field_7790, player);
        } while (currentSlot != startSlot);
    }

    private boolean rotateGridWithBuffer(class_1657 player, class_1703 menu, CraftingGrid grid, boolean counterClockwise) {
        int startSlot;
        int emptyBuffer = 0;
        int[] bufferSlot = new int[2];
        for (class_1735 slot : menu.field_7761) {
            if (!(slot.field_7871 instanceof class_1661) || slot.method_7681()) continue;
            bufferSlot[emptyBuffer] = slot.field_7874;
            if (++emptyBuffer < 2) continue;
            break;
        }
        if (emptyBuffer < 2) {
            return false;
        }
        emptyBuffer = 0;
        int currentSlot = startSlot = grid.getGridStartSlot(player, menu);
        do {
            this.getController().method_2906(menu.field_7763, currentSlot, 0, class_1713.field_7790, player);
            this.getController().method_2906(menu.field_7763, bufferSlot[emptyBuffer], 0, class_1713.field_7790, player);
            emptyBuffer = (emptyBuffer + 1) % 2;
            this.getController().method_2906(menu.field_7763, bufferSlot[emptyBuffer], 0, class_1713.field_7790, player);
            this.getController().method_2906(menu.field_7763, currentSlot, 0, class_1713.field_7790, player);
        } while ((currentSlot = startSlot + this.rotateSlotId(currentSlot - startSlot, counterClockwise)) != startSlot);
        emptyBuffer = (emptyBuffer + 1) % 2;
        this.getController().method_2906(menu.field_7763, bufferSlot[emptyBuffer], 0, class_1713.field_7790, player);
        this.getController().method_2906(menu.field_7763, startSlot, 0, class_1713.field_7790, player);
        return true;
    }

    public boolean transferIntoGrid(class_1657 player, class_1703 menu, CraftingGrid grid, class_1735 sourceSlot) {
        if (!(sourceSlot.method_7681() && sourceSlot.method_7674(player) && grid.transferHandler().canTransferFrom(player, menu, sourceSlot, grid))) {
            return false;
        }
        if (!this.dropOffMouseStack(player, menu)) {
            return false;
        }
        this.getController().method_2906(menu.field_7763, sourceSlot.field_7874, 0, class_1713.field_7790, player);
        class_1799 mouseStack = menu.method_34255();
        if (mouseStack.method_7960()) {
            return false;
        }
        boolean itemMoved = false;
        int firstEmptySlot = -1;
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            class_1735 craftSlot = (class_1735)menu.field_7761.get(i);
            class_1799 craftStack = craftSlot.method_7677();
            if (!craftStack.method_7960()) {
                int spaceLeft;
                if (!craftStack.method_7962(mouseStack) || !class_1799.method_7975((class_1799)craftStack, (class_1799)mouseStack) || (spaceLeft = Math.min(craftSlot.method_7675(), craftStack.method_7914()) - craftStack.method_7947()) <= 0) continue;
                this.getController().method_2906(menu.field_7763, craftSlot.field_7874, 0, class_1713.field_7790, player);
                mouseStack = menu.method_34255();
                if (!mouseStack.method_7960()) continue;
                return true;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = i;
        }
        if (firstEmptySlot != -1) {
            this.getController().method_2906(menu.field_7763, firstEmptySlot, 0, class_1713.field_7790, player);
            itemMoved = true;
        }
        if (!menu.method_34255().method_7960()) {
            this.getController().method_2906(menu.field_7763, sourceSlot.field_7874, 0, class_1713.field_7790, player);
        }
        this.dropOffMouseStack(player, menu);
        return itemMoved;
    }

    private boolean dropOffMouseStack(class_1657 player, class_1703 menu) {
        return this.dropOffMouseStack(player, menu, -1);
    }

    private boolean dropOffMouseStack(class_1657 player, class_1703 menu, int ignoreSlot) {
        if (menu.method_34255().method_7960()) {
            return true;
        }
        for (int i = 0; i < menu.field_7761.size(); ++i) {
            if (i == ignoreSlot) continue;
            class_1735 slot = (class_1735)menu.field_7761.get(i);
            if (slot.field_7871 != player.method_31548()) continue;
            class_1799 mouseItem = menu.method_34255();
            class_1799 slotStack = slot.method_7677();
            if (slotStack.method_7960()) {
                this.getController().method_2906(menu.field_7763, i, 0, class_1713.field_7790, player);
            } else if (mouseItem.method_7909() == slotStack.method_7909() && class_1799.method_7975((class_1799)slotStack, (class_1799)mouseItem)) {
                this.getController().method_2906(menu.field_7763, i, 0, class_1713.field_7790, player);
            }
            if (!menu.method_34255().method_7960()) continue;
            return true;
        }
        return menu.method_34255().method_7960();
    }

    private void decompress(class_1657 player, class_1703 menu, CraftingGrid grid, class_1735 mouseSlot, CompressType compressType) {
        if (!mouseSlot.method_7681()) {
            return;
        }
        boolean decompressAll = compressType != CompressType.DECOMPRESS_ONE;
        this.clearGrid(player, menu, grid, false);
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            if (!((class_1735)menu.field_7761.get(i)).method_7681()) continue;
            return;
        }
        for (class_1735 slot : menu.field_7761) {
            if (compressType != CompressType.DECOMPRESS_ALL && slot != mouseSlot || !(slot.field_7871 instanceof class_1661) || !slot.method_7681() || !class_1799.method_7984((class_1799)slot.method_7677(), (class_1799)mouseSlot.method_7677()) || !class_1799.method_7975((class_1799)slot.method_7677(), (class_1799)mouseSlot.method_7677())) continue;
            this.getController().method_2906(menu.field_7763, mouseSlot.field_7874, 0, class_1713.field_7790, player);
            this.getController().method_2906(menu.field_7763, start, 0, class_1713.field_7790, player);
            for (class_1735 resultSlot : menu.field_7761) {
                if (!(resultSlot instanceof class_1734) || !resultSlot.method_7681()) continue;
                this.getController().method_2906(menu.field_7763, resultSlot.field_7874, 0, decompressAll ? class_1713.field_7794 : class_1713.field_7790, player);
                break;
            }
            this.dropOffMouseStack(player, menu, mouseSlot.field_7874);
            this.getController().method_2906(menu.field_7763, start, 0, class_1713.field_7790, player);
            this.getController().method_2906(menu.field_7763, mouseSlot.field_7874, 0, class_1713.field_7790, player);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compress(class_746 player, class_1703 menu, CraftingGrid grid, class_1735 mouseSlot, CompressType compressType) {
        if (compressType == CompressType.DECOMPRESS_ALL || compressType == CompressType.DECOMPRESS_ONE || compressType == CompressType.DECOMPRESS_STACK) {
            this.decompress((class_1657)player, menu, grid, mouseSlot, compressType);
            return;
        }
        if (!mouseSlot.method_7681()) {
            return;
        }
        boolean compressAll = compressType != CompressType.COMPRESS_ONE;
        this.clearGrid((class_1657)player, menu, grid, false);
        int start = grid.getGridStartSlot((class_1657)player, menu);
        int size = grid.getGridSize((class_1657)player, menu);
        for (int i = start; i < start + size; ++i) {
            if (!((class_1735)menu.field_7761.get(i)).method_7681()) continue;
            return;
        }
        for (class_1735 slot : menu.field_7761) {
            int i;
            if (compressType != CompressType.COMPRESS_ALL && slot != mouseSlot || !(slot.field_7871 instanceof class_1661) || !slot.method_7681() || !class_1799.method_7984((class_1799)slot.method_7677(), (class_1799)mouseSlot.method_7677()) || !class_1799.method_7975((class_1799)slot.method_7677(), (class_1799)mouseSlot.method_7677())) continue;
            class_1799 mouseStack = slot.method_7677();
            if (size == 9 && !mouseStack.method_7960() && mouseStack.method_7947() >= 9) {
                result = ClientProvider.findMatchingResult(new InventoryCraftingCompress(menu, 3, mouseStack), player);
                if (!result.method_7960() && !this.isCompressBlacklisted(result)) {
                    this.getController().method_2906(menu.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, -999, ClientProvider.getDragSplittingButton(0, 0), class_1713.field_7789, (class_1657)player);
                    for (i = start; i < start + size; ++i) {
                        this.getController().method_2906(menu.field_7763, i, ClientProvider.getDragSplittingButton(1, 0), class_1713.field_7789, (class_1657)player);
                    }
                    this.getController().method_2906(menu.field_7763, -999, ClientProvider.getDragSplittingButton(2, 0), class_1713.field_7789, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)player);
                } else {
                    result = ClientProvider.findMatchingResult(new InventoryCraftingCompress(menu, 2, mouseStack), player);
                    if (result.method_7960() || this.isCompressBlacklisted(result)) return;
                    this.getController().method_2906(menu.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, -999, ClientProvider.getDragSplittingButton(0, 0), class_1713.field_7789, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, start, ClientProvider.getDragSplittingButton(1, 0), class_1713.field_7789, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, start + 1, ClientProvider.getDragSplittingButton(1, 0), class_1713.field_7789, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, start + 3, ClientProvider.getDragSplittingButton(1, 0), class_1713.field_7789, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, start + 4, ClientProvider.getDragSplittingButton(1, 0), class_1713.field_7789, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, -999, ClientProvider.getDragSplittingButton(2, 0), class_1713.field_7789, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)player);
                }
            } else if (size >= 4 && !mouseStack.method_7960() && mouseStack.method_7947() >= 4) {
                result = ClientProvider.findMatchingResult(new InventoryCraftingCompress(menu, 2, mouseStack), player);
                if (result.method_7960() || this.isCompressBlacklisted(result)) return;
                this.getController().method_2906(menu.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)player);
                this.getController().method_2906(menu.field_7763, -999, ClientProvider.getDragSplittingButton(0, 0), class_1713.field_7789, (class_1657)player);
                if (size == 4) {
                    for (i = start; i < start + size; ++i) {
                        this.getController().method_2906(menu.field_7763, i, ClientProvider.getDragSplittingButton(1, 0), class_1713.field_7789, (class_1657)player);
                    }
                } else {
                    this.getController().method_2906(menu.field_7763, start, ClientProvider.getDragSplittingButton(1, 0), class_1713.field_7789, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, start + 1, ClientProvider.getDragSplittingButton(1, 0), class_1713.field_7789, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, start + 3, ClientProvider.getDragSplittingButton(1, 0), class_1713.field_7789, (class_1657)player);
                    this.getController().method_2906(menu.field_7763, start + 4, ClientProvider.getDragSplittingButton(1, 0), class_1713.field_7789, (class_1657)player);
                }
                this.getController().method_2906(menu.field_7763, -999, ClientProvider.getDragSplittingButton(2, 0), class_1713.field_7789, (class_1657)player);
                this.getController().method_2906(menu.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)player);
            }
            for (class_1735 resultSlot : menu.field_7761) {
                if (!(resultSlot instanceof class_1734) || !resultSlot.method_7681()) continue;
                this.getController().method_2906(menu.field_7763, resultSlot.field_7874, 0, compressAll ? class_1713.field_7794 : class_1713.field_7790, (class_1657)player);
                break;
            }
            this.dropOffMouseStack((class_1657)player, menu, slot.field_7874);
            for (i = start; i < start + size; ++i) {
                if (!((class_1735)menu.field_7761.get(i)).method_7681()) continue;
                this.getController().method_2906(menu.field_7763, i, 0, class_1713.field_7790, (class_1657)player);
                this.getController().method_2906(menu.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)player);
            }
            this.dropOffMouseStack((class_1657)player, menu);
        }
    }

    private static <T extends class_1715> class_1799 findMatchingResult(T craftingInventory, class_746 player) {
        for (class_516 recipeList : player.method_3130().method_1393()) {
            for (class_1860 recipe : recipeList.method_2650()) {
                class_1860 craftingRecipe;
                if (recipe.method_17716() != class_3956.field_17545 || !(craftingRecipe = recipe).method_8115(craftingInventory, player.field_6002)) continue;
                return craftingRecipe.method_8116(craftingInventory);
            }
        }
        return class_1799.field_8037;
    }

    private static int getDragSplittingButton(int id, int limit) {
        return id & 3 | (limit & 3) << 2;
    }

    private boolean isCompressBlacklisted(class_1799 result) {
        class_2960 registryName = class_2378.field_11142.method_10221((Object)result.method_7909());
        return registryName != null && CraftingTweaksConfig.getActive().common.compressBlacklist.contains(registryName.toString());
    }

    public void onItemCrafted(class_1263 craftMatrix) {
        if (craftMatrix.method_5439() <= 9) {
            for (int i = 0; i < this.lastCraftedMatrix.method_5439(); ++i) {
                if (i < craftMatrix.method_5439()) {
                    this.lastCraftedMatrix.method_5447(i, craftMatrix.method_5438(i).method_7972());
                    continue;
                }
                this.lastCraftedMatrix.method_5447(i, class_1799.field_8037);
            }
            this.hasLastCraftedMatrix = true;
        }
    }

    public void refillLastCrafted(class_1657 player, class_1703 menu, CraftingGrid grid, boolean fullStack) {
        class_1799 itemStack;
        int i;
        if (this.hasLastCraftedMatrix) {
            return;
        }
        this.dropOffMouseStack(player, menu);
        int gridStart = grid.getGridStartSlot(player, menu);
        int gridSize = grid.getGridSize(player, menu);
        block0: for (i = 0; i < this.lastCraftedMatrix.method_5439(); ++i) {
            itemStack = this.lastCraftedMatrix.method_5438(i);
            if (!itemStack.method_7960()) {
                for (class_1735 slot : menu.field_7761) {
                    if (!(slot.field_7871 instanceof class_1661) || !slot.method_7681() || !class_1799.method_7984((class_1799)slot.method_7677(), (class_1799)itemStack) || !class_1799.method_7975((class_1799)slot.method_7677(), (class_1799)itemStack)) continue;
                    this.getController().method_2906(menu.field_7763, slot.field_7874, 0, class_1713.field_7790, player);
                    this.getController().method_2906(menu.field_7763, gridStart + i, fullStack ? 0 : 1, class_1713.field_7790, player);
                    this.getController().method_2906(menu.field_7763, slot.field_7874, 0, class_1713.field_7790, player);
                    continue block0;
                }
                continue;
            }
            if (!((class_1735)menu.field_7761.get(gridStart + i)).method_7681()) continue;
            this.getController().method_2906(menu.field_7763, gridStart + i, 0, class_1713.field_7790, player);
            if (this.dropOffMouseStack(player, menu)) continue;
            this.getController().method_2906(menu.field_7763, gridStart + i, 0, class_1713.field_7790, player);
            return;
        }
        if (fullStack) {
            block2: for (i = 0; i < this.lastCraftedMatrix.method_5439(); ++i) {
                itemStack = this.lastCraftedMatrix.method_5438(i);
                if (itemStack.method_7960() || ((class_1735)menu.field_7761.get(gridStart + i)).method_7681()) continue;
                for (int j = gridStart; j < gridStart + gridSize; ++j) {
                    class_1799 gridStack;
                    if (j == gridStart + i || (gridStack = ((class_1735)menu.field_7761.get(j)).method_7677()).method_7947() <= 1 || !class_1799.method_7984((class_1799)gridStack, (class_1799)itemStack) || !class_1799.method_7975((class_1799)gridStack, (class_1799)itemStack)) continue;
                    this.getController().method_2906(menu.field_7763, j, 0, class_1713.field_7790, player);
                    this.getController().method_2906(menu.field_7763, gridStart + i, 1, class_1713.field_7790, player);
                    this.getController().method_2906(menu.field_7763, j, 0, class_1713.field_7790, player);
                    continue block2;
                }
            }
            this.balanceGrid(player, menu, grid);
        }
        this.dropOffMouseStack(player, menu);
    }

    public boolean rotateIgnoresSlotId(int slotId) {
        return slotId == 4;
    }

    public int rotateSlotId(int slotId, boolean counterClockwise) {
        if (!counterClockwise) {
            switch (slotId) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 5;
                }
                case 5: {
                    return 8;
                }
                case 8: {
                    return 7;
                }
                case 7: {
                    return 6;
                }
                case 6: {
                    return 3;
                }
                case 3: {
                    return 0;
                }
            }
        } else {
            switch (slotId) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 6;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 5;
                }
            }
        }
        return 0;
    }
}

