/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.builtinservers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import io.github.lucaargolo.builtinservers.ModConfig;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_641;
import net.minecraft.class_642;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BuiltinServers
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Builtin Servers");
    public static ModConfig CONFIG;
    private static final JsonParser parser;
    private static final Gson gson;

    public void onInitializeClient() {
        block10: {
            Path configPath = FabricLoader.getInstance().getConfigDir();
            File configFile = new File(configPath + File.separator + "builtinservers.json");
            LOGGER.info("Trying to read servers file...");
            try {
                if (configFile.createNewFile()) {
                    LOGGER.info("No servers file found, creating a new one...");
                    String json = gson.toJson(parser.parse(gson.toJson((Object)new ModConfig())));
                    try (PrintWriter out = new PrintWriter(configFile);){
                        out.println(json);
                    }
                    CONFIG = new ModConfig();
                    LOGGER.info("Successfully created default servers file.");
                    break block10;
                }
                LOGGER.info("A servers file was found, loading it..");
                CONFIG = (ModConfig)gson.fromJson(new String(Files.readAllBytes(configFile.toPath())), ModConfig.class);
                if (CONFIG == null) {
                    throw new NullPointerException("The servers file was empty.");
                }
                LOGGER.info("Successfully loaded servers file.");
            }
            catch (Exception exception) {
                LOGGER.error("There was an error creating/loading the servers file!", (Throwable)exception);
                CONFIG = new ModConfig();
                LOGGER.warn("Defaulting to original servers file.");
            }
        }
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            class_641 serverList = new class_641(client);
            if (serverList.method_2984() == 0) {
                CONFIG.getBuiltinServers().forEach(serverConfig -> {
                    class_642 builtinServer = new class_642(serverConfig.getName(), serverConfig.getAddress(), false);
                    serverList.method_2988(builtinServer);
                });
            }
            serverList.method_2987();
        });
    }

    static {
        parser = new JsonParser();
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

