/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.world;

import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.mixin.SimpleContainerAccess;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.Utils;

public class DankInventory
extends class_1277
implements class_3913 {
    public DankStats dankStats;
    protected int[] lockedSlots;
    protected int id;
    public boolean locked;
    protected int textColor = -1;

    public DankInventory(DankStats stats, int id) {
        super(stats.slots);
        this.dankStats = stats;
        this.lockedSlots = new int[stats.slots];
        this.id = id;
    }

    public void upgradeTo(DankStats stats) {
        if (stats.ordinal() <= this.dankStats.ordinal()) {
            return;
        }
        if (stats != this.dankStats) {
            DankStorage.LOGGER.debug("Upgrading dank #{} from tier {} to {}", (Object)this.id, (Object)this.dankStats.name(), (Object)stats.name());
        }
        this.setTo(stats);
    }

    public void setTo(DankStats stats) {
        this.dankStats = stats;
        this.fixLockedSlots();
    }

    private void fixLockedSlots() {
        ((SimpleContainerAccess)((Object)this)).setSize(this.dankStats.slots);
        class_2371 newStacks = class_2371.method_10213((int)this.dankStats.slots, (Object)class_1799.field_8037);
        int max = Math.min(this.lockedSlots.length, this.dankStats.slots);
        for (int i = 0; i < max; ++i) {
            newStacks.set(i, (Object)((class_1799)this.getContents().get(i)));
        }
        ((SimpleContainerAccess)((Object)this)).setItems((class_2371<class_1799>)newStacks);
        int[] newLockedSlots = new int[this.dankStats.slots];
        if (max >= 0) {
            System.arraycopy(this.lockedSlots, 0, newLockedSlots, 0, max);
        }
        this.lockedSlots = newLockedSlots;
        this.method_5431();
    }

    public class_1799 method_5434(int slot, int amount) {
        if (!this.isLocked(slot)) {
            return super.method_5434(slot, amount);
        }
        int amountInSlot = this.method_5438(slot).method_7947();
        if (amountInSlot < amount) {
            return super.method_5434(slot, amount);
        }
        if ((amount = Math.min(amount, amountInSlot - 1)) == 0) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = class_1262.method_5430(this.getContents(), (int)slot, (int)amount);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public int method_5444() {
        return this.dankStats.stacklimit;
    }

    public class_2371<class_1799> getContents() {
        return ((SimpleContainerAccess)((Object)this)).getItems();
    }

    public boolean noValidSlots() {
        return IntStream.range(0, this.method_5439()).mapToObj(arg_0 -> ((DankInventory)this).method_5438(arg_0)).allMatch(stack -> stack.method_7960() || stack.method_31573(Utils.BLACKLISTED_USAGE));
    }

    public boolean isLocked(int slot) {
        return this.method_17390(slot) == 1;
    }

    public void toggleLock(int slot) {
        boolean loc = this.method_17390(slot) == 1;
        this.method_17391(slot, loc ? 0 : 1);
        this.method_5431();
    }

    public boolean method_5437(int i, class_1799 itemStack) {
        return !itemStack.method_31573(Utils.BLACKLISTED_STORAGE);
    }

    public boolean method_27070(class_1799 stack) {
        return !stack.method_31573(Utils.BLACKLISTED_STORAGE) && super.method_27070(stack);
    }

    public class_1799 method_5491(class_1799 itemStack) {
        return itemStack.method_31573(Utils.BLACKLISTED_STORAGE) ? itemStack : super.method_5491(itemStack);
    }

    public class_2487 save() {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((class_1799)this.getContents().get(i)).method_7960()) continue;
            int realCount = Math.min(this.dankStats.stacklimit, ((class_1799)this.getContents().get(i)).method_7947());
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            ((class_1799)this.getContents().get(i)).method_7953(itemTag);
            itemTag.method_10569("ExtendedCount", realCount);
            nbtTagList.add((Object)itemTag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10539("LockedSlots", this.lockedSlots);
        nbt.method_10582("DankStats", this.dankStats.name());
        nbt.method_10569("dankstorage:id", this.id);
        nbt.method_10556("locked", this.locked);
        return nbt;
    }

    public void read(class_2487 nbt) {
        DankStats stats = DankStats.valueOf(nbt.method_10558("DankStats"));
        this.upgradeTo(stats);
        class_2499 tagList = nbt.method_10554("Items", 10);
        this.locked = nbt.method_10577("locked");
        for (int i = 0; i < tagList.size(); ++i) {
            class_1799 stack;
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= this.method_5439()) continue;
            if (itemTags.method_10573("StackList", 9)) {
                stack = class_1799.field_8037;
                class_2499 stackTagList = itemTags.method_10554("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    class_2487 itemTag = stackTagList.method_10602(j);
                    class_1799 temp = class_1799.method_7915((class_2487)itemTag);
                    if (temp.method_7960()) continue;
                    if (stack.method_7960()) {
                        stack = temp;
                        continue;
                    }
                    stack.method_7933(temp.method_7947());
                }
                if (stack.method_7960()) continue;
                int count = stack.method_7947();
                count = Math.min(count, this.method_5444());
                stack.method_7939(count);
                this.method_5447(slot, stack);
                continue;
            }
            stack = class_1799.method_7915((class_2487)itemTags);
            if (itemTags.method_10573("ExtendedCount", 3)) {
                stack.method_7939(itemTags.method_10550("ExtendedCount"));
            }
            this.method_5447(slot, stack);
        }
        int[] slots = nbt.method_10561("LockedSlots");
        this.setLockedSlots(slots);
        this.validate();
    }

    protected void setLockedSlots(int[] slots) {
        System.arraycopy(slots, 0, this.lockedSlots, 0, slots.length);
    }

    protected void validate() {
        if (this.dankStats == DankStats.zero) {
            throw new RuntimeException("dank has no stats?");
        }
        if (this.method_5439() == 0) {
            throw new RuntimeException("dank is empty?");
        }
        if (this.lockedSlots.length != this.method_5439()) {
            throw new RuntimeException("inequal size");
        }
    }

    public int calcRedstone() {
        int numStacks = 0;
        float f = 0.0f;
        for (int slot = 0; slot < this.method_5439(); ++slot) {
            class_1799 stack = this.method_5438(slot);
            if (stack.method_7960()) continue;
            f += (float)stack.method_7947() / (float)this.method_5444();
            ++numStacks;
        }
        return class_3532.method_15375((float)((f /= (float)this.method_5439()) * 14.0f)) + (numStacks > 0 ? 1 : 0);
    }

    public void method_5431() {
        super.method_5431();
        if (DankStorage.instance.data != null) {
            DankStorage.instance.data.method_80();
        }
    }

    public int getFrequencySlot() {
        return this.method_5439();
    }

    public int getTextColor() {
        return this.method_17390(this.getFrequencySlot() + 1);
    }

    public void setTextColor(int color) {
        this.method_17391(this.getFrequencySlot() + 1, color);
    }

    public boolean frequencyLocked() {
        return this.method_17390(this.getFrequencySlot() + 2) == 1;
    }

    public void toggleFrequencyLock() {
        boolean loc = this.method_17390(this.getFrequencySlot() + 2) == 1;
        this.setFrequencyLock(!loc);
    }

    public void setFrequencyLock(boolean lock) {
        this.method_17391(this.getFrequencySlot() + 2, lock ? 1 : 0);
    }

    public int method_17390(int slot) {
        if (slot < this.method_5439()) {
            return this.lockedSlots[slot];
        }
        if (slot == this.getFrequencySlot()) {
            return this.id;
        }
        if (slot == this.getFrequencySlot() + 1) {
            return this.textColor;
        }
        if (slot == this.getFrequencySlot() + 2) {
            return this.locked ? 1 : 0;
        }
        return -999;
    }

    public int getId() {
        return this.method_17390(this.getFrequencySlot());
    }

    public void method_17391(int slot, int value) {
        if (slot < this.method_5439()) {
            this.lockedSlots[slot] = value;
        } else if (slot == this.getFrequencySlot()) {
            this.id = value;
        } else if (slot == this.getFrequencySlot() + 1) {
            this.textColor = value;
        } else if (slot == this.getFrequencySlot() + 2) {
            this.locked = value == 1;
        }
        this.method_5431();
    }

    public int method_17389() {
        return this.method_5439() + 3;
    }

    public static enum TxtColor {
        INVALID(-65536),
        TOO_HIGH(Short.MIN_VALUE),
        DIFFERENT_TIER(-256),
        GOOD(-16711936),
        LOCKED(-16776961);

        public final int color;

        private TxtColor(int color) {
            this.color = color;
        }
    }
}

