/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.utils;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_5414;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.container.AbstractDankMenu;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.server.C2SMessageToggleUseType;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.ItemHandlerHelper;
import tfar.dankstorage.utils.ItemStackWrapper;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.world.ClientData;
import tfar.dankstorage.world.DankInventory;

public class Utils {
    public static final class_3494<class_1792> BLACKLISTED_STORAGE = TagFactory.ITEM.create(new class_2960("dankstorage", "blacklisted_storage"));
    public static final class_3494<class_1792> BLACKLISTED_USAGE = TagFactory.ITEM.create(new class_2960("dankstorage", "blacklisted_usage"));
    public static final class_3494<class_1792> WRENCHES = TagFactory.ITEM.create(new class_2960("forge", "wrenches"));
    public static final String ID = "dankstorage:id";
    public static final Set<class_2960> taglist = new HashSet<class_2960>();
    public static boolean DEV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final int INVALID = -1;
    public static final String SET = "settings";

    @Nullable
    public static class_2487 getSettings(class_1799 bag) {
        return Utils.hasSettings(bag) ? bag.method_7969().method_10562(SET) : null;
    }

    public static class_2487 getOrCreateSettings(class_1799 bag) {
        if (Utils.hasSettings(bag)) {
            return bag.method_7969().method_10562(SET);
        }
        bag.method_7948().method_10566(SET, (class_2520)new class_2487());
        return Utils.getSettings(bag);
    }

    public static PickupMode getPickupMode(class_1799 bag) {
        class_2487 tag = Utils.getSettings(bag);
        if (tag != null) {
            return PickupMode.PICKUP_MODES[tag.method_10550("mode")];
        }
        return PickupMode.none;
    }

    public static boolean isConstruction(class_1799 bag) {
        class_2487 settings = Utils.getSettings(bag);
        return settings != null && settings.method_10550("construction") == C2SMessageToggleUseType.UseType.construction.ordinal();
    }

    public static DankStats getStatsfromRows(int rows) {
        switch (rows) {
            case 1: {
                return DankStats.one;
            }
            case 2: {
                return DankStats.two;
            }
            case 3: {
                return DankStats.three;
            }
            case 4: {
                return DankStats.four;
            }
            case 5: {
                return DankStats.five;
            }
            case 6: {
                return DankStats.six;
            }
            case 9: {
                return DankStats.seven;
            }
        }
        throw new IllegalStateException(String.valueOf(rows));
    }

    public static void cyclePickupMode(class_1799 bag, class_1657 player) {
        int ordinal = Utils.getOrCreateSettings(bag).method_10550("mode");
        if (++ordinal > PickupMode.PICKUP_MODES.length - 1) {
            ordinal = 0;
        }
        Utils.getOrCreateSettings(bag).method_10569("mode", ordinal);
        player.method_7353((class_2561)new class_2588("dankstorage.mode." + PickupMode.PICKUP_MODES[ordinal].name()), true);
    }

    public static C2SMessageToggleUseType.UseType getUseType(class_1799 bag) {
        class_2487 settings = Utils.getSettings(bag);
        return settings != null ? C2SMessageToggleUseType.useTypes[settings.method_10550("construction")] : C2SMessageToggleUseType.UseType.bag;
    }

    public static void cyclePlacement(class_1799 bag, class_1657 player) {
        class_2487 tag = Utils.getOrCreateSettings(bag);
        int ordinal = tag.method_10550("construction");
        if (++ordinal >= C2SMessageToggleUseType.useTypes.length) {
            ordinal = 0;
        }
        tag.method_10569("construction", ordinal);
        player.method_7353((class_2561)new class_2588("dankstorage.usetype." + C2SMessageToggleUseType.useTypes[ordinal].name()), true);
    }

    public static int getSelectedSlot(class_1799 bag) {
        class_2487 settings = Utils.getSettings(bag);
        return settings != null && settings.method_10545("selectedSlot") ? settings.method_10550("selectedSlot") : -1;
    }

    public static void setSelectedSlot(class_1799 bag, int slot) {
        Utils.getOrCreateSettings(bag).method_10569("selectedSlot", slot);
    }

    public static void setPickSlot(class_1937 level, class_1799 bag, class_1799 stack) {
        int slot;
        DankInventory dankInventory = Utils.getInventory(bag, level);
        if (dankInventory != null && (slot = Utils.findSlotMatchingItem(dankInventory, stack)) != -1) {
            Utils.setSelectedSlot(bag, slot);
        }
    }

    public static int findSlotMatchingItem(DankInventory dankInventory, class_1799 itemStack) {
        for (int i = 0; i < dankInventory.method_5439(); ++i) {
            class_1799 stack = dankInventory.method_5438(i);
            if (stack.method_7960() || !class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
            return i;
        }
        return -1;
    }

    public static void sort(class_1657 player) {
        if (player == null) {
            return;
        }
        class_1703 openContainer = player.field_7512;
        if (openContainer instanceof AbstractDankMenu) {
            DankInventory handler = ((AbstractDankMenu)openContainer).dankInventory;
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (class_1799 stack : handler.getContents()) {
                if (stack.method_7960()) continue;
                Utils.merge(stacks, stack.method_7972(), handler.dankStats.stacklimit);
            }
            List<ItemStackWrapper> wrappers = Utils.wrap(stacks);
            Collections.sort(wrappers);
            handler.method_5448();
            for (int i = 0; i < wrappers.size(); ++i) {
                class_1799 stack = wrappers.get((int)i).stack;
                handler.method_5447(i, stack);
            }
        }
    }

    public static class_1799 getSelectedItem(class_1799 bag, class_1937 level) {
        if (bag.method_7985()) {
            int selected = Utils.getSelectedSlot(bag);
            if (!level.field_9236) {
                DankInventory dankInventory = Utils.getInventory(bag, level);
                if (dankInventory != null) {
                    return dankInventory.method_5438(selected);
                }
            } else {
                return ClientData.selectedItem;
            }
        }
        return class_1799.field_8037;
    }

    public static void merge(List<class_1799> stacks, class_1799 toMerge, int limit) {
        for (class_1799 stack : stacks) {
            int grow;
            if (!ItemHandlerHelper.canItemStacksStack(stack, toMerge) || (grow = Math.min(limit - stack.method_7947(), toMerge.method_7947())) <= 0) continue;
            stack.method_7933(grow);
            toMerge.method_7934(grow);
        }
        if (!toMerge.method_7960()) {
            stacks.add(toMerge);
        }
    }

    public static List<ItemStackWrapper> wrap(List<class_1799> stacks) {
        return stacks.stream().map(ItemStackWrapper::new).collect(Collectors.toList());
    }

    public static DankStats getStats(class_1799 bag) {
        return ((DankItem)bag.method_7909()).stats;
    }

    public static void changeSelectedSlot(class_1799 bag, boolean right, class_3222 player) {
        DankInventory handler = Utils.getInventory(bag, (class_1937)player.method_14220());
        if (handler == null || handler.noValidSlots()) {
            return;
        }
        int selectedSlot = Utils.getSelectedSlot(bag);
        int size = handler.method_5439();
        if (right) {
            if (++selectedSlot >= size) {
                selectedSlot = 0;
            }
        } else if (--selectedSlot < 0) {
            selectedSlot = size - 1;
        }
        class_1799 selected = handler.method_5438(selectedSlot);
        while (selected.method_7960() || selected.method_31573(BLACKLISTED_USAGE)) {
            if (right) {
                if (++selectedSlot >= size) {
                    selectedSlot = 0;
                }
            } else if (--selectedSlot < 0) {
                selectedSlot = size - 1;
            }
            selected = handler.method_5438(selectedSlot);
        }
        if (selectedSlot != -1) {
            Utils.setSelectedSlot(bag, selectedSlot);
            DankPacketHandler.sendSelectedItem(player, selected);
        }
    }

    public static int getFrequency(class_1799 bag) {
        class_2487 settings = Utils.getSettings(bag);
        if (settings != null && settings.method_10545(ID)) {
            return settings.method_10550(ID);
        }
        return -1;
    }

    private static boolean hasSettings(class_1799 bag) {
        return bag.method_7985() && bag.method_7969().method_10545(SET);
    }

    public static boolean oredict(class_1799 bag) {
        return bag.method_7909() instanceof DankItem && bag.method_7985() && Utils.getSettings(bag).method_10577("tag");
    }

    public static DankInventory getOrCreateInventory(class_1799 bag, class_1937 level) {
        if (!level.field_9236) {
            int id = Utils.getFrequency(bag);
            return DankStorage.instance.data.getOrCreateInventory(id, Utils.getStats(bag));
        }
        throw new RuntimeException("Attempted to get inventory on client");
    }

    public static DankInventory getInventory(class_1799 bag, class_1937 level) {
        if (!level.field_9236) {
            int id = Utils.getFrequency(bag);
            return DankStorage.instance.data.getInventory(id);
        }
        throw new RuntimeException("Attempted to get inventory on client");
    }

    public static int getNbtSize(class_1799 stack) {
        return Utils.getNbtSize(stack.method_7969());
    }

    public static DankItem getItemFromTier(int tier) {
        return (DankItem)((Object)class_2378.field_11142.method_10223(new class_2960("dankstorage", "dank_" + tier)));
    }

    public static int getNbtSize(@Nullable class_2487 nbt) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10794(nbt);
        buffer.release();
        return buffer.writerIndex();
    }

    public static class_1799 getItemStackInSelectedSlot(class_1799 bag, class_3218 level) {
        DankInventory inv = Utils.getInventory(bag, (class_1937)level);
        if (inv == null) {
            return class_1799.field_8037;
        }
        class_1799 stack = inv.method_5438(Utils.getSelectedSlot(bag));
        return stack.method_31573(BLACKLISTED_USAGE) ? class_1799.field_8037 : stack;
    }

    public static boolean areItemStacksConvertible(class_1799 stack1, class_1799 stack2) {
        if (stack1.method_7985() || stack2.method_7985()) {
            return false;
        }
        Collection<class_2960> taglistofstack1 = Utils.getTags(stack1.method_7909());
        Collection<class_2960> taglistofstack2 = Utils.getTags(stack2.method_7909());
        HashSet<class_2960> commontags = new HashSet<class_2960>(taglistofstack1);
        commontags.retainAll(taglistofstack2);
        commontags.retainAll(taglist);
        return !commontags.isEmpty();
    }

    public static Collection<class_2960> getTags(class_1792 item) {
        return Utils.getTagsFor((class_5414<class_1792>)class_3489.method_15106(), item);
    }

    public static Collection<class_2960> getTagsFor(class_5414<class_1792> tagGroup, class_1792 item) {
        return tagGroup.method_30204().entrySet().stream().filter(identifierTagEntry -> ((class_3494)identifierTagEntry.getValue()).method_15141((Object)item)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static boolean isHoldingDank(class_1657 player) {
        class_1799 stack = player.method_6047();
        if (stack.method_7909() instanceof DankItem) {
            return true;
        }
        stack = player.method_6079();
        return stack.method_7909() instanceof DankItem;
    }

    public static boolean canMerge(class_1799 first, class_1799 second, class_1263 inventory) {
        if (first.method_7909() != second.method_7909()) {
            return false;
        }
        if (first.method_7919() != second.method_7919()) {
            return false;
        }
        if (first.method_7947() > inventory.method_5444()) {
            return false;
        }
        return class_1799.method_7975((class_1799)first, (class_1799)second);
    }

    public static void warn(class_1657 player, DankStats item, DankStats inventory) {
        player.method_9203((class_2561)new class_2585("Dank Item Level " + item.ordinal() + " cannot open Dank Inventory Level " + inventory.ordinal()), class_156.field_25140);
    }

    @Nullable
    public static class_1268 getHandWithDank(class_1657 player) {
        if (player.method_6047().method_7909() instanceof DankItem) {
            return class_1268.field_5808;
        }
        if (player.method_6079().method_7909() instanceof DankItem) {
            return class_1268.field_5810;
        }
        return null;
    }
}

