/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.util.PropertiesParsingHelper;
import net.minecraft.class_2960;

public class RepeatCTMProperties
extends BaseCTMProperties {
    protected int width;
    protected int height;
    protected Symmetry symmetry = Symmetry.NONE;

    public RepeatCTMProperties(Properties properties, class_2960 id, String packName, int packPriority, String method) {
        super(properties, id, packName, packPriority, method);
    }

    @Override
    public void init() {
        super.init();
        this.parseWidth();
        this.parseHeight();
        this.parseSymmetry();
    }

    protected void parseWidth() {
        String widthStr = this.properties.getProperty("width");
        if (widthStr != null) {
            widthStr = widthStr.trim();
            try {
                int width = Integer.parseInt(widthStr);
                if (width > 0) {
                    this.width = width;
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ContinuityClient.LOGGER.error("Invalid 'width' value '" + widthStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
        }
    }

    protected void parseHeight() {
        String heightStr = this.properties.getProperty("height");
        if (heightStr != null) {
            heightStr = heightStr.trim();
            try {
                int height = Integer.parseInt(heightStr);
                if (height > 0) {
                    this.height = height;
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ContinuityClient.LOGGER.error("Invalid 'height' value '" + heightStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
        }
    }

    protected void parseSymmetry() {
        Symmetry symmetry = PropertiesParsingHelper.parseSymmetry(this.properties, "symmetry", this.id, this.packName);
        if (symmetry != null) {
            this.symmetry = symmetry;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Symmetry getSymmetry() {
        return this.symmetry;
    }
}

