/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.simple;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Random;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.RandomCTMProperties;
import me.pepperbell.continuity.client.util.RandomIndexProvider;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class RandomSpriteProvider
implements SpriteProvider {
    protected class_1058[] sprites;
    protected RandomIndexProvider indexProvider;
    protected int randomLoops;
    protected Symmetry symmetry;
    protected boolean linked;

    public RandomSpriteProvider(class_1058[] sprites, RandomIndexProvider indexProvider, int randomLoops, Symmetry symmetry, boolean linked) {
        this.sprites = sprites;
        this.indexProvider = indexProvider;
        this.randomLoops = randomLoops;
        this.symmetry = symmetry;
        this.linked = linked;
    }

    @Override
    public class_1058 getSprite(QuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, ProcessingDataProvider dataProvider) {
        class_1058 newSprite;
        if (this.sprites.length == 1) {
            newSprite = this.sprites[0];
        } else {
            class_2350 face = this.symmetry.getActualFace(quad.lightFace());
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            if (this.linked) {
                class_2248 block = state.method_26204();
                class_2338.class_2339 mutablePos = dataProvider.getData(ProcessingDataKeys.MUTABLE_POS_KEY).method_10101((class_2382)pos);
                do {
                    mutablePos.method_10098(class_2350.field_11033);
                } while (block == blockView.method_8320((class_2338)mutablePos).method_26204());
                y = mutablePos.method_10264() + 1;
            }
            int hash = RandomSpriteProvider.hash(x, y, z, face.ordinal(), this.randomLoops);
            newSprite = this.sprites[this.indexProvider.getRandomIndex(hash)];
        }
        return newSprite;
    }

    public static int hash(int x, int y, int z, int face, int loops) {
        int hash = Integer.rotateLeft(Long.hashCode(class_3532.method_15371((int)x, (int)y, (int)z)), face * 5);
        hash = HashCommon.mix((int)hash);
        for (int i = 0; i < loops; ++i) {
            hash = HashCommon.mix((int)hash);
        }
        return hash;
    }

    public static class Factory
    implements SpriteProvider.Factory<RandomCTMProperties> {
        @Override
        public SpriteProvider createSpriteProvider(class_1058[] sprites, RandomCTMProperties properties) {
            return new RandomSpriteProvider(sprites, properties.getIndexProviderFactory().createIndexProvider(sprites.length), properties.getRandomLoops(), properties.getSymmetry(), properties.getLinked());
        }

        @Override
        public int getTextureAmount(RandomCTMProperties properties) {
            return properties.getSpriteIds().size();
        }
    }
}

