/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.Random;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.BaseProcessingPredicate;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.HorizontalQuadProcessor;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.properties.ConnectingCTMProperties;
import me.pepperbell.continuity.client.util.DirectionMaps;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public class HorizontalVerticalQuadProcessor
extends HorizontalQuadProcessor {
    protected static final int[] SPRITE_INDEX_MAP_1 = new int[]{3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 4, 4, 5, 4, 4, 4, 4, 4, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3};

    public HorizontalVerticalQuadProcessor(class_1058[] sprites, ProcessingPredicate processingPredicate, ConnectionPredicate connectionPredicate) {
        super(sprites, processingPredicate, connectionPredicate);
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, int pass, int processorIndex, QuadProcessor.ProcessingContext context) {
        class_1058 newSprite;
        class_2338.class_2339 mutablePos;
        class_2350[] directions = DirectionMaps.getDirections((QuadView)quad);
        int connections = this.getConnections(directions, mutablePos = context.getData(ProcessingDataKeys.MUTABLE_POS_KEY), blockView, state, pos, quad.lightFace(), sprite);
        if (connections != 0) {
            newSprite = this.sprites[SPRITE_INDEX_MAP[connections]];
        } else {
            connections = this.getConnections1(directions, mutablePos, blockView, state, pos, quad.lightFace(), sprite);
            newSprite = this.sprites[SPRITE_INDEX_MAP_1[connections]];
        }
        return SimpleQuadProcessor.process(quad, sprite, newSprite);
    }

    protected int getConnections1(class_2350[] directions, class_2338.class_2339 mutablePos, class_1920 blockView, class_2680 state, class_2338 pos, class_2350 face, class_1058 quadSprite) {
        int i;
        mutablePos.method_10101((class_2382)pos);
        int connections = 0;
        for (i = 0; i < 2; ++i) {
            mutablePos.method_10098(directions[i * 2 + 1]);
            if (this.connectionPredicate.shouldConnect(state, quadSprite, pos, (class_2338)mutablePos, face, blockView)) {
                connections |= 1 << i * 3 + 1;
            }
            mutablePos.method_10101((class_2382)pos);
        }
        for (i = 0; i < 4; ++i) {
            int shift = i / 2 * 3 + 1;
            int index1 = i;
            int index2 = (i + 1) % 4;
            if ((connections >> shift & 1) != 1) continue;
            mutablePos.method_10098(directions[index1]).method_10098(directions[index2]);
            if (this.connectionPredicate.shouldConnect(state, quadSprite, pos, (class_2338)mutablePos, face, blockView)) {
                int shift1 = i % 2;
                if (shift1 <= 0) {
                    --shift1;
                }
                connections |= 1 << shift + shift1;
            }
            mutablePos.method_10101((class_2382)pos);
        }
        return connections;
    }

    public static class Factory
    extends AbstractQuadProcessorFactory<ConnectingCTMProperties> {
        @Override
        public QuadProcessor createProcessor(ConnectingCTMProperties properties, class_1058[] sprites) {
            return new HorizontalVerticalQuadProcessor(sprites, BaseProcessingPredicate.fromProperties(properties), properties.getConnectionPredicate());
        }

        @Override
        public int getTextureAmount(ConnectingCTMProperties properties) {
            return 7;
        }
    }
}

