/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.helper.ColorHelper;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_761;

public class BaseQuadRenderer {
    static final int FULL_BRIGHTNESS = 0xF000F0;
    protected final QuadBufferer bufferer;
    protected final BlockRenderInfo blockInfo;
    protected final AoCalculator aoCalc;
    protected final RenderContext.QuadTransform transform;
    private final class_2338.class_2339 mpos = new class_2338.class_2339();

    BaseQuadRenderer(QuadBufferer bufferer, BlockRenderInfo blockInfo, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        this.bufferer = bufferer;
        this.blockInfo = blockInfo;
        this.aoCalc = aoCalc;
        this.transform = transform;
    }

    private void colorizeQuad(MutableQuadViewImpl q, int blockColorIndex) {
        if (blockColorIndex == -1) {
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(q.spriteColor(i, 0)));
            }
        } else {
            int blockColor = this.blockInfo.blockColor(blockColorIndex);
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(ColorHelper.multiplyColor(blockColor, q.spriteColor(i, 0))));
            }
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, class_1921 renderLayer) {
        this.bufferer.bufferQuad(quad, renderLayer);
    }

    protected void tesselateSmooth(MutableQuadViewImpl q, class_1921 renderLayer, int blockColorIndex) {
        this.colorizeQuad(q, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), this.aoCalc.ao[i]));
            q.lightmap(i, ColorHelper.maxBrightness(q.lightmap(i), this.aoCalc.light[i]));
        }
        this.bufferQuad(q, renderLayer);
    }

    protected void tesselateSmoothEmissive(MutableQuadViewImpl q, class_1921 renderLayer, int blockColorIndex) {
        this.colorizeQuad(q, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), this.aoCalc.ao[i]));
            q.lightmap(i, 0xF000F0);
        }
        this.bufferQuad(q, renderLayer);
    }

    protected void tesselateFlat(MutableQuadViewImpl quad, class_1921 renderLayer, int blockColorIndex) {
        this.colorizeQuad(quad, blockColorIndex);
        this.shadeFlatQuad(quad);
        int brightness = this.flatBrightness(quad, this.blockInfo.blockState, this.blockInfo.blockPos);
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), brightness));
        }
        this.bufferQuad(quad, renderLayer);
    }

    protected void tesselateFlatEmissive(MutableQuadViewImpl quad, class_1921 renderLayer, int blockColorIndex) {
        this.colorizeQuad(quad, blockColorIndex);
        this.shadeFlatQuad(quad);
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, 0xF000F0);
        }
        this.bufferQuad(quad, renderLayer);
    }

    int flatBrightness(MutableQuadViewImpl quad, class_2680 blockState, class_2338 pos) {
        this.mpos.method_10101((class_2382)pos);
        if (quad.cullFace() != null) {
            this.mpos.method_10098(quad.cullFace());
        } else if ((quad.geometryFlags() & 4) != 0 || class_2248.method_9614((class_265)blockState.method_26220((class_1922)this.blockInfo.blockView, pos))) {
            this.mpos.method_10098(quad.lightFace());
        }
        return class_761.method_23793((class_1920)this.blockInfo.blockView, (class_2680)blockState, (class_2338)this.mpos);
    }

    private void shadeFlatQuad(MutableQuadViewImpl quad) {
        block3: {
            block2: {
                if ((quad.geometryFlags() & 2) != 0 && !quad.hasVertexNormals()) break block2;
                float faceShade = this.blockInfo.blockView.method_24852(quad.lightFace(), quad.hasShade());
                for (int i = 0; i < 4; ++i) {
                    quad.spriteColor(i, 0, ColorHelper.multiplyRGB(quad.spriteColor(i, 0), this.vertexShade(quad, i, faceShade)));
                }
                break block3;
            }
            float diffuseShade = this.blockInfo.blockView.method_24852(quad.lightFace(), quad.hasShade());
            if (diffuseShade == 1.0f) break block3;
            for (int i = 0; i < 4; ++i) {
                quad.spriteColor(i, 0, ColorHelper.multiplyRGB(quad.spriteColor(i, 0), diffuseShade));
            }
        }
    }

    private float vertexShade(MutableQuadViewImpl quad, int vertexIndex, float faceShade) {
        return quad.hasNormal(vertexIndex) ? this.normalShade(quad.normalX(vertexIndex), quad.normalY(vertexIndex), quad.normalZ(vertexIndex), quad.hasShade()) : faceShade;
    }

    private float normalShade(float normalX, float normalY, float normalZ, boolean hasShade) {
        float sum = 0.0f;
        float div = 0.0f;
        if (normalX > 0.0f) {
            sum += normalX * this.blockInfo.blockView.method_24852(class_2350.field_11034, hasShade);
            div += normalX;
        } else if (normalX < 0.0f) {
            sum += -normalX * this.blockInfo.blockView.method_24852(class_2350.field_11039, hasShade);
            div -= normalX;
        }
        if (normalY > 0.0f) {
            sum += normalY * this.blockInfo.blockView.method_24852(class_2350.field_11036, hasShade);
            div += normalY;
        } else if (normalY < 0.0f) {
            sum += -normalY * this.blockInfo.blockView.method_24852(class_2350.field_11033, hasShade);
            div -= normalY;
        }
        if (normalZ > 0.0f) {
            sum += normalZ * this.blockInfo.blockView.method_24852(class_2350.field_11035, hasShade);
            div += normalZ;
        } else if (normalZ < 0.0f) {
            sum += -normalZ * this.blockInfo.blockView.method_24852(class_2350.field_11043, hasShade);
            div -= normalZ;
        }
        return sum / div;
    }

    protected static interface QuadBufferer {
        public void bufferQuad(MutableQuadViewImpl var1, class_1921 var2);
    }
}

