/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import link.infra.indium.renderer.IndiumRenderer;
import link.infra.indium.renderer.RenderMaterialImpl;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BaseQuadRenderer;
import link.infra.indium.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_777;

public class BaseFallbackConsumer
extends BaseQuadRenderer
implements Consumer<class_1087> {
    private static RenderMaterialImpl.Value MATERIAL_FLAT = (RenderMaterialImpl.Value)IndiumRenderer.INSTANCE.materialFinder().disableAo(0, true).find();
    private static RenderMaterialImpl.Value MATERIAL_SHADED = (RenderMaterialImpl.Value)IndiumRenderer.INSTANCE.materialFinder().find();
    private final int[] editorBuffer = new int[EncodingFormat.TOTAL_STRIDE];
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = BaseFallbackConsumer.this.editorBuffer;
            this.material(MATERIAL_SHADED);
        }

        public QuadEmitter emit() {
            throw new UnsupportedOperationException("Fallback consumer does not support .emit()");
        }
    };

    BaseFallbackConsumer(BaseQuadRenderer.QuadBufferer bufferer, BlockRenderInfo blockInfo, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        super(bufferer, blockInfo, aoCalc, transform);
    }

    @Override
    public void accept(class_1087 model) {
        Supplier<Random> random = this.blockInfo.randomSupplier;
        RenderMaterialImpl.Value defaultMaterial = this.blockInfo.defaultAo && model.method_4708() ? MATERIAL_SHADED : MATERIAL_FLAT;
        class_2680 blockState = this.blockInfo.blockState;
        for (int i = 0; i < 6; ++i) {
            class_2350 face = ModelHelper.faceFromIndex((int)i);
            List quads = model.method_4707(blockState, face, random.get());
            int count = quads.size();
            if (count == 0) continue;
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                this.renderQuad(q, face, defaultMaterial);
            }
        }
        List quads = model.method_4707(blockState, null, random.get());
        int count = quads.size();
        if (count != 0) {
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                this.renderQuad(q, null, defaultMaterial);
            }
        }
    }

    private void renderQuad(class_777 quad, class_2350 cullFace, RenderMaterialImpl.Value defaultMaterial) {
        MutableQuadViewImpl editorQuad = this.editorQuad;
        editorQuad.fromVanilla(quad, defaultMaterial, cullFace);
        if (!this.transform.transform((MutableQuadView)editorQuad)) {
            return;
        }
        cullFace = editorQuad.cullFace();
        if (cullFace != null && !this.blockInfo.shouldDrawFace(cullFace)) {
            return;
        }
        if (!editorQuad.material().disableAo(0)) {
            this.aoCalc.compute(editorQuad, true);
            this.tesselateSmooth(editorQuad, this.blockInfo.defaultLayer, editorQuad.colorIndex());
        } else {
            if (cullFace == null) {
                editorQuad.geometryFlags();
            }
            this.tesselateFlat(editorQuad, this.blockInfo.defaultLayer, editorQuad.colorIndex());
        }
    }
}

