/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.thonkutil.config;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.jab125.thonkutil.ThonkUtil;
import com.jab125.thonkutil.config.ThonkUtilTradeConfig;
import com.jab125.thonkutil.config.option.BooleanConfigOption;
import com.jab125.thonkutil.config.option.ConfigOptionStorage;
import com.jab125.thonkutil.config.option.EnumConfigOption;
import com.jab125.thonkutil.config.option.SliderConfigOption;
import com.jab125.thonkutil.config.option.StringSetConfigOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;

public class ThonkUtilTradeConfigManager {
    private static File file;

    private static void prepareConfigFile() {
        if (file != null) {
            return;
        }
        file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "thonkutil-trades-v1.json");
    }

    public static void initializeConfig() {
        ThonkUtilTradeConfigManager.load();
    }

    private static void load() {
        ThonkUtilTradeConfigManager.prepareConfigFile();
        try {
            if (!file.exists()) {
                ThonkUtilTradeConfigManager.save();
            }
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(file));
                JsonObject json = new JsonParser().parse((Reader)br).getAsJsonObject();
                for (Field field : ThonkUtilTradeConfig.class.getDeclaredFields()) {
                    Type generic;
                    JsonPrimitive jsonPrimitive;
                    StringSetConfigOption option;
                    if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                    if (StringSetConfigOption.class.isAssignableFrom(field.getType())) {
                        JsonArray jsonArray = json.getAsJsonArray(field.getName().toLowerCase(Locale.ROOT));
                        if (jsonArray == null) continue;
                        option = (StringSetConfigOption)field.get(null);
                        ConfigOptionStorage.setStringSet((String)option.getKey(), Sets.newHashSet((Iterable)jsonArray).stream().map(JsonElement::getAsString).collect(Collectors.toSet()));
                        continue;
                    }
                    if (BooleanConfigOption.class.isAssignableFrom(field.getType())) {
                        jsonPrimitive = json.getAsJsonPrimitive(field.getName().toLowerCase(Locale.ROOT));
                        if (jsonPrimitive == null || !jsonPrimitive.isBoolean()) continue;
                        option = (BooleanConfigOption)field.get(null);
                        ConfigOptionStorage.setBoolean((String)option.getKey(), (boolean)jsonPrimitive.getAsBoolean());
                        continue;
                    }
                    if (SliderConfigOption.class.isAssignableFrom(field.getType())) {
                        jsonPrimitive = json.getAsJsonPrimitive(field.getName().toLowerCase(Locale.ROOT));
                        if (jsonPrimitive == null || !jsonPrimitive.isNumber()) continue;
                        option = (SliderConfigOption)field.get(null);
                        ConfigOptionStorage.setDouble((String)option.getKey(), (double)jsonPrimitive.getAsDouble());
                        continue;
                    }
                    if (!EnumConfigOption.class.isAssignableFrom(field.getType()) || !(field.getGenericType() instanceof ParameterizedType) || (jsonPrimitive = json.getAsJsonPrimitive(field.getName().toLowerCase(Locale.ROOT))) == null || !jsonPrimitive.isString() || !((generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                    EnumConfigOption option2 = (EnumConfigOption)field.get(null);
                    Enum found = null;
                    for (Enum value : (Enum[])((Class)generic).getEnumConstants()) {
                        if (!value.name().toLowerCase(Locale.ROOT).equals(jsonPrimitive.getAsString())) continue;
                        found = value;
                        break;
                    }
                    if (found == null) continue;
                    ConfigOptionStorage.setEnumTypeless((String)option2.getKey(), found);
                }
            }
        }
        catch (FileNotFoundException | IllegalAccessException e) {
            System.err.println("Couldn't load ThonkUtil configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static void save() {
        ThonkUtilTradeConfigManager.prepareConfigFile();
        JsonObject config = new JsonObject();
        try {
            for (Field field : ThonkUtilTradeConfig.class.getDeclaredFields()) {
                Type generic;
                BooleanConfigOption option;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                if (BooleanConfigOption.class.isAssignableFrom(field.getType())) {
                    option = (BooleanConfigOption)field.get(null);
                    config.addProperty(field.getName().toLowerCase(Locale.ROOT), Boolean.valueOf(ConfigOptionStorage.getBoolean((String)option.getKey())));
                }
                if (SliderConfigOption.class.isAssignableFrom(field.getType())) {
                    option = (SliderConfigOption)field.get(null);
                    config.addProperty(field.getName().toLowerCase(Locale.ROOT), (Number)ConfigOptionStorage.getDouble((String)option.getKey()));
                    continue;
                }
                if (StringSetConfigOption.class.isAssignableFrom(field.getType())) {
                    option = (StringSetConfigOption)field.get(null);
                    JsonArray array = new JsonArray();
                    ConfigOptionStorage.getStringSet((String)option.getKey()).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                    config.add(field.getName().toLowerCase(Locale.ROOT), (JsonElement)array);
                    continue;
                }
                if (!EnumConfigOption.class.isAssignableFrom(field.getType()) || !(field.getGenericType() instanceof ParameterizedType) || !((generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                EnumConfigOption option2 = (EnumConfigOption)field.get(null);
                config.addProperty(field.getName().toLowerCase(Locale.ROOT), ConfigOptionStorage.getEnumTypeless((String)option2.getKey(), (Class)((Class)generic)).name().toLowerCase(Locale.ROOT));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String jsonString = ThonkUtil.GSON.toJson((JsonElement)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save ThonkUtil configuration file");
            e.printStackTrace();
        }
    }
}

