/*
 * Decompiled with CFR 0.152.
 */
package com.shnupbups.simpleteleporters.block.entity;

import com.shnupbups.simpleteleporters.init.SimpleTeleportersBlockEntities;
import com.shnupbups.simpleteleporters.item.TeleportCrystalItem;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class TeleporterBlockEntity
extends class_2586 {
    private class_1799 crystal = class_1799.field_8037;
    private int cooldown = 0;

    public TeleporterBlockEntity(class_2338 pos, class_2680 state) {
        super(SimpleTeleportersBlockEntities.TELEPORTER, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TeleporterBlockEntity teleporter) {
        if (teleporter.isCoolingDown()) {
            teleporter.incrementCooldown();
        }
    }

    public boolean hasCrystal() {
        return !this.getCrystal().method_7960();
    }

    public boolean isInDimension(class_1297 entity) {
        if (this.getCrystal().method_7960()) {
            return false;
        }
        class_2487 nbt = this.getCrystal().method_7969();
        return TeleportCrystalItem.getDimensionKey(nbt).equals((Object)entity.method_37908().method_27983());
    }

    public class_1799 getCrystal() {
        return this.crystal;
    }

    public void setCrystal(class_1799 crystal) {
        this.crystal = crystal;
        this.method_5431();
        if (this.method_10997() != null) {
            class_2680 state = this.method_10997().method_8320(this.method_11016());
            this.method_10997().method_8413(this.method_11016(), state, state, 3);
        }
    }

    public class_2338 getTeleportPos() {
        if (!this.hasCrystal()) {
            return null;
        }
        class_2487 nbt = this.getCrystalNbt();
        return TeleportCrystalItem.getPosition(nbt);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("crystal")) {
            this.setCrystal(class_1799.method_7915((class_2487)nbt.method_10562("crystal")));
        } else {
            this.setCrystal(class_1799.field_8037);
        }
        if (nbt.method_10545("cooldown")) {
            this.setCooldown(nbt.method_10550("cooldown"));
        } else {
            this.setCooldown(0);
        }
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (!this.crystal.method_7960()) {
            nbt.method_10566("crystal", (class_2520)this.crystal.method_7953(new class_2487()));
        }
        nbt.method_10569("cooldown", this.cooldown);
    }

    public boolean isCoolingDown() {
        return this.getCooldown() > 0;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void incrementCooldown() {
        this.setCooldown(this.getCooldown() - 1);
    }

    public class_2487 getCrystalNbt() {
        if (!this.hasCrystal()) {
            return null;
        }
        return this.getCrystal().method_7969();
    }
}

