/*
 * Decompiled with CFR 0.152.
 */
package com.shnupbups.simpleteleporters.block;

import com.shnupbups.simpleteleporters.block.entity.TeleporterBlockEntity;
import com.shnupbups.simpleteleporters.init.SimpleTeleportersBlockEntities;
import com.shnupbups.simpleteleporters.init.SimpleTeleportersItems;
import com.shnupbups.simpleteleporters.init.SimpleTeleportersSoundEvents;
import com.shnupbups.simpleteleporters.item.TeleportCrystalItem;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;

public class TeleporterBlock
extends class_2237 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 ON = class_2746.method_11825((String)"on");
    protected static final class_265 SHAPE = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.38, (double)1.0);

    public TeleporterBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)ON, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        if (entity instanceof class_3222) {
            class_2586 class_25862;
            class_3222 player = (class_3222)entity;
            if (!world.method_8608() && entity.method_5715() && (class_25862 = world.method_8321(pos)) instanceof TeleporterBlockEntity) {
                TeleporterBlockEntity teleporter = (TeleporterBlockEntity)class_25862;
                if (!teleporter.hasCrystal()) {
                    player.method_7353((class_2561)new class_2588("text.simpleteleporters.error.no_crystal").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), true);
                } else if (!teleporter.isInDimension(entity)) {
                    player.method_7353((class_2561)new class_2588("text.simpleteleporters.error.wrong_dimension").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), true);
                } else if (!teleporter.isCoolingDown()) {
                    class_2338 teleportPos = teleporter.getTeleportPos();
                    if (teleportPos == null) {
                        player.method_7353((class_2561)new class_2588("text.simpleteleporters.error.unlinked_teleporter").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), true);
                    } else if (world.method_8320(teleportPos).method_26228((class_1922)world, teleportPos)) {
                        player.method_7353((class_2561)new class_2588("text.simpleteleporters.error.invalid_position").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), true);
                    } else {
                        player.field_6037 = true;
                        class_243 playerPos = new class_243((double)teleportPos.method_10263() + 0.5, (double)teleportPos.method_10264(), (double)teleportPos.method_10260() + 0.5);
                        player.field_13987.method_14363(playerPos.method_10216(), playerPos.method_10214(), playerPos.method_10215(), entity.method_36454(), entity.method_36455());
                        player.method_18800(0.0, 0.0, 0.0);
                        player.field_6007 = true;
                        world.method_8449(null, (class_1297)player, SimpleTeleportersSoundEvents.TELEPORTER_TELEPORT, class_3419.field_15245, 1.0f, 1.0f);
                        teleporter.setCooldown(10);
                        class_2586 down = world.method_8321(teleportPos.method_10074());
                        if (down instanceof TeleporterBlockEntity) {
                            TeleporterBlockEntity tpDown = (TeleporterBlockEntity)down;
                            tpDown.setCooldown(10);
                        }
                    }
                }
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TeleporterBlockEntity) {
            TeleporterBlockEntity teleporter = (TeleporterBlockEntity)class_25862;
            if (teleporter.hasCrystal()) {
                class_1799 crystalStack = teleporter.getCrystal();
                if (!player.method_7270(crystalStack)) {
                    player.method_7328(crystalStack, false);
                }
                player.method_5783(SimpleTeleportersSoundEvents.TELEPORTER_CRYSTAL_REMOVED, 0.5f, 0.4f / (world.field_9229.nextFloat() * 0.4f + 0.8f));
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)ON, (Comparable)Boolean.valueOf(false)));
                teleporter.setCrystal(class_1799.field_8037);
                world.method_32888((class_1297)player, class_5712.field_28733, pos);
                return class_1269.field_5812;
            }
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960() && stack.method_7909() == SimpleTeleportersItems.ENDER_SHARD) {
                if (TeleportCrystalItem.hasPosition(stack.method_7969())) {
                    player.method_5783(SimpleTeleportersSoundEvents.TELEPORTER_CRYSTAL_INSERTED, 0.5f, 0.4f / (world.field_9229.nextFloat() * 0.4f + 0.8f));
                    world.method_8501(pos, (class_2680)state.method_11657((class_2769)ON, (Comparable)Boolean.valueOf(true)));
                    class_1799 crystal = stack.method_7972();
                    crystal.method_7939(1);
                    teleporter.setCrystal(crystal);
                    stack.method_7934(1);
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)new class_2588("text.simpleteleporters.error.unlinked_shard").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), true);
            }
        }
        return class_1269.field_5811;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        TeleporterBlockEntity teleporter;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TeleporterBlockEntity && (teleporter = (TeleporterBlockEntity)class_25862).hasCrystal()) {
            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)teleporter.getCrystal());
        }
        super.method_9576(world, pos, state, player);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, facing, neighborState, world, pos, neighborPos);
    }

    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return SHAPE;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ON}).method_11667(new class_2769[]{WATERLOGGED});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TeleporterBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random random) {
        if (((Boolean)state.method_11654((class_2769)ON)).booleanValue()) {
            for (int i = 0; i < 15; ++i) {
                world.method_8406((class_2394)class_2398.field_11214, (double)((float)pos.method_10263() + 0.2f + random.nextFloat() / 2.0f), (double)((float)pos.method_10264() + 0.4f), (double)((float)pos.method_10260() + 0.2f + random.nextFloat() / 2.0f), 0.0, (double)random.nextFloat(), 0.0);
            }
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        boolean isWater = fluidState.method_15772().equals(class_3612.field_15910);
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return TeleporterBlock.method_31618(type, SimpleTeleportersBlockEntities.TELEPORTER, (class_5558)(world.method_8608() ? null : TeleporterBlockEntity::tick));
    }
}

