/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome.modification;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_3195;
import net.minecraft.class_5284;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BiomeStructureStartsImpl {
    private BiomeStructureStartsImpl() {
    }

    public static void addStart(class_5455 registries, class_5312<?, ?> configuredStructure, class_5321<class_1959> biome) {
        BiomeStructureStartsImpl.changeStructureStarts(registries, structureMap -> {
            Multimap configuredMap = structureMap.computeIfAbsent(configuredStructure.field_24835, k -> HashMultimap.create());
            class_5321 configuredStructureKey = (class_5321)registries.method_30530(class_2378.field_25915).method_29113((Object)configuredStructure).orElseThrow();
            class_5312 mapKey = (class_5312)class_5458.field_25930.method_29107(configuredStructureKey);
            if (mapKey == null) {
                mapKey = configuredStructure;
            }
            configuredMap.put((Object)mapKey, (Object)biome);
        });
    }

    public static boolean removeStart(class_5455 registries, class_5312<?, ?> configuredStructure, class_5321<class_1959> biome) {
        AtomicBoolean result = new AtomicBoolean(false);
        BiomeStructureStartsImpl.changeStructureStarts(registries, structureMap -> {
            Multimap configuredMap = (Multimap)structureMap.get(configuredStructure.field_24835);
            if (configuredMap == null) {
                return;
            }
            class_5321 configuredStructureKey = (class_5321)registries.method_30530(class_2378.field_25915).method_29113((Object)configuredStructure).orElseThrow();
            class_5312 mapKey = (class_5312)class_5458.field_25930.method_29107(configuredStructureKey);
            if (mapKey == null) {
                mapKey = configuredStructure;
            }
            if (configuredMap.remove((Object)mapKey, (Object)biome)) {
                result.set(true);
            }
        });
        return result.get();
    }

    public static boolean removeStructureStarts(class_5455 registries, class_3195<?> structure, class_5321<class_1959> biome) {
        AtomicBoolean result = new AtomicBoolean(false);
        BiomeStructureStartsImpl.changeStructureStarts(registries, structureMap -> {
            Multimap configuredMap = (Multimap)structureMap.get(structure);
            if (configuredMap == null) {
                return;
            }
            if (configuredMap.values().remove(biome)) {
                result.set(true);
            }
        });
        return result.get();
    }

    private static void changeStructureStarts(class_5455 registries, Consumer<Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>>> modifier) {
        class_2378 chunkGenSettingsRegistry = registries.method_30530(class_2378.field_26374);
        for (Map.Entry entry : chunkGenSettingsRegistry.method_29722()) {
            Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> structureMap = BiomeStructureStartsImpl.unfreeze((class_5284)entry.getValue());
            modifier.accept(structureMap);
            BiomeStructureStartsImpl.freeze((class_5284)entry.getValue(), structureMap);
        }
    }

    private static Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> unfreeze(class_5284 settings) {
        ImmutableMap frozenMap = settings.method_28007().field_34696;
        HashMap result = new HashMap(frozenMap.size());
        for (Map.Entry entry : frozenMap.entrySet()) {
            result.put((class_3195<?>)((class_3195)entry.getKey()), (Multimap<class_5312<?, ?>, class_5321<class_1959>>)HashMultimap.create((Multimap)((Multimap)entry.getValue())));
        }
        return result;
    }

    private static void freeze(class_5284 settings, Map<class_3195<?>, Multimap<class_5312<?, ?>, class_5321<class_1959>>> structureStarts) {
        settings.method_28007().field_34696 = (ImmutableMap)structureStarts.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ImmutableMultimap.copyOf((Multimap)((Multimap)e.getValue()))));
    }
}

